/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.blocks;

import com.google.gson.Gson;
import com.keerdm.item_scrapper.blocks.ScrapperBlockEntity;
import com.keerdm.item_scrapper.blocks.ScrapperEffects;
import com.keerdm.item_scrapper.blocks.TACZCustomRecipeLoader;
import com.keerdm.item_scrapper.configs.CommonConfig;
import com.keerdm.item_scrapper.configs.RoundingType;
import com.keerdm.item_scrapper.configs.json.Scrapper_conversionsConfig;
import com.keerdm.item_scrapper.data.ScrapperDataManager;
import com.keerdm.item_scrapper.integration.PointBlankHelper;
import com.keerdm.item_scrapper.util.ItemScrapperLogger;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemStackHandler;

public class ScrapperLogic {
    private final ScrapperBlockEntity blockEntity;
    private double currentHits = 0.0;
    private long lastHitTime = 0L;
    public int lastHitTimeTicks = 0;
    private static final long HIT_RESET_TIME = 20000L;

    public ScrapperLogic(ScrapperBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public void addHit(float attackStrength, Level level) {
        this.lastHitTimeTicks = 0;
        ItemStack stackToScrap = this.blockEntity.getInputItemHandler().getStackInSlot(0);
        if (stackToScrap.m_41619_()) {
            return;
        }
        String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stackToScrap.m_41720_()).toString();
        Scrapper_conversionsConfig.ScrapConfig config = ScrapperDataManager.getConfigForItem(itemId, stackToScrap.m_41783_());
        if (config == null) {
            return;
        }
        if (level != null && !level.m_5776_() && this.checkAndHandleExplosion(config, level)) {
            return;
        }
        this.updateHitProgress(attackStrength);
        if (level != null && !level.m_5776_()) {
            ScrapperEffects.playHitEffects(level, this.blockEntity.m_58899_(), attackStrength);
        }
        this.tryScrap();
    }

    private boolean checkAndHandleExplosion(Scrapper_conversionsConfig.ScrapConfig config, Level level) {
        double randomValue = level.m_213780_().m_188500_() * 100.0;
        if (randomValue < config.explosionChance) {
            this.clearInventories();
            this.createExplosion(config, level);
            return true;
        }
        return false;
    }

    private void clearInventories() {
        int i;
        ItemStackHandler inputHandler = this.blockEntity.getInputItemHandler();
        ItemStackHandler outputHandler = this.blockEntity.getOutputItemHandler();
        for (i = 0; i < inputHandler.getSlots(); ++i) {
            inputHandler.extractItem(i, inputHandler.getStackInSlot(i).m_41613_(), false);
        }
        for (i = 0; i < outputHandler.getSlots(); ++i) {
            outputHandler.extractItem(i, outputHandler.getStackInSlot(i).m_41613_(), false);
        }
    }

    private void createExplosion(Scrapper_conversionsConfig.ScrapConfig config, Level level) {
        Vec3 position = new Vec3((double)this.blockEntity.m_58899_().m_123341_() + 0.5, (double)this.blockEntity.m_58899_().m_123342_() + 0.5, (double)this.blockEntity.m_58899_().m_123343_() + 0.5);
        level.m_255391_(null, position.f_82479_, position.f_82480_, position.f_82481_, (float)config.explosionPower, false, Level.ExplosionInteraction.TNT);
    }

    private void updateHitProgress(float attackStrength) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastHitTime > 20000L) {
            this.currentHits = 0.0;
        }
        this.currentHits += (double)attackStrength;
        this.lastHitTime = currentTime;
        this.blockEntity.m_6596_();
    }

    private void tryScrap() {
        String itemId;
        Scrapper_conversionsConfig.ScrapConfig config;
        Level level = this.blockEntity.m_58904_();
        if (level == null || level.m_5776_()) {
            return;
        }
        ItemStack stackToScrap = this.blockEntity.getInputItemHandler().getStackInSlot(0);
        if (!stackToScrap.m_41619_() && (config = ScrapperDataManager.getConfigForItem(itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stackToScrap.m_41720_()).toString(), stackToScrap.m_41783_())) != null && this.currentHits >= config.requiredHits) {
            this.performScrapping(config);
            this.currentHits = 0.0;
            this.blockEntity.m_6596_();
        }
    }

    private void performScrapping(Scrapper_conversionsConfig.ScrapConfig config) {
        Level level = this.blockEntity.m_58904_();
        if (level == null || level.m_5776_()) {
            return;
        }
        ItemStack stackToScrap = this.blockEntity.getInputItemHandler().getStackInSlot(0);
        if (!stackToScrap.m_41619_() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ScrapperEffects.playScrapSuccessEffects(level, this.blockEntity.m_58899_());
            try {
                List<ItemStack> lootItems = config.lootable.isAutoGenerateFromRecipe() ? this.generateRecipeLoot(serverLevel, config, stackToScrap) : this.generateLootTableLoot(serverLevel, config, stackToScrap);
                this.processLootItems(lootItems);
            }
            catch (Exception e) {
                System.err.println("Error during scrapping: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void processLootItems(List<ItemStack> lootItems) {
        ItemStackHandler outputHandler = this.blockEntity.getOutputItemHandler();
        Level level = this.blockEntity.m_58904_();
        for (ItemStack lootItem : lootItems) {
            ItemStack remainingItem = lootItem.m_41777_();
            for (int i = 0; i < outputHandler.getSlots() && !remainingItem.m_41619_(); ++i) {
                remainingItem = outputHandler.insertItem(i, remainingItem, false);
            }
            if (remainingItem.m_41619_() || level == null) continue;
            Containers.m_18992_((Level)level, (double)this.blockEntity.m_58899_().m_123341_(), (double)this.blockEntity.m_58899_().m_123342_(), (double)this.blockEntity.m_58899_().m_123343_(), (ItemStack)remainingItem);
        }
    }

    private List<ItemStack> generateRecipeLoot(ServerLevel serverLevel, Scrapper_conversionsConfig.ScrapConfig config, ItemStack stackToScrap) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        HashMap<Item, Integer> totalIngredients = new HashMap<Item, Integer>();
        for (String recipeId : config.lootable.getRecipeIds()) {
            ResourceLocation recipeLocation = new ResourceLocation(recipeId);
            Optional recipeOptional = serverLevel.m_7654_().m_129894_().m_44043_(recipeLocation);
            if (recipeOptional.isPresent()) {
                HashMap<Item, Integer> recipeIngredients;
                Recipe recipe = (Recipe)recipeOptional.get();
                boolean recipeProcessed = false;
                if (recipe.m_6671_().toString().equals("pointblank:default") || recipe.m_6671_().toString().equals("default")) {
                    try {
                        boolean processed;
                        recipeIngredients = new HashMap<Item, Integer>();
                        boolean bl = processed = PointBlankHelper.isPointBlankLoaded() && recipe.getClass().getName().contains("pointblank") && PointBlankHelper.processPointBlankRecipe(recipe, recipeIngredients);
                        if (processed) {
                            recipeIngredients.forEach((item, count) -> totalIngredients.merge((Item)item, (Integer)count, Integer::sum));
                            recipeProcessed = true;
                        }
                    }
                    catch (Exception e) {
                        ItemScrapperLogger.errorLog("Error processing PointBlank recipe: " + e.getMessage());
                    }
                }
                if (!recipeProcessed && recipe instanceof CraftingRecipe) {
                    CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
                    HashMap<Item, Integer> recipeIngredients2 = new HashMap<Item, Integer>();
                    NonNullList ingredients = craftingRecipe.m_7527_();
                    this.collectIngredientsFromList((NonNullList<Ingredient>)ingredients, recipeIngredients2);
                    recipeIngredients2.forEach((item, count) -> totalIngredients.merge((Item)item, (Integer)count, Integer::sum));
                    recipeProcessed = true;
                }
                if (!recipeProcessed) {
                    recipeIngredients = new HashMap();
                    this.tryReflectionIngredients(recipe, recipeIngredients);
                    recipeIngredients.forEach((item, count) -> totalIngredients.merge((Item)item, (Integer)count, Integer::sum));
                    recipeProcessed = true;
                }
                if (recipeProcessed) continue;
                this.handleRecipeResultFallback(recipe, serverLevel, config, results);
                continue;
            }
            this.tryLoadCustomRecipe(serverLevel, recipeLocation, config, results);
        }
        if (!totalIngredients.isEmpty()) {
            this.processIngredients(totalIngredients, serverLevel, config, results);
        }
        return results;
    }

    private void tryReflectionIngredients(Recipe<?> recipe, Map<Item, Integer> totalIngredients) {
        try {
            Method getIngredientsMethod = recipe.getClass().getMethod("getIngredients", new Class[0]);
            Object ingredientsList = getIngredientsMethod.invoke(recipe, new Object[0]);
            if (ingredientsList instanceof NonNullList) {
                NonNullList ingredients = (NonNullList)ingredientsList;
                this.collectIngredientsFromList((NonNullList<Ingredient>)ingredients, totalIngredients);
            }
        }
        catch (Exception e) {
            ItemScrapperLogger.debugLog("Failed to extract ingredients through reflection: " + e.getMessage());
        }
    }

    private List<ItemStack> generateLootTableLoot(ServerLevel serverLevel, Scrapper_conversionsConfig.ScrapConfig config, ItemStack stackToScrap) {
        ResourceLocation lootTable = new ResourceLocation(config.lootable.getLootTable());
        LootParams lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.blockEntity.m_58899_())).m_287286_(LootContextParams.f_81461_, (Object)this.blockEntity.m_58900_()).m_287286_(LootContextParams.f_81463_, (Object)stackToScrap).m_287235_(LootContextParamSets.f_81421_);
        ObjectArrayList lootItems = serverLevel.m_7654_().m_278653_().m_278676_(lootTable).m_287195_(lootParams);
        if (!config.lootable.isAutoGenerateFromRecipe() && !lootItems.isEmpty()) {
            this.blockEntity.getInputItemHandler().extractItem(0, 1, false);
            ItemScrapperLogger.debugLog("Consumed 1 item for loot table: " + lootTable);
        }
        return lootItems;
    }

    private void tryLoadCustomRecipe(ServerLevel serverLevel, ResourceLocation recipeId, Scrapper_conversionsConfig.ScrapConfig config, List<ItemStack> results) {
        try {
            ArrayList<Path> basePaths = new ArrayList<Path>();
            if (((Boolean)CommonConfig.USE_NEW_TACZ_FORMAT.get()).booleanValue()) {
                basePaths.add(Path.of("tacz", new String[0]));
            }
            basePaths.add(Path.of("config/tacz/custom", new String[0]));
            ItemScrapperLogger.debugLog("Searching for recipe: " + recipeId);
            for (Path basePath : basePaths) {
                ItemScrapperLogger.debugLog("Checking in path: " + basePath.toAbsolutePath());
                if (!Files.exists(basePath, new LinkOption[0])) {
                    ItemScrapperLogger.debugLog("Path does not exist: " + basePath);
                    continue;
                }
                Stream<Path> modDirs = Files.list(basePath);
                try {
                    modDirs.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(modDir -> {
                        String namespace;
                        String modDirName = modDir.getFileName().toString();
                        if (modDirName.startsWith(namespace = recipeId.m_135827_())) {
                            try {
                                Path recipesDir;
                                Path namespacePath = (Boolean)CommonConfig.USE_NEW_TACZ_FORMAT.get() != false && basePath.endsWith("tacz") ? modDir.resolve("data").resolve(namespace) : modDir.resolve(namespace);
                                if (Files.exists(namespacePath, new LinkOption[0]) && Files.exists(recipesDir = namespacePath.resolve("recipes"), new LinkOption[0])) {
                                    String[] subDirs;
                                    for (String dir : subDirs = new String[]{"ammo", "attachments", "gun"}) {
                                        Path recipePath = recipesDir.resolve(dir).resolve(recipeId.m_135815_() + ".json");
                                        ItemScrapperLogger.debugLog("Checking path: " + recipePath.toAbsolutePath());
                                        if (!Files.exists(recipePath, new LinkOption[0])) continue;
                                        this.processRecipeFile(recipePath, serverLevel, config, results);
                                        return;
                                    }
                                }
                            }
                            catch (Exception e) {
                                ItemScrapperLogger.errorLog("Error processing directory " + modDir + ": " + e.getMessage());
                            }
                        }
                    });
                }
                finally {
                    if (modDirs == null) continue;
                    modDirs.close();
                }
            }
        }
        catch (Exception e) {
            ItemScrapperLogger.errorLog("Error loading recipe: " + e.getMessage(), e);
        }
    }

    private void processRecipeFile(Path recipePath, ServerLevel serverLevel, Scrapper_conversionsConfig.ScrapConfig config, List<ItemStack> results) {
        try {
            ItemScrapperLogger.debugLog("Found recipe file at: " + recipePath.toAbsolutePath());
            String recipeJson = Files.readString(recipePath);
            ItemScrapperLogger.debugLog("Loaded recipe JSON:");
            ItemScrapperLogger.debugLog(recipeJson);
            Gson gson = new Gson();
            TACZCustomRecipeLoader customRecipe = (TACZCustomRecipeLoader)gson.fromJson(recipeJson, TACZCustomRecipeLoader.class);
            ItemScrapperLogger.debugLog("Parsed TACZCustomRecipeLoader object:");
            ItemScrapperLogger.debugLog("Materials: " + (Serializable)(customRecipe.materials != null ? Integer.valueOf(customRecipe.materials.size()) : "None"));
            ItemScrapperLogger.debugLog("Result type: " + (customRecipe.result != null ? customRecipe.result.type : "None"));
            ItemScrapperLogger.debugLog("Result ID: " + (customRecipe.result != null ? customRecipe.result.id : "None"));
            Map<Item, Integer> totalIngredients = customRecipe.getIngredients(serverLevel.m_9598_());
            ItemScrapperLogger.debugLog("Total ingredients resolved: " + totalIngredients.size());
            for (Map.Entry<Item, Integer> entry : totalIngredients.entrySet()) {
                ItemScrapperLogger.debugLog("Ingredient: " + entry.getKey() + ", Count: " + entry.getValue());
            }
            if (!totalIngredients.isEmpty()) {
                this.processIngredients(totalIngredients, serverLevel, config, results);
            }
        }
        catch (Exception e) {
            ItemScrapperLogger.errorLog("Error processing recipe file: " + e.getMessage(), e);
        }
    }

    private void handleRecipeResultFallback(Recipe<?> recipe, ServerLevel serverLevel, Scrapper_conversionsConfig.ScrapConfig config, List<ItemStack> results) {
        ItemStack recipeResult = recipe.m_8043_(serverLevel.m_9598_());
        if (!recipeResult.m_41619_()) {
            double returnPercent = this.getRandomReturnPercentage(config, serverLevel);
            int returnCount = Math.max(1, (int)Math.round((double)recipeResult.m_41613_() * (returnPercent / 100.0)));
            ItemStack resultStack = recipeResult.m_41777_();
            resultStack.m_41764_(returnCount);
            results.add(resultStack);
        }
    }

    private void processIngredients(Map<Item, Integer> totalIngredients, ServerLevel serverLevel, Scrapper_conversionsConfig.ScrapConfig config, List<ItemStack> results) {
        if (!totalIngredients.isEmpty()) {
            ItemStack stackToScrap = this.blockEntity.getInputItemHandler().getStackInSlot(0);
            int stackSize = stackToScrap.m_41613_();
            int maxReturnAmount = config.lootable.getAmountForMaxReturn();
            int itemsToConsume = Math.min(stackSize, maxReturnAmount);
            double stackMultiplier = Math.min(1.0, (double)itemsToConsume / (double)maxReturnAmount);
            double durabilityMultiplier = 1.0;
            if (config.useDurabilityMultiplier && stackToScrap.m_41763_()) {
                int maxDurability = stackToScrap.m_41776_();
                int currentDamage = stackToScrap.m_41773_();
                durabilityMultiplier = (double)(maxDurability - currentDamage) / (double)maxDurability;
                ItemScrapperLogger.debugLog(String.format("Durability calculation:\n  Max durability: %d\n  Current damage: %d\n  Durability multiplier: %.2f", maxDurability, currentDamage, durabilityMultiplier));
            }
            double baseReturnPercent = this.getRandomReturnPercentage(config, serverLevel);
            double effectiveReturnPercent = baseReturnPercent * stackMultiplier * durabilityMultiplier;
            ItemScrapperLogger.debugLog("Processing ingredients for scrapping:");
            ItemScrapperLogger.debugLog(String.format("Stack size: %d (consuming %d/%d items for %.2f%% effectiveness)", stackSize, itemsToConsume, maxReturnAmount, stackMultiplier * 100.0));
            ItemScrapperLogger.debugLog(String.format("Return rate: %.2f%% (Base: %.2f%% * Stack Multiplier: %.2f * Durability Multiplier: %.2f)", effectiveReturnPercent, baseReturnPercent, stackMultiplier, durabilityMultiplier));
            for (Map.Entry<Item, Integer> entry : totalIngredients.entrySet()) {
                int totalCount = entry.getValue();
                double exactCount = (double)totalCount * (effectiveReturnPercent / 100.0);
                int returnCount = switch (config.roundingType) {
                    case RoundingType.FLOOR -> (int)Math.floor(exactCount);
                    case RoundingType.CEILING -> (int)Math.ceil(exactCount);
                    default -> (int)Math.round(exactCount);
                };
                ItemScrapperLogger.debugLog(String.format("Item: %s\n  Total recipe count: %d\n  Effective return percentage: %.2f%%\n  Exact return count: %.2f\n  Rounded return count (%s): %d", new Object[]{entry.getKey(), totalCount, effectiveReturnPercent, exactCount, config.roundingType, returnCount}));
                if (returnCount <= 0) continue;
                ItemStack resultStack = new ItemStack((ItemLike)entry.getKey(), returnCount);
                results.add(resultStack);
            }
            ItemStack extracted = this.blockEntity.getInputItemHandler().extractItem(0, itemsToConsume, true);
            if (extracted.m_41613_() != itemsToConsume) {
                ItemScrapperLogger.errorLog("Could not extract correct number of items. Attempted: " + itemsToConsume + ", Available: " + extracted.m_41613_());
                return;
            }
            this.blockEntity.getInputItemHandler().extractItem(0, itemsToConsume, false);
            ItemScrapperLogger.debugLog("Items extracted: " + itemsToConsume);
            ItemScrapperLogger.debugLog("\nFinal Results Summary:");
            ItemScrapperLogger.debugLog("--------------------");
            for (ItemStack stack : results) {
                ItemScrapperLogger.debugLog(String.format("%s: %d", stack.m_41720_(), stack.m_41613_()));
            }
            ItemScrapperLogger.debugLog("--------------------\n");
        }
    }

    private double getRandomReturnPercentage(Scrapper_conversionsConfig.ScrapConfig config, ServerLevel serverLevel) {
        return config.lootable.getReturnAmount().min + (config.lootable.getReturnAmount().max - config.lootable.getReturnAmount().min) * serverLevel.m_213780_().m_188500_();
    }

    private void collectIngredientsFromList(NonNullList<Ingredient> ingredients, Map<Item, Integer> totalIngredients) {
        for (Ingredient ingredient : ingredients) {
            ItemStack[] matchingStacks = ingredient.m_43908_();
            if (matchingStacks.length <= 0) continue;
            Item item = matchingStacks[0].m_41720_();
            totalIngredients.merge(item, 1, Integer::sum);
        }
    }

    public double getCurrentHits() {
        return this.currentHits;
    }

    public float getProgress() {
        String itemId;
        Scrapper_conversionsConfig.ScrapConfig config;
        ItemStack stackToScrap = this.blockEntity.getInputItemHandler().getStackInSlot(0);
        if (!stackToScrap.m_41619_() && (config = Scrapper_conversionsConfig.getConfigForItem(itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stackToScrap.m_41720_()).toString(), stackToScrap.m_41783_())) != null) {
            return (float)(this.currentHits / config.requiredHits);
        }
        return 0.0f;
    }

    public void saveNBT(CompoundTag nbt) {
        nbt.m_128347_("currentHits", this.currentHits);
        nbt.m_128356_("lastHitTime", this.lastHitTime);
    }

    public void loadNBT(CompoundTag nbt) {
        this.currentHits = nbt.m_128459_("currentHits");
        this.lastHitTime = nbt.m_128454_("lastHitTime");
    }
}

