/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.blocks;

import com.keerdm.item_scrapper.blocks.ScrapperBlock;
import com.keerdm.item_scrapper.blocks.ScrapperBlockEntity;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ScrapperEffects {
    private static final Random random = new Random();

    public static void playItemPickupSound(Level level, BlockPos pos, BlockState state) {
        if (level.m_5776_()) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)ScrapperBlock.FACING);
        float[] baseOffsets = ScrapperEffects.getBaseOffsetsByFacing(facing);
        double soundX = (float)pos.m_123341_() + baseOffsets[0];
        double soundY = (double)pos.m_123342_() + 1.0;
        double soundZ = (float)pos.m_123343_() + baseOffsets[2];
        level.m_6263_(null, soundX, soundY, soundZ, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.8f, 0.8f + random.nextFloat() * 0.4f);
    }

    public static void playItemPlaceSound(Level level, BlockPos pos, BlockState state) {
        if (level.m_5776_()) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)ScrapperBlock.FACING);
        float[] baseOffsets = ScrapperEffects.getBaseOffsetsByFacing(facing);
        double soundX = (float)pos.m_123341_() + baseOffsets[0];
        double soundY = (double)pos.m_123342_() + 1.0;
        double soundZ = (float)pos.m_123343_() + baseOffsets[2];
        level.m_6263_(null, soundX, soundY, soundZ, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.9f, 0.8f + random.nextFloat() * 0.4f);
    }

    public static void playHitEffects(Level level, BlockPos pos, double attackStrength) {
        if (level.m_5776_()) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        Direction facing = (Direction)state.m_61143_((Property)ScrapperBlock.FACING);
        float[] baseOffsets = ScrapperEffects.getBaseOffsetsByFacing(facing);
        double soundX = (float)pos.m_123341_() + baseOffsets[0];
        double soundY = (double)pos.m_123342_() + 1.0;
        double soundZ = (float)pos.m_123343_() + baseOffsets[2];
        float randomPitch1 = 0.8f + random.nextFloat() * 0.4f;
        float randomPitch2 = 0.8f + random.nextFloat() * 0.4f;
        level.m_6263_(null, soundX, soundY, soundZ, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.8f, randomPitch1);
        level.m_6263_(null, soundX, soundY, soundZ, SoundEvents.f_11998_, SoundSource.BLOCKS, 0.5f, randomPitch2);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = level.m_7702_(pos);
            float progress = 0.0f;
            if (blockEntity instanceof ScrapperBlockEntity) {
                ScrapperBlockEntity scrapperEntity = (ScrapperBlockEntity)blockEntity;
                progress = scrapperEntity.getProgress();
            }
            ScrapperEffects.spawnProgressiveHitParticles(serverLevel, pos, state, attackStrength, progress);
        }
    }

    public static void playScrapSuccessEffects(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        Direction facing = (Direction)state.m_61143_((Property)ScrapperBlock.FACING);
        float[] baseOffsets = ScrapperEffects.getBaseOffsetsByFacing(facing);
        double soundX = (float)pos.m_123341_() + baseOffsets[0];
        double soundY = (double)pos.m_123342_() + 1.0;
        double soundZ = (float)pos.m_123343_() + baseOffsets[2];
        float randomPitch1 = 0.8f + random.nextFloat() * 0.4f;
        float randomPitch2 = 0.5f + random.nextFloat() * 0.3f;
        level.m_6263_(null, soundX, soundY, soundZ, SoundEvents.f_11665_, SoundSource.BLOCKS, 1.5f, randomPitch1);
        level.m_6263_(null, soundX, soundY, soundZ, SoundEvents.f_11871_, SoundSource.BLOCKS, 0.75f, randomPitch2);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ScrapperEffects.spawnSuccessParticles(serverLevel, pos, state);
        }
    }

    private static float[] getBaseOffsetsByFacing(Direction facing) {
        float[] fArray;
        switch (facing) {
            case NORTH: {
                float[] fArray2 = new float[3];
                fArray2[0] = 0.0f;
                fArray2[1] = 0.0f;
                fArray = fArray2;
                fArray2[2] = 0.5f;
                break;
            }
            case SOUTH: {
                float[] fArray3 = new float[3];
                fArray3[0] = 1.0f;
                fArray3[1] = 0.0f;
                fArray = fArray3;
                fArray3[2] = 0.5f;
                break;
            }
            case EAST: {
                float[] fArray4 = new float[3];
                fArray4[0] = 0.5f;
                fArray4[1] = 0.0f;
                fArray = fArray4;
                fArray4[2] = 0.0f;
                break;
            }
            case WEST: {
                float[] fArray5 = new float[3];
                fArray5[0] = 0.5f;
                fArray5[1] = 0.0f;
                fArray = fArray5;
                fArray5[2] = 1.0f;
                break;
            }
            default: {
                float[] fArray6 = new float[3];
                fArray6[0] = 0.5f;
                fArray6[1] = 0.0f;
                fArray = fArray6;
                fArray6[2] = 0.5f;
            }
        }
        return fArray;
    }

    private static void spawnProgressiveHitParticles(ServerLevel level, BlockPos pos, BlockState state, double attackStrength, float progress) {
        Direction facing = (Direction)state.m_61143_((Property)ScrapperBlock.FACING);
        float[] baseOffsets = ScrapperEffects.getBaseOffsetsByFacing(facing);
        int particleCount = (int)(3.0 + attackStrength * 5.0);
        ScrapperEffects.spawnParticleGroup(level, pos, baseOffsets, (ParticleOptions)ParticleTypes.f_123797_, particleCount, attackStrength, 0.6, 0.2, true);
        if (progress > 0.3f) {
            ScrapperEffects.spawnParticleGroup(level, pos, baseOffsets, (ParticleOptions)ParticleTypes.f_123762_, particleCount / 2, attackStrength, 0.4, 0.15, true);
            ScrapperEffects.spawnParticleGroup(level, pos, baseOffsets, (ParticleOptions)ParticleTypes.f_123797_, particleCount / 2, attackStrength * 1.2, 0.5, 0.25, true);
        }
        if (progress > 0.6f) {
            ScrapperEffects.spawnParticleGroup(level, pos, baseOffsets, (ParticleOptions)ParticleTypes.f_123745_, particleCount / 3, attackStrength, 0.4, 0.2, true);
            ScrapperEffects.spawnParticleGroup(level, pos, baseOffsets, (ParticleOptions)ParticleTypes.f_123808_, particleCount / 2, attackStrength, 0.6, 0.3, true);
        }
    }

    private static void spawnParticleGroup(ServerLevel level, BlockPos pos, float[] baseOffsets, ParticleOptions particleType, int count, double intensity, double spread, double ySpread, boolean addVelocity) {
        for (int i = 0; i < count; ++i) {
            double offsetX = random.nextDouble() * spread - spread / 2.0;
            double offsetY = random.nextDouble() * ySpread;
            double offsetZ = random.nextDouble() * spread - spread / 2.0;
            double velocityX = addVelocity ? (random.nextDouble() - 0.5) * 0.1 * intensity : 0.0;
            double velocityY = addVelocity ? random.nextDouble() * 0.1 * intensity : 0.0;
            double velocityZ = addVelocity ? (random.nextDouble() - 0.5) * 0.1 * intensity : 0.0;
            level.m_8767_(particleType, (double)((float)pos.m_123341_() + baseOffsets[0]) + offsetX, (double)(pos.m_123342_() + 1) + offsetY, (double)((float)pos.m_123343_() + baseOffsets[2]) + offsetZ, 1, velocityX, velocityY, velocityZ, intensity * 0.1);
        }
    }

    private static void spawnSuccessParticles(ServerLevel level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)ScrapperBlock.FACING);
        float[] baseOffsets = ScrapperEffects.getBaseOffsetsByFacing(facing);
        for (int i = 0; i < 20; ++i) {
            ScrapperEffects.spawnParticleGroup(level, pos, baseOffsets, (ParticleOptions)ParticleTypes.f_123808_, 2, 1.0, 0.8, 0.4, true);
            ScrapperEffects.spawnParticleGroup(level, pos, baseOffsets, (ParticleOptions)ParticleTypes.f_123745_, 1, 1.0, 0.6, 0.3, true);
            ScrapperEffects.spawnParticleGroup(level, pos, baseOffsets, (ParticleOptions)ParticleTypes.f_123762_, 1, 0.5, 0.8, 0.4, true);
        }
        ScrapperEffects.spawnParticleGroup(level, pos, baseOffsets, (ParticleOptions)ParticleTypes.f_123747_, 1, 1.0, 0.1, 0.1, false);
    }
}

