/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.blocks;

import com.keerdm.item_scrapper.blocks.ScrapperBlock;
import com.keerdm.item_scrapper.blocks.ScrapperBlockEntity;
import com.keerdm.item_scrapper.client.ClientUtils;
import com.keerdm.item_scrapper.configs.ClientConfig;
import com.keerdm.item_scrapper.configs.json.TransformConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;
import org.joml.Quaternionf;

public class ScrapperBlockRenderer
implements BlockEntityRenderer<ScrapperBlockEntity> {
    private final float defaultRotationX;
    private final float defaultRotationY;
    private final float defaultRotationZ;
    private final float itemScale;
    private final float northOffsetX;
    private final float northOffsetY;
    private final float northOffsetZ;
    private final float southOffsetX;
    private final float southOffsetY;
    private final float southOffsetZ;
    private final float eastOffsetX;
    private final float eastOffsetY;
    private final float eastOffsetZ;
    private final float westOffsetX;
    private final float westOffsetY;
    private final float westOffsetZ;
    private final Map<Integer, Float> itemXOffsets = new HashMap<Integer, Float>();
    private final Map<Integer, Float> itemYOffsets = new HashMap<Integer, Float>();
    private final Map<Integer, Float> itemZOffsets = new HashMap<Integer, Float>();
    private final Map<Integer, Float> itemRotations = new HashMap<Integer, Float>();
    private final Map<Integer, Float> itemScales = new HashMap<Integer, Float>();
    private final Random random = new Random();

    public ScrapperBlockRenderer(BlockEntityRendererProvider.Context context) {
        this(context, 90.0f, 90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f, 1.0f, 0.0f, 0.5f, 0.5f, 0.0f, 0.0f, 0.5f, 0.0f, 1.0f);
    }

    public ScrapperBlockRenderer(BlockEntityRendererProvider.Context context, float rotationX, float rotationY, float rotationZ, float scale, float northOffsetX, float northOffsetY, float northOffsetZ, float southOffsetX, float southOffsetY, float southOffsetZ, float eastOffsetX, float eastOffsetY, float eastOffsetZ, float westOffsetX, float westOffsetY, float westOffsetZ) {
        this.defaultRotationX = rotationX;
        this.defaultRotationY = rotationY;
        this.defaultRotationZ = rotationZ;
        this.itemScale = scale;
        this.northOffsetX = northOffsetX;
        this.northOffsetY = northOffsetY;
        this.northOffsetZ = northOffsetZ;
        this.southOffsetX = southOffsetX;
        this.southOffsetY = southOffsetY;
        this.southOffsetZ = southOffsetZ;
        this.eastOffsetX = eastOffsetX;
        this.eastOffsetY = eastOffsetY;
        this.eastOffsetZ = eastOffsetZ;
        this.westOffsetX = westOffsetX;
        this.westOffsetY = westOffsetY;
        this.westOffsetZ = westOffsetZ;
    }

    public void render(ScrapperBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        poseStack.m_85836_();
        this.renderInputItem(blockEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        this.renderOutputItems(blockEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        poseStack.m_85849_();
    }

    private void renderInputItem(ScrapperBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStackHandler itemHandler = blockEntity.getInputItemHandler();
        BlockState state = blockEntity.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)ScrapperBlock.FACING);
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack itemStack = itemHandler.getStackInSlot(slot);
            if (itemStack.m_41619_()) continue;
            ResourceLocation itemId = itemStack.m_41720_().m_204114_().m_205785_().m_135782_();
            String itemIdString = itemId.toString();
            TransformConfig.Transform transform = TransformConfig.getTransformForItem(itemIdString, itemStack.m_41783_());
            int renderCount = Math.min(itemStack.m_41613_(), (Integer)ClientConfig.MAX_INPUT_ITEMS_RENDERED.get());
            for (int i = 0; i < renderCount; ++i) {
                float rotY;
                float rotX;
                float baseZ;
                float baseY;
                float baseX;
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.96, 0.0);
                if (ClientUtils.CLIENT_RENDER_TICKS.containsKey((Object)blockEntity) && i == renderCount - 1) {
                    float tick = ClientUtils.getSmoothTick(blockEntity, partialTicks);
                    long seed = System.currentTimeMillis() + blockEntity.m_58899_().m_121878_();
                    Random random = new Random(seed);
                    float rotationDirX = (random.nextFloat() * 2.0f - 1.0f) * 0.01f;
                    float rotationDirY = (random.nextFloat() * 2.0f - 1.0f) * 0.01f;
                    float rotationDirZ = (random.nextFloat() * 2.0f - 1.0f) * 0.01f;
                    if (tick < 5.0f) {
                        float bounceProgress = tick / 5.0f;
                        poseStack.m_85837_(0.0, Math.sin((double)bounceProgress * Math.PI) * 0.05, 0.0);
                        poseStack.m_252781_(new Quaternionf().rotateXYZ(rotationDirX * bounceProgress, rotationDirY * bounceProgress, rotationDirZ * bounceProgress));
                    } else if (tick < 10.0f) {
                        float settleProgress = (tick - 5.0f) / 5.0f;
                        float smallBounce = (float)Math.max(0.0, Math.sin((double)settleProgress * Math.PI * 2.0) * 0.01);
                        poseStack.m_85837_(0.0, (double)smallBounce, 0.0);
                        poseStack.m_252781_(new Quaternionf().rotateXYZ(rotationDirX * (1.0f - settleProgress), rotationDirY * (1.0f - settleProgress), rotationDirZ * (1.0f - settleProgress)));
                    }
                }
                int currentSlot = slot;
                int currentItem = i;
                float xOffset = 0.0f;
                float yOffset = 0.0f;
                float zOffset = 0.0f;
                float layingRotation = transform != null ? (float)transform.layingRotation : 0.0f;
                float rotZ = switch (facing) {
                    case Direction.NORTH -> {
                        baseX = this.northOffsetX;
                        baseY = this.northOffsetY;
                        baseZ = this.northOffsetZ;
                        rotX = this.defaultRotationX;
                        rotY = 90.0f + this.defaultRotationY + layingRotation;
                        yield this.defaultRotationZ;
                    }
                    case Direction.SOUTH -> {
                        baseX = this.southOffsetX;
                        baseY = this.southOffsetY;
                        baseZ = this.southOffsetZ;
                        rotX = this.defaultRotationX;
                        rotY = -90.0f + this.defaultRotationY + layingRotation;
                        yield 180.0f + this.defaultRotationZ;
                    }
                    case Direction.EAST -> {
                        baseX = this.eastOffsetX;
                        baseY = this.eastOffsetY;
                        baseZ = this.eastOffsetZ;
                        rotX = this.defaultRotationX + layingRotation;
                        rotY = -90.0f + this.defaultRotationY;
                        yield 90.0f + this.defaultRotationZ;
                    }
                    case Direction.WEST -> {
                        baseX = this.westOffsetX;
                        baseY = this.westOffsetY;
                        baseZ = this.westOffsetZ;
                        rotX = this.defaultRotationX + layingRotation;
                        rotY = 90.0f + this.defaultRotationY;
                        yield 90.0f + this.defaultRotationZ;
                    }
                    default -> {
                        baseX = this.northOffsetX;
                        baseY = this.northOffsetY;
                        baseZ = this.northOffsetZ;
                        rotX = this.defaultRotationX;
                        rotY = 90.0f + this.defaultRotationY + layingRotation;
                        yield this.defaultRotationZ;
                    }
                };
                if (transform != null) {
                    float transformX = (float)transform.xLocation;
                    float transformY = (float)transform.yLocation;
                    float transformZ = (float)transform.zLocation;
                    switch (facing) {
                        case NORTH: {
                            baseX += transformX;
                            baseY += transformY;
                            baseZ += transformZ;
                            break;
                        }
                        case SOUTH: {
                            baseX += transformX;
                            baseY += transformY;
                            baseZ -= transformZ;
                            break;
                        }
                        case EAST: {
                            baseX -= transformZ;
                            baseY += transformY;
                            baseZ += transformX;
                            break;
                        }
                        case WEST: {
                            baseX += transformZ;
                            baseY += transformY;
                            baseZ -= transformX;
                        }
                    }
                }
                if (i > 0) {
                    xOffset = this.itemXOffsets.computeIfAbsent(currentSlot * 10 + currentItem, k -> {
                        float baseOffset = -0.2f + this.random.nextFloat() * 0.4f;
                        return Float.valueOf(Math.max(-0.1f, Math.min(0.1f, baseOffset)));
                    }).floatValue();
                    yOffset = this.itemYOffsets.computeIfAbsent(currentSlot * 10 + currentItem, k -> Float.valueOf((this.random.nextFloat() - 0.5f) * 0.01f)).floatValue();
                    zOffset = this.itemZOffsets.computeIfAbsent(currentSlot * 10 + currentItem, k -> {
                        float baseOffset = -0.5f + this.random.nextFloat() * 1.0f;
                        return Float.valueOf(Math.max(-0.5f, Math.min(0.5f, baseOffset)));
                    }).floatValue();
                    if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                        float temp = xOffset;
                        xOffset = zOffset;
                        zOffset = temp;
                    }
                    baseX += xOffset;
                    baseY += yOffset;
                    baseZ += zOffset;
                }
                poseStack.m_252880_(baseX, baseY, baseZ);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(rotX));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotY));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(rotZ));
                if (i > 0) {
                    float itemRotation = this.itemRotations.computeIfAbsent(currentSlot * 10 + currentItem, k -> Float.valueOf((float)k.intValue() * 30.0f + (this.random.nextFloat() - 0.5f) * 20.0f)).floatValue();
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(itemRotation));
                }
                float scale = transform != null ? (float)transform.scale : 1.0f;
                poseStack.m_85841_(scale, scale, scale);
                ItemStack renderStack = itemStack.m_41777_();
                renderStack.m_41764_(1);
                Minecraft.m_91087_().m_91291_().m_269128_(renderStack, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, poseStack, buffer, blockEntity.m_58904_(), 0);
                poseStack.m_85849_();
            }
        }
    }

    private void renderOutputItems(ScrapperBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStackHandler outputInventory = blockEntity.getOutputItemHandler();
        BlockState state = blockEntity.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)ScrapperBlock.FACING);
        ArrayList<ItemPosition> itemPositions = new ArrayList<ItemPosition>();
        for (int slot = 0; slot < outputInventory.getSlots(); ++slot) {
            ItemStack outputStack = outputInventory.getStackInSlot(slot);
            if (outputStack.m_41619_()) continue;
            int renderCount = Math.min(outputStack.m_41613_(), (Integer)ClientConfig.MAX_OUTPUT_ITEMS_RENDERED.get());
            for (int i = 0; i < renderCount; ++i) {
                boolean hasOverlap;
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.96, 0.0);
                int currentSlot = slot;
                int currentItem = i;
                float xOffset = 0.0f;
                float zOffset = 0.0f;
                xOffset = this.itemXOffsets.computeIfAbsent(currentSlot * 10 + currentItem, k -> {
                    float baseOffset = -0.2f + this.random.nextFloat() * 0.4f;
                    return Float.valueOf(Math.max(-0.1f, Math.min(0.1f, baseOffset)));
                }).floatValue();
                zOffset = this.itemZOffsets.computeIfAbsent(currentSlot * 10 + currentItem, k -> {
                    float baseOffset = -0.5f + this.random.nextFloat() * 1.0f;
                    return Float.valueOf(Math.max(-0.5f, Math.min(0.5f, baseOffset)));
                }).floatValue();
                if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                    float temp = xOffset;
                    xOffset = zOffset;
                    zOffset = temp;
                }
                float baseX = 0.0f;
                float baseY = 0.0f;
                float baseZ = 0.0f;
                switch (facing) {
                    case NORTH: {
                        baseX = this.northOffsetX + xOffset;
                        baseY = this.northOffsetY;
                        baseZ = this.northOffsetZ + zOffset;
                        break;
                    }
                    case SOUTH: {
                        baseX = this.southOffsetX + xOffset;
                        baseY = this.southOffsetY;
                        baseZ = this.southOffsetZ + zOffset;
                        break;
                    }
                    case EAST: {
                        baseX = this.eastOffsetX + xOffset;
                        baseY = this.eastOffsetY;
                        baseZ = this.eastOffsetZ + zOffset;
                        break;
                    }
                    case WEST: {
                        baseX = this.westOffsetX + xOffset;
                        baseY = this.westOffsetY;
                        baseZ = this.westOffsetZ + zOffset;
                    }
                }
                ItemPosition currentPos = new ItemPosition(baseX, baseY, baseZ);
                float yOffset = 0.0f;
                block14: do {
                    hasOverlap = false;
                    currentPos.y = baseY + yOffset;
                    for (ItemPosition pos : itemPositions) {
                        if (!currentPos.isOverlapping(pos)) continue;
                        hasOverlap = true;
                        yOffset += 0.03125f;
                        continue block14;
                    }
                } while (hasOverlap);
                itemPositions.add(new ItemPosition(baseX, baseY + yOffset, baseZ));
                poseStack.m_252880_(baseX, baseY + yOffset, baseZ);
                switch (facing) {
                    case NORTH: {
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(this.defaultRotationX));
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f + this.defaultRotationY));
                        poseStack.m_252781_(Axis.f_252403_.m_252977_(this.defaultRotationZ));
                        break;
                    }
                    case SOUTH: {
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(this.defaultRotationX));
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f + this.defaultRotationY));
                        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f + this.defaultRotationZ));
                        break;
                    }
                    case EAST: {
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(this.defaultRotationX));
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f + this.defaultRotationY));
                        poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f + this.defaultRotationZ));
                        break;
                    }
                    case WEST: {
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(this.defaultRotationX));
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f + this.defaultRotationY));
                        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f + this.defaultRotationZ));
                    }
                }
                float itemRotation = this.itemRotations.computeIfAbsent(currentSlot * 10 + currentItem, k -> Float.valueOf((float)k.intValue() * 30.0f + (this.random.nextFloat() - 0.5f) * 20.0f)).floatValue();
                float scaleVariation = this.itemScales.computeIfAbsent(currentSlot * 10 + currentItem, k -> Float.valueOf(1.0f + (this.random.nextFloat() - 0.5f) * 0.1f)).floatValue();
                poseStack.m_252781_(Axis.f_252403_.m_252977_(itemRotation));
                poseStack.m_85841_(scaleVariation, scaleVariation, scaleVariation);
                ItemStack singleStack = outputStack.m_41777_();
                singleStack.m_41764_(1);
                Minecraft.m_91087_().m_91291_().m_269128_(singleStack, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, poseStack, buffer, blockEntity.m_58904_(), 0);
                poseStack.m_85849_();
            }
        }
    }

    private static class ItemPosition {
        float x;
        float y;
        float z;

        ItemPosition(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        boolean isOverlapping(ItemPosition other) {
            float dx = this.x - other.x;
            float dy = Math.abs(this.y - other.y);
            float dz = this.z - other.z;
            return dy < 0.03125f && Math.sqrt(dx * dx + dz * dz) < (double)0.15f;
        }
    }
}

