/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.blocks;

import com.keerdm.item_scrapper.blocks.ModBlockEntities;
import com.keerdm.item_scrapper.blocks.ScrapperLogic;
import com.keerdm.item_scrapper.data.ScrapperDataManager;
import com.keerdm.item_scrapper.networking.ModNetworking;
import com.keerdm.item_scrapper.packets.UpdateTickTimePacket;
import com.keerdm.item_scrapper.util.ItemScrapperLogger;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;

public class ScrapperBlockEntity
extends BlockEntity {
    public final ScrapperLogic scrapperLogic;
    private final ItemStackHandler inputItemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            ScrapperBlockEntity.this.m_6596_();
            if (ScrapperBlockEntity.this.f_58857_ != null && !ScrapperBlockEntity.this.f_58857_.m_5776_()) {
                ScrapperBlockEntity.this.f_58857_.m_7260_(ScrapperBlockEntity.this.f_58858_, ScrapperBlockEntity.this.m_58900_(), ScrapperBlockEntity.this.m_58900_(), 3);
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            String side;
            if (stack.m_41619_()) {
                return false;
            }
            String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString();
            boolean isValid = ScrapperDataManager.getConfigForItem(itemId, stack.m_41783_()) != null;
            String string = side = ScrapperBlockEntity.this.f_58857_ != null && ScrapperBlockEntity.this.f_58857_.m_5776_() ? "CLIENT" : "SERVER";
            if (ScrapperBlockEntity.this.f_58857_ != null && ScrapperBlockEntity.this.f_58857_.m_5776_() && !isValid && !ScrapperDataManager.isClientSynced()) {
                ItemScrapperLogger.debugLog("CLIENT: Not synced yet, allowing " + itemId + " (server will validate)");
                return true;
            }
            ItemScrapperLogger.debugLog(side + ": Item " + itemId + " valid: " + isValid);
            return isValid;
        }
    };
    private final ItemStackHandler outputItemHandler = new ItemStackHandler(20){

        protected void onContentsChanged(int slot) {
            ScrapperBlockEntity.this.m_6596_();
            if (ScrapperBlockEntity.this.f_58857_ != null && !ScrapperBlockEntity.this.f_58857_.m_5776_()) {
                ScrapperBlockEntity.this.f_58857_.m_7260_(ScrapperBlockEntity.this.f_58858_, ScrapperBlockEntity.this.m_58900_(), ScrapperBlockEntity.this.m_58900_(), 3);
            }
        }
    };

    public static void tick(Level level, BlockPos pos, BlockState state, ScrapperBlockEntity blockEntity) {
        ++blockEntity.scrapperLogic.lastHitTimeTicks;
        blockEntity.getPersistentData().m_128405_("lastHitTimeTicks", blockEntity.scrapperLogic.lastHitTimeTicks);
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            for (ServerPlayer player : sv.m_6907_()) {
                ModNetworking.sendToPlayer(new UpdateTickTimePacket(blockEntity.scrapperLogic.lastHitTimeTicks, pos), player);
            }
        }
    }

    public ScrapperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SCRAPPER_BLOCK_ENTITY.get(), pos, state);
        this.scrapperLogic = new ScrapperLogic(this);
    }

    public void addHit(float attackStrength, Player player) {
        ItemStack mainHandItem = player.m_21205_();
        if (!mainHandItem.m_41619_() && mainHandItem.m_41720_().m_41465_()) {
            mainHandItem.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        }
        this.scrapperLogic.addHit(attackStrength, this.f_58857_);
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inputInventory", (Tag)this.inputItemHandler.serializeNBT());
        nbt.m_128365_("outputInventory", (Tag)this.outputItemHandler.serializeNBT());
        this.scrapperLogic.saveNBT(nbt);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("inputInventory")) {
            this.inputItemHandler.deserializeNBT(nbt.m_128469_("inputInventory"));
        }
        if (nbt.m_128441_("outputInventory")) {
            this.outputItemHandler.deserializeNBT(nbt.m_128469_("outputInventory"));
        }
        this.scrapperLogic.loadNBT(nbt);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.m_183515_(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    public ItemStackHandler getInputItemHandler() {
        return this.inputItemHandler;
    }

    public ItemStackHandler getOutputItemHandler() {
        return this.outputItemHandler;
    }

    public float getProgress() {
        return this.scrapperLogic.getProgress();
    }
}

