/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.blocks;

import com.keerdm.item_scrapper.ItemScrapper;
import com.keerdm.item_scrapper.blocks.ModBlockEntities;
import com.keerdm.item_scrapper.blocks.ScrapperBlockEntity;
import com.keerdm.item_scrapper.blocks.ScrapperEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ScrapperBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty IS_MAIN = BooleanProperty.m_61465_((String)"is_main");

    public ScrapperBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)IS_MAIN, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_166049_((double)0.001, (double)0.0, (double)0.001, (double)0.998, (double)0.9375, (double)0.998);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_166049_((double)0.001, (double)0.0, (double)0.001, (double)0.998, (double)0.9375, (double)0.998);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, IS_MAIN});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos mainPos = (Boolean)state.m_61143_((Property)IS_MAIN) != false ? pos : pos.m_121945_(facing.m_122427_());
        BlockState mainState = level.m_8055_(mainPos);
        if (!level.m_5776_() && (blockEntity = level.m_7702_(mainPos)) instanceof ScrapperBlockEntity) {
            ScrapperBlockEntity scrapperBlockEntity = (ScrapperBlockEntity)blockEntity;
            if (player.m_6144_()) {
                ItemStack inputStack;
                boolean itemsCollected = false;
                for (int i = 0; i < scrapperBlockEntity.getOutputItemHandler().getSlots(); ++i) {
                    ItemStack outputStack = scrapperBlockEntity.getOutputItemHandler().extractItem(i, 64, false);
                    if (outputStack.m_41619_()) continue;
                    player.m_150109_().m_150079_(outputStack);
                    ScrapperEffects.playItemPickupSound(level, mainPos, mainState);
                    itemsCollected = true;
                }
                if (!itemsCollected && !(inputStack = scrapperBlockEntity.getInputItemHandler().extractItem(0, 64, false)).m_41619_()) {
                    player.m_150109_().m_150079_(inputStack);
                    ScrapperEffects.playItemPickupSound(level, mainPos, mainState);
                }
            } else {
                ItemStack inputStack;
                boolean itemGiven = false;
                for (int i = 0; i < scrapperBlockEntity.getOutputItemHandler().getSlots(); ++i) {
                    ItemStack outputStack = scrapperBlockEntity.getOutputItemHandler().extractItem(i, 1, false);
                    if (outputStack.m_41619_()) continue;
                    player.m_150109_().m_150079_(outputStack);
                    ScrapperEffects.playItemPickupSound(level, mainPos, mainState);
                    itemGiven = true;
                    break;
                }
                if (!itemGiven && !(inputStack = scrapperBlockEntity.getInputItemHandler().extractItem(0, 1, false)).m_41619_()) {
                    player.m_150109_().m_150079_(inputStack);
                    ScrapperEffects.playItemPickupSound(level, mainPos, mainState);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        BlockPos mainPos;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = mainPos = (Boolean)state.m_61143_((Property)IS_MAIN) != false ? pos : pos.m_121945_(facing.m_122427_());
        if (player.m_21205_().m_150930_((Item)ItemScrapper.SCRAPPING_HAMMER.get()) && (blockEntity = level.m_7702_(mainPos)) instanceof ScrapperBlockEntity) {
            float attackStrength;
            ScrapperBlockEntity scrapperBlockEntity = (ScrapperBlockEntity)blockEntity;
            if (!level.m_5776_() && (attackStrength = player.m_36403_(0.0f)) >= 0.2f) {
                scrapperBlockEntity.addHit(attackStrength, player);
            }
        }
    }

    @javax.annotation.Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)IS_MAIN) != false ? new ScrapperBlockEntity(pos, state) : null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos secondaryPos = pos.m_121945_(facing.m_122428_());
        level.m_7731_(secondaryPos, (BlockState)state.m_61124_((Property)IS_MAIN, (Comparable)Boolean.valueOf(false)), 3);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos secondaryPos;
        Direction placementDirection = context.m_8125_().m_122424_();
        BlockPos clickedPos = context.m_8083_();
        Level level = context.m_43725_();
        if (level.m_8055_(secondaryPos = clickedPos.m_121945_(placementDirection.m_122428_())).m_60629_(context)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placementDirection)).m_61124_((Property)IS_MAIN, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos mainPos = (Boolean)state.m_61143_((Property)IS_MAIN) != false ? pos : pos.m_121945_(facing.m_122427_());
        BlockPos secondaryPos = (Boolean)state.m_61143_((Property)IS_MAIN) != false ? pos.m_121945_(facing.m_122428_()) : pos;
        boolean isInSurvival = false;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean bl = isInSurvival = serverPlayer.f_8941_.m_9290_() == GameType.SURVIVAL;
        }
        if (!level.f_46443_ && isInSurvival) {
            ScrapperBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this));
        }
        if (!level.f_46443_ && (blockEntity = level.m_7702_(mainPos)) instanceof ScrapperBlockEntity) {
            ScrapperBlockEntity blockEntity2 = (ScrapperBlockEntity)blockEntity;
            ItemStackHandler inputHandler = blockEntity2.getInputItemHandler();
            for (int i = 0; i < inputHandler.getSlots(); ++i) {
                ItemStack stack = inputHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Containers.m_18992_((Level)level, (double)mainPos.m_123341_(), (double)mainPos.m_123342_(), (double)mainPos.m_123343_(), (ItemStack)stack);
            }
            ItemStackHandler outputHandler = blockEntity2.getOutputItemHandler();
            for (int i = 0; i < outputHandler.getSlots(); ++i) {
                ItemStack stack = outputHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Containers.m_18992_((Level)level, (double)mainPos.m_123341_(), (double)mainPos.m_123342_(), (double)mainPos.m_123343_(), (ItemStack)stack);
            }
            blockEntity2.m_7651_();
        }
        if (level.f_46443_) {
            level.m_142052_((Boolean)state.m_61143_((Property)IS_MAIN) != false ? secondaryPos : mainPos, level.m_8055_((Boolean)state.m_61143_((Property)IS_MAIN) != false ? secondaryPos : mainPos));
        }
        level.m_7471_(mainPos, false);
        level.m_7471_(secondaryPos, false);
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return p_153212_.f_46443_ ? null : ScrapperBlock.m_152132_(p_153214_, (BlockEntityType)((BlockEntityType)ModBlockEntities.SCRAPPER_BLOCK_ENTITY.get()), ScrapperBlockEntity::tick);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        BlockPos mainPos;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = mainPos = (Boolean)state.m_61143_((Property)IS_MAIN) != false ? pos : pos.m_121945_(facing.m_122427_());
        if (!level.f_46443_ && (blockEntity = level.m_7702_(mainPos)) instanceof ScrapperBlockEntity) {
            ScrapperBlockEntity blockEntity2 = (ScrapperBlockEntity)blockEntity;
            ItemStackHandler inputHandler = blockEntity2.getInputItemHandler();
            for (int i = 0; i < inputHandler.getSlots(); ++i) {
                ItemStack stack = inputHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Containers.m_18992_((Level)level, (double)mainPos.m_123341_(), (double)mainPos.m_123342_(), (double)mainPos.m_123343_(), (ItemStack)stack);
            }
            ItemStackHandler outputHandler = blockEntity2.getOutputItemHandler();
            for (int i = 0; i < outputHandler.getSlots(); ++i) {
                ItemStack stack = outputHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Containers.m_18992_((Level)level, (double)mainPos.m_123341_(), (double)mainPos.m_123342_(), (double)mainPos.m_123343_(), (ItemStack)stack);
            }
            blockEntity2.m_7651_();
        }
        if (((Boolean)state.m_61143_((Property)IS_MAIN)).booleanValue()) {
            level.m_7471_(pos.m_121945_(facing.m_122428_()), false);
        } else {
            level.m_7471_(pos.m_121945_(facing.m_122427_()), false);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }
}

