/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.client.recipebook.group;

import com.google.common.collect.ImmutableList;
import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.bakery.registry.ObjectRegistry;

@OnlyIn(value=Dist.CLIENT)
public enum StoveRecipeBookGroup implements IRecipeBookGroup
{
    SEARCH(new ItemStack((ItemLike)Items.f_42522_)),
    BREAD(new ItemStack((ItemLike)Items.f_42406_)),
    CAKE(new ItemStack((ItemLike)ObjectRegistry.BUNDT_CAKE.get()));

    public static final List<IRecipeBookGroup> STOVE_GROUPS;
    private final List<ItemStack> icons;

    private StoveRecipeBookGroup(ItemStack ... entries) {
        this.icons = ImmutableList.copyOf((Object[])entries);
    }

    public boolean fitRecipe(Recipe<? extends Container> recipe, RegistryAccess registryAccess) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SEARCH -> true;
            case BREAD -> recipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(((Item)ObjectRegistry.DOUGH.get()).m_7968_()));
            case CAKE -> recipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(((Item)ObjectRegistry.SWEET_DOUGH.get()).m_7968_()));
        };
    }

    public List<ItemStack> getIcons() {
        return this.icons;
    }

    static {
        STOVE_GROUPS = ImmutableList.of((Object)((Object)SEARCH), (Object)((Object)BREAD), (Object)((Object)CAKE));
    }
}

