/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.screen;

import it.zerono.mods.extremereactors.CommonLocations;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.VentSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.screen.control.FlowRate;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.screen.control.RpmBar;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.screen.control.VentSettings;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.container.TurbineControllerContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.zerocore.base.client.screen.BaseScreenToolTipsBuilder;
import it.zerono.mods.zerocore.base.client.screen.ClientBaseHelper;
import it.zerono.mods.zerocore.base.client.screen.control.BarsPanel;
import it.zerono.mods.zerocore.base.client.screen.control.CommonPanels;
import it.zerono.mods.zerocore.base.client.screen.control.EnergyBar;
import it.zerono.mods.zerocore.base.client.screen.control.FluidBar;
import it.zerono.mods.zerocore.base.client.screen.control.InformationDisplay;
import it.zerono.mods.zerocore.base.client.screen.control.MachineStatusIndicator;
import it.zerono.mods.zerocore.base.client.screen.control.OnOff;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.ToolTipsBuilder;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchButton;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchPictureButton;
import it.zerono.mods.zerocore.lib.client.gui.layout.AnchoredLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.common.util.NonNullSupplier;

public class TurbineControllerScreen
extends CommonMultiblockScreen<MultiblockTurbine, TurbineControllerEntity, TurbineControllerContainer> {
    private static final MutableComponent TEXT_INDUCTOR_ENGAGED = TextHelper.translatable((String)"gui.bigreactors.turbine.controller.inductor.mode.engaged", ClientBaseHelper::formatAsValue);
    private static final MutableComponent TEXT_INDUCTOR_DISENGAGED = TextHelper.translatable((String)"gui.bigreactors.turbine.controller.inductor.mode.disengaged", ClientBaseHelper::formatAsValue);
    private final FluidBar _coolantBar;
    private final FluidBar _vaporBar;
    private final RpmBar _rpmBar;
    private final EnergyBar _energyBar;
    private final OnOff _onOff;
    private final SwitchPictureButton _inductorEngaged;
    private final VentSettings _ventSettings;
    private final InformationDisplay _infoDisplay;

    public TurbineControllerScreen(TurbineControllerContainer container, Inventory inventory, Component title) {
        super(container, inventory, PlayerInventoryUsage.None, title, TurbineControllerScreen.mainTextureFromVariant((IMultiblockVariant)((TurbineControllerEntity)container.getTileEntity()).getMultiblockVariant().orElse(TurbineVariant.Basic)));
        this.addPatchouliHelpButton(PatchouliCompat.HANDBOOK_ID, CommonLocations.TURBINE.buildWithSuffix("part-controller"), 1);
        this._coolantBar = new FluidBar((ModContainerScreen)this, "coolantBar", container.getFluidCapacity(), container.COOLANT_STACK, (NonNullSupplier)CommonIcons.CoolantIcon, "gui.bigreactors.turbine.controller.coolantbar.title", "gui.bigreactors.turbine.controller.coolantbar.footer");
        this._vaporBar = new FluidBar((ModContainerScreen)this, "vaporBar", container.getFluidCapacity(), container.VAPOR_STACK, (NonNullSupplier)CommonIcons.VaporIcon, "gui.bigreactors.turbine.controller.vaporbar.title", "gui.bigreactors.turbine.controller.vaporbar.footer");
        this._rpmBar = new RpmBar((ModContainerScreen<? extends ModContainer>)this, "rpmBar", container.getMaxRotorSpeed(), container.RPM);
        this._energyBar = new EnergyBar((ModContainerScreen)this, "energyBar", container.getOutputEnergySystem(), container.getEnergyCapacity(), container.ENERGY_STORED, "gui.bigreactors.reactor_turbine.controller.energybar.tooltip.body");
        FlowRate flowRate = new FlowRate((ModContainerScreen<? extends ModContainer>)this, "maxIntakeRate", container.getMaxIntakeRateHardLimit(), container.getMaxIntakeRate(), this::onMaxIntakeRateChanged);
        this._infoDisplay = new InformationDisplay((ModContainerScreen)this, "info", layout -> layout.columns(2, new int[]{79, 112}).rows(3));
        this._infoDisplay.addCellContent((IControl)flowRate, builder -> builder.setRowsSpan(3).setHorizontalAlignment(HorizontalAlignment.Left).setVerticalAlignment(VerticalAlignment.Top));
        this._infoDisplay.addInformationCell(builder -> builder.name("rpm").bindText((IBindableData)container.RPM, rpm -> String.format("%.2f RPM", rpm)).icon((NonNullSupplier)CommonIcons.RotorRPM).useTooltipsFrom((IControl)this._rpmBar));
        this._infoDisplay.addInformationCell(builder -> builder.name("energyRatio").bindText((IBindableData)container.ENERGY_GENERATED_LAST_TICK, this::formatEnergyRatio).icon((NonNullSupplier)CommonIcons.EnergyRatioIcon).tooltips(new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.turbine.controller.energyratio.tooltip.title").addTextAsValue(TextHelper.translatable((String)"gui.bigreactors.turbine.controller.energyratio.tooltip.value1a"), new Component[]{TextHelper.translatable((String)"gui.bigreactors.turbine.controller.energyratio.tooltip.value1b")}).addEmptyLine().addTranslatable("gui.bigreactors.turbine.controller.energyratio.tooltip.body").addBindableObjectAsValue((IBindableData)container.ENERGY_GENERATED_LAST_TICK, generated -> TextHelper.literal((String)this.formatEnergyRatio((WideAmount)generated)))));
        this._infoDisplay.addInformationCell(builder -> builder.name("rotorStatus").bindText((IBindableData)container.ROTOR_EFFICIENCY_LAST_TICK, this::formatRotorEfficiency).icon((NonNullSupplier)CommonIcons.RotorStatus).tooltips(new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.turbine.controller.rotorstatus.tooltip.title").addTranslatableAsValue("gui.bigreactors.turbine.controller.rotorstatus.tooltip.value1").addEmptyLine().addTranslatable("gui.bigreactors.turbine.controller.rotorstatus.tooltip.value2", new Object[]{String.format(ChatFormatting.DARK_AQUA + String.valueOf(ChatFormatting.BOLD) + "%d", container.getBaseFluidPerBlade())}).addTranslatable("gui.bigreactors.turbine.controller.rotorstatus.tooltip.value3").addEmptyLine().addTranslatable("gui.bigreactors.turbine.controller.rotorstatus.tooltip.body").addBindableObjectAsValue((IBindableData)container.ROTOR_EFFICIENCY_LAST_TICK, efficiency -> TextHelper.literal((String)this.formatRotorEfficiency(efficiency.floatValue()))).addBindableObjectAsValue((IBindableData)container.FLUID_CONSUMED_LAST_TICK, consumed -> TextHelper.literal((String)"%d / %d", (Object[])new Object[]{container.getRotorBladesCount(), consumed / container.getBaseFluidPerBlade()}))));
        this._onOff = new OnOff((ModContainerScreen)this, 30, 16, (IBindableData)container.ACTIVE, this::onActiveStateChanged, (Component)TextHelper.translatable((String)"gui.bigreactors.turbine.controller.on.title"), (Component)TextHelper.translatable((String)"gui.bigreactors.turbine.controller.off.title"));
        this._inductorEngaged = new SwitchPictureButton((ModContainerScreen)this, "inductorEngaged", false);
        this._inductorEngaged.bindActive((IBindableData)container.INDUCTOR_ENGAGED);
        this._inductorEngaged.Activated.subscribe(this::onInductorEngagedChanged);
        this._inductorEngaged.Deactivated.subscribe(this::onInductorEngagedChanged);
        ClientBaseHelper.setButtonSpritesAndOverlayForState((AbstractButtonControl)this._inductorEngaged, (ButtonState)ButtonState.Default, (NonNullSupplier)CommonIcons.ButtonInductor);
        ClientBaseHelper.setButtonSpritesAndOverlayForState((AbstractButtonControl)this._inductorEngaged, (ButtonState)ButtonState.Active, (NonNullSupplier)CommonIcons.ButtonInductorActive);
        this._inductorEngaged.setBackground(CommonIcons.ImageButtonBackground.get());
        this._inductorEngaged.enablePaintBlending(true);
        this._inductorEngaged.setPadding(1);
        this._inductorEngaged.setDesiredDimension(18, 18);
        this._inductorEngaged.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.turbine.controller.inductor.tooltip.title").addTranslatableAsValue("gui.bigreactors.turbine.controller.inductor.tooltip.value").addEmptyLine().addTranslatable("gui.bigreactors.turbine.controller.inductor.tooltip.body").addBindableObjectAsValue((IBindableData)container.INDUCTOR_ENGAGED, engaged -> engaged != false ? TEXT_INDUCTOR_ENGAGED : TEXT_INDUCTOR_DISENGAGED));
        this._ventSettings = new VentSettings((ModContainerScreen<? extends ModContainer>)this, container.VENT_SETTINGS, this::onVentSettingChanged);
        this.setContentBounds(14, 0);
    }

    @Override
    protected MachineStatusIndicator createStatusIndicator(TurbineControllerContainer container) {
        return this.createTurbineStatusIndicator(container.ACTIVE);
    }

    protected void onScreenCreate() {
        super.onScreenCreate();
        this.setContentLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setControlsSpacing(2)).setVerticalAlignment(VerticalAlignment.Top)).setHorizontalAlignment(HorizontalAlignment.Left));
        BarsPanel barsPanel = new BarsPanel((ModContainerScreen)this, "bars").add((IControl)this._vaporBar).addEmptyPanel(5).addTemperatureScale().addEmptyPanel(5).add((IControl)this._coolantBar).addEmptyPanel(21).add((IControl)this._rpmBar).addVerticalSeparator().add((IControl)this._energyBar).addVerticalSeparator();
        this.addControl((IControl)barsPanel);
        this.addControl((IControl)CommonPanels.horizontalSeparator((ModContainerScreen)this, (int)this.getContentWidth()));
        this.addControl((IControl)this._infoDisplay);
        Panel commandPanel = CommonPanels.verticalCommandPanel((ModContainerScreen)this, (int)this._ventSettings.getDesiredDimension(DesiredDimension.Width));
        commandPanel.setLayoutEngine((ILayoutEngine)new AnchoredLayoutEngine().setZeroMargins());
        barsPanel.add((IControl)commandPanel);
        this._onOff.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)AnchoredLayoutEngine.Anchor.Top);
        commandPanel.addControl((IControl)this._onOff);
        this._inductorEngaged.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)AnchoredLayoutEngine.Anchor.Center);
        commandPanel.addControl((IControl)this._inductorEngaged);
        this._ventSettings.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)AnchoredLayoutEngine.Anchor.Bottom);
        commandPanel.addControl((IControl)this._ventSettings);
    }

    private String formatEnergyRatio(WideAmount generated) {
        return CodeHelper.formatAsHumanReadableNumber((double)generated.doubleValue(), (String)((TurbineControllerContainer)this.m_6262_()).getOutputEnergySystem().getUnit());
    }

    private String formatRotorEfficiency(float efficiency) {
        return String.format("%.1f%%", Float.valueOf(Mth.m_14036_((float)efficiency, (float)0.0f, (float)1.0f) * 100.0f));
    }

    private void onActiveStateChanged(SwitchButton button) {
        this.sendCommandToServer(button.getActive() ? CommonConstants.COMMAND_ACTIVATE : CommonConstants.COMMAND_DEACTIVATE);
    }

    private void onVentSettingChanged(SwitchPictureButton button) {
        this.sendCommandToServer(TurbineControllerEntity.COMMAND_SET_VENT, NBTHelper.nbtSetEnum((CompoundTag)new CompoundTag(), (String)"vent", (Enum)button.getTag().orElse(VentSetting.VentAll)));
    }

    private void onInductorEngagedChanged(SwitchPictureButton button) {
        this.sendCommandToServer(button.getActive() ? TurbineControllerEntity.COMMAND_ENGAGE_COILS : TurbineControllerEntity.COMMAND_DISENGAGE_COILS);
    }

    private void onMaxIntakeRateChanged(int newRate) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("rate", newRate);
        this.sendCommandToServer(TurbineControllerEntity.COMMAND_SET_INTAKERATE, data);
    }
}

