/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.sensor;

import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorWriter;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.sensor.ReactorSensorType;
import it.zerono.mods.zerocore.base.redstone.sensor.AbstractSensorSetting;
import it.zerono.mods.zerocore.base.redstone.sensor.SensorBehavior;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import net.minecraft.nbt.CompoundTag;

public class ReactorSensorSetting
extends AbstractSensorSetting<IReactorReader, IReactorWriter, ReactorSensorType, ReactorSensorSetting> {
    public static final ReactorSensorSetting DISABLED = new ReactorSensorSetting();

    public ReactorSensorSetting(ReactorSensorType sensor, SensorBehavior behavior, int v1, int v2) {
        super((Enum)sensor, behavior, v1, v2);
    }

    public static ReactorSensorSetting syncDataFrom(CompoundTag data) {
        try {
            return new ReactorSensorSetting(data);
        }
        catch (IllegalArgumentException ex) {
            Log.LOGGER.error("Invalid NBT data while reading a ReactorSensorSetting");
            return DISABLED;
        }
    }

    public CompoundTag syncDataTo(CompoundTag data) {
        return super.syncDataTo(NBTHelper.nbtSetEnum((CompoundTag)data, (String)"sensor", (Enum)((ReactorSensorType)this.Sensor)));
    }

    public void inputAction(IReactorWriter reactor, boolean isExternallyPowered, int externalPowerLevel) {
        switch ((ReactorSensorType)this.Sensor) {
            case inputActive: {
                this.acceptInputActive(reactor, isExternallyPowered);
                break;
            }
            case inputSetControlRod: {
                this.acceptInputSetControlRod(reactor, isExternallyPowered, externalPowerLevel);
                break;
            }
            case inputEjectWaste: {
                this.acceptInputEjectWaste(reactor, isExternallyPowered);
            }
        }
    }

    public ReactorSensorSetting copy() {
        return new ReactorSensorSetting((ReactorSensorType)this.Sensor, this.Behavior, this.Value1, this.Value2);
    }

    public boolean equals(Object other) {
        if (other instanceof ReactorSensorSetting) {
            ReactorSensorSetting s = (ReactorSensorSetting)((Object)other);
            return this == s || this.Sensor == s.Sensor && this.Behavior == s.Behavior && this.Value1 == s.Value1 && this.Value2 == s.Value2;
        }
        return false;
    }

    private ReactorSensorSetting() {
        this(ReactorSensorType.Disabled, SensorBehavior.Disabled, 0, 0);
    }

    protected ReactorSensorSetting(CompoundTag data) throws IllegalArgumentException {
        super(data, ReactorSensorSetting::readSensorTypeFrom);
    }

    private static ReactorSensorType readSensorTypeFrom(CompoundTag data) {
        if (!data.m_128441_("sensor")) {
            throw new IllegalArgumentException("Invalid NBT data");
        }
        return (ReactorSensorType)NBTHelper.nbtGetEnum((CompoundTag)data, (String)"sensor", ReactorSensorType::valueOf, (Enum)ReactorSensorType.Disabled);
    }

    private void acceptInputActive(IReactorWriter reactor, Boolean isExternallyPowered) {
        switch (this.Behavior) {
            case SetFromSignal: {
                reactor.setMachineActive(isExternallyPowered);
                break;
            }
            case ToggleOnPulse: {
                if (!isExternallyPowered.booleanValue()) break;
                reactor.toggleMachineActive();
            }
        }
    }

    private void acceptInputSetControlRod(IReactorWriter reactor, Boolean isExternallyPowered, int externalPowerLevel) {
        switch (this.Behavior) {
            case SetFromSignal: {
                reactor.setControlRodsInsertionRatio(isExternallyPowered != false ? this.Value1 : this.Value2);
                break;
            }
            case SetFromSignalLevel: {
                reactor.setControlRodsInsertionRatio(isExternallyPowered != false ? (int)((double)externalPowerLevel / 15.0 * 100.0) : 0);
                break;
            }
            case SetOnPulse: {
                reactor.setControlRodsInsertionRatio(this.Value1);
                break;
            }
            case AugmentOnPulse: {
                reactor.changeControlRodsInsertionRatio(this.Value1);
                break;
            }
            case ReduceOnPulse: {
                reactor.changeControlRodsInsertionRatio(-this.Value1);
            }
        }
    }

    private void acceptInputEjectWaste(IReactorWriter reactor, Boolean isExternallyPowered) {
        if (SensorBehavior.PerformOnPulse == this.Behavior && isExternallyPowered.booleanValue()) {
            reactor.ejectWaste(false);
        }
    }
}

