/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.radiation.RadiationPacket;
import it.zerono.mods.extremereactors.api.reactor.FuelProperties;
import it.zerono.mods.extremereactors.api.reactor.Moderator;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.api.reactor.radiation.IRadiationModerator;
import it.zerono.mods.extremereactors.api.reactor.radiation.IrradiationData;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractFluidGeneratorMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.FluidContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.FluidType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.IFluidContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.IFluidContainerAccess;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.FuelContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.FuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.FuelRodsMap;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.Heat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IFuelContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IFuelSource;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IHeat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IIrradiationSource;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorEnvironment;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorMachine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorWriter;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.OperationalMode;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactantHelper;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactorLogic;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactorPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.Stats;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.WasteEjectionSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.network.UpdateClientsFuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorChargingPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorControlRodEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorFluidAccessPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorFluidPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorFuelRodEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorGlassEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorPowerTapEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorSolidAccessPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.IMultiblockReactorVariant;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPort;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPortHandler;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartTypeProvider;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.geometry.CuboidBoundingBox;
import it.zerono.mods.zerocore.lib.data.nbt.IMergeableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.AllowedHandlerAction;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.WideEnergyBuffer;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.ITickableMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;

public class MultiblockReactor
extends AbstractFluidGeneratorMultiblockController<MultiblockReactor, IMultiblockReactorVariant>
implements IReactorMachine,
IReactorEnvironment,
IReactorWriter,
IDebuggable {
    private static final IFluidContainerAccess FLUID_CONTAINER_ACCESS = new IFluidContainerAccess(){

        @Override
        public AllowedHandlerAction getAllowedActionFor(FluidType fluidType) {
            switch (fluidType) {
                default: {
                    return AllowedHandlerAction.ExtractOnly;
                }
                case Liquid: 
            }
            return AllowedHandlerAction.InsertOnly;
        }

        @Override
        public FluidType getFluidTypeFrom(IoDirection portDirection) {
            switch (portDirection) {
                default: {
                    return FluidType.Liquid;
                }
                case Output: 
            }
            return FluidType.Gas;
        }
    };
    private static final float REACTOR_HEAT_LOSS_CONDUCTIVITY = 0.001f;
    private static final IRadiationModerator MODERATOR_NONE = (data, packet) -> {};
    private static final IRadiationModerator MODERATOR_AIR = (data, packet) -> MultiblockReactor.applyModerator(data, packet, Moderator.AIR);
    private final ReactorLogic _logic;
    private final IMultiblockReactorVariant _variant;
    private final Heat _fuelHeat;
    private final Heat _reactorHeat;
    private final FuelContainer _fuelContainer;
    private final FluidContainer _fluidContainer;
    private final Stats _uiStats;
    private FuelRodsLayout _fuelRodsLayout;
    private WasteEjectionSetting _wasteEjectionSetting;
    private OperationalMode _mode;
    private int _reactorVolume;
    private float _fuelToReactorHeatTransferCoefficient;
    private float _reactorToCoolantSystemHeatTransferCoefficient;
    private float _reactorHeatLossCoefficient;
    private boolean _sendUpdateFuelRodsLayout;
    private final Runnable _sendUpdateFuelRodsLayoutDelayedRunnable;
    private List<ITickableMultiblockPart> _attachedTickables;
    private final List<ReactorControlRodEntity> _attachedControlRods;
    private final FuelRodsMap _attachedFuelRods;
    private final List<ReactorSolidAccessPortEntity> _attachedSolidAccessPorts;
    private final List<ReactorFluidAccessPortEntity> _attachedFluidAccessPorts;
    private List<IPowerPort> _attachedPowerTaps;
    private List<ReactorFluidPortEntity> _attachedFluidPorts;
    private List<ReactorFluidPortEntity> _attachedOutputFluidPorts;
    private List<ReactorFluidPortEntity> _attachedInputFluidPorts;

    public MultiblockReactor(Level world, IMultiblockReactorVariant variant) {
        super(world);
        this._variant = variant;
        this._fuelContainer = new FuelContainer();
        this._fluidContainer = new FluidContainer(FLUID_CONTAINER_ACCESS);
        this._fuelHeat = new Heat();
        this._reactorHeat = new Heat();
        this._fuelRodsLayout = FuelRodsLayout.EMPTY;
        this._uiStats = new Stats(this._fuelContainer);
        this._mode = OperationalMode.Passive;
        this._wasteEjectionSetting = WasteEjectionSetting.Automatic;
        this._reactorVolume = 0;
        this._fuelToReactorHeatTransferCoefficient = 0.0f;
        this._reactorToCoolantSystemHeatTransferCoefficient = 0.0f;
        this._reactorHeatLossCoefficient = 0.0f;
        this._attachedTickables = ObjectLists.emptyList();
        this._attachedControlRods = Lists.newLinkedList();
        this._attachedFuelRods = new FuelRodsMap();
        this._attachedSolidAccessPorts = new ObjectArrayList(8);
        this._attachedFluidAccessPorts = new ObjectArrayList(8);
        this._attachedPowerTaps = ObjectLists.emptyList();
        this._attachedOutputFluidPorts = this._attachedInputFluidPorts = ObjectLists.emptyList();
        this._attachedFluidPorts = this._attachedInputFluidPorts;
        this._logic = new ReactorLogic(this, this.getEnergyBuffer());
        this._sendUpdateFuelRodsLayoutDelayedRunnable = CodeHelper.delayedRunnable(this::sendUpdateFuelRodsLayout, (int)200);
        this._sendUpdateFuelRodsLayout = false;
    }

    public static double getAdjustedPowerProductionMultiplier() {
        return (Double)Config.COMMON.general.powerProductionMultiplier.get() * (Double)Config.COMMON.reactor.reactorPowerProductionMultiplier.get();
    }

    public void reset() {
        this.setMachineActive(false);
        this._fuelContainer.reset();
        this._fluidContainer.reset();
        this._fuelHeat.set(0.0);
        this._reactorHeat.set(0.0);
        this._uiStats.setAmountGeneratedLastTick(0.0);
        this._uiStats.setFuelConsumedLastTick(0.0f);
        this._fuelToReactorHeatTransferCoefficient = 0.0f;
        this._reactorToCoolantSystemHeatTransferCoefficient = 0.0f;
        this._reactorHeatLossCoefficient = 0.0f;
        this._logic.reset();
        this.getEnergyBuffer().empty();
        this.resizeFuelContainer();
        this.calculateReactorVolume();
        this.updateFuelToReactorHeatTransferCoefficient();
        this.updateReactorToCoolantSystemHeatTransferCoefficient();
        this.updateReactorHeatLossCoefficient();
        this.resizeFluidContainer();
        this._fuelRodsLayout.reset();
        this._attachedFuelRods.markFuelRodsForRenderUpdate();
        this._attachedFuelRods.reset();
    }

    public Optional<ReactorControlRodEntity> getControlRodByIndex(int index) {
        if (index < 0 || index > this.getControlRodsCount()) {
            return Optional.empty();
        }
        return Optional.of(this._attachedControlRods.get(index));
    }

    public void onFluidPortChanged() {
        this.rebuildFluidPortsSubsets();
    }

    public void onUpdateClientsFuelRodsLayout(UpdateClientsFuelRodsLayout message) {
        if (this.calledByLogicalClient()) {
            this._fuelContainer.syncDataFrom(message.getFuelContainerData(), ISyncableEntity.SyncReason.NetworkUpdate);
            this.updateClientFuelRodsLayout();
        }
    }

    public void voidReactants() {
        this._fuelContainer.voidFuel();
        this._fuelContainer.voidWaste();
    }

    @Override
    public Optional<IFluidHandler> getLiquidHandler() {
        return this.getFluidHandler(IoDirection.Input);
    }

    @Override
    public Optional<IFluidHandler> getGasHandler() {
        return this.getFluidHandler(IoDirection.Output);
    }

    @Override
    public Optional<IFluidHandler> getFluidHandler(IoDirection portDirection) {
        return this.getOperationalMode().isActive() ? Optional.of(this._fluidContainer.getWrapper(portDirection)) : Optional.empty();
    }

    public void setMachineActive(boolean active) {
        if (this.isMachineActive() == active) {
            return;
        }
        this._active = active;
        if (active) {
            this.forEachConnectedParts(IMultiblockPart::onMachineActivated);
        } else {
            this.forEachConnectedParts(IMultiblockPart::onMachineDeactivated);
        }
        this.callOnLogicalServer(() -> this.markReferenceCoordForUpdate());
    }

    @Override
    public IReactorEnvironment getEnvironment() {
        return this;
    }

    @Override
    public IHeat getFuelHeat() {
        return this._fuelHeat;
    }

    @Override
    public IFuelContainer getFuelContainer() {
        return this._fuelContainer;
    }

    @Override
    public IFluidContainer getFluidContainer() {
        return this._fluidContainer;
    }

    @Override
    public Stats getUiStats() {
        return this._uiStats;
    }

    @Override
    public boolean performRefuelingCycle() {
        boolean changed = false;
        if (this.getWasteEjectionMode().isAutomatic()) {
            this.ejectWaste(false);
            changed = true;
        }
        changed |= this.refuelFluid();
        return changed |= this.refuelSolid();
    }

    @Override
    public void performOutputCycle() {
        ProfilerFiller profiler = this.getWorld().m_46473_();
        if (this.getOperationalMode().isPassive()) {
            profiler.m_6180_("Power");
            this.distributeEnergyEqually();
        } else {
            profiler.m_6180_("Gas");
            this.distributeGasEqually();
        }
        profiler.m_7238_();
    }

    @Override
    public boolean performInputCycle() {
        ProfilerFiller profiler = this.getWorld().m_46473_();
        boolean changed = false;
        if (this.getOperationalMode().isActive()) {
            profiler.m_6180_("Coolant");
            changed = this.acquireFluidEqually();
        }
        profiler.m_7238_();
        return changed;
    }

    @Override
    public boolean isSimulator() {
        return false;
    }

    @Override
    public IHeat getReactorHeat() {
        return this._reactorHeat;
    }

    @Override
    public int getReactorVolume() {
        return this._reactorVolume;
    }

    @Override
    public float getFuelToReactorHeatTransferCoefficient() {
        return this._fuelToReactorHeatTransferCoefficient;
    }

    @Override
    public float getReactorToCoolantSystemHeatTransferCoefficient() {
        return this._reactorToCoolantSystemHeatTransferCoefficient;
    }

    @Override
    public float getReactorHeatLossCoefficient() {
        return this._reactorHeatLossCoefficient;
    }

    @Override
    @Nullable
    public IIrradiationSource getNextIrradiationSource() {
        return this._attachedFuelRods.getNextIrradiationSource();
    }

    @Override
    public int getPartsCount(IReactorPartType type) {
        if (type instanceof ReactorPartType) {
            ReactorPartType partType = (ReactorPartType)type;
            switch (partType) {
                case ControlRod: {
                    return this._attachedControlRods.size();
                }
                case FuelRod: {
                    return this._attachedFuelRods.size();
                }
                case SolidAccessPort: {
                    return this._attachedSolidAccessPorts.size();
                }
                case FluidAccessPort: {
                    return this._attachedFluidAccessPorts.size();
                }
                case ActivePowerTapFE: 
                case PassivePowerTapFE: 
                case ChargingPortFE: {
                    return this._attachedPowerTaps.size();
                }
                case ActiveFluidPortForge: 
                case PassiveFluidPortForge: {
                    return this._attachedFluidPorts.size();
                }
            }
        }
        return this.getPartsCount(part -> part instanceof IMultiblockPartTypeProvider && ((IMultiblockPartTypeProvider)part).getPartType().filter(partType -> partType == type).isPresent());
    }

    @Override
    public IRadiationModerator getModerator(BlockPos position) {
        if (!this.getBoundingBox().contains((Vec3i)position)) {
            return MODERATOR_NONE;
        }
        Level world = this.getWorld();
        BlockState blockState = world.m_8055_(position);
        if (blockState.m_60795_()) {
            return MODERATOR_AIR;
        }
        if (blockState.m_155947_()) {
            BlockEntity te = WorldHelper.getLoadedTile((Level)world, (BlockPos)position);
            return te instanceof IRadiationModerator ? (IRadiationModerator)te : MODERATOR_NONE;
        }
        return (data, packet) -> MultiblockReactor.applyModerator(data, packet, ReactantHelper.getModeratorFrom(blockState, Moderator.AIR));
    }

    private static void applyModerator(IrradiationData data, RadiationPacket radiation, Moderator moderator) {
        float radiationAbsorbed = radiation.intensity * moderator.getAbsorption() * (1.0f - radiation.hardness);
        radiation.intensity = Math.max(0.0f, radiation.intensity - radiationAbsorbed);
        radiation.hardness /= moderator.getModeration();
        data.environmentEnergyAbsorption += (double)(moderator.getHeatEfficiency() * radiationAbsorbed * 10.0f);
    }

    @Override
    public void refuel() {
    }

    @Override
    public OperationalMode getOperationalMode() {
        return this._mode;
    }

    @Override
    public int getFuelAmount() {
        return this._fuelContainer.getFuelAmount();
    }

    @Override
    public int getWasteAmount() {
        return this._fuelContainer.getWasteAmount();
    }

    @Override
    public int getCapacity() {
        if (this.calledByLogicalClient() && !this.isAssembled()) {
            return this.getFuelRodsCount() * 4000;
        }
        return this._fuelContainer.getCapacity();
    }

    @Override
    public Optional<Reactant> getFuel() {
        return this._fuelContainer.getFuel();
    }

    @Override
    public FuelProperties getFuelProperties() {
        return this._fuelContainer.getFuelProperties();
    }

    @Override
    public Optional<Reactant> getWaste() {
        return this._fuelContainer.getWaste();
    }

    @Override
    public float getFuelFertility() {
        return this._logic.getFertility();
    }

    @Override
    public DoubleSupplier getFuelHeatValue() {
        return this._fuelHeat;
    }

    @Override
    public DoubleSupplier getReactorHeatValue() {
        return this._reactorHeat;
    }

    @Override
    public WasteEjectionSetting getWasteEjectionMode() {
        return this._wasteEjectionSetting;
    }

    @Override
    public FuelRodsLayout getFuelRodsLayout() {
        return this._fuelRodsLayout;
    }

    @Override
    public int getFuelRodsCount() {
        return this._attachedFuelRods.size();
    }

    @Override
    public int getControlRodsCount() {
        return this._attachedControlRods.size();
    }

    @Override
    public int getPowerTapsCount() {
        return this._attachedPowerTaps.size();
    }

    @Override
    public List<BlockPos> getControlRodLocations() {
        return this._attachedControlRods.stream().map(IMultiblockPart::getWorldPosition).collect(Collectors.toList());
    }

    @Override
    public int getCoolantAmount() {
        return this.getOperationalMode().isPassive() ? 0 : this.getFluidContainer().getLiquidAmount();
    }

    @Override
    public int getVaporAmount() {
        return this.getOperationalMode().isPassive() ? 0 : this.getFluidContainer().getGasAmount();
    }

    @Override
    public void setWasteEjectionMode(WasteEjectionSetting newSetting) {
        if (this.getWasteEjectionMode() != newSetting) {
            this._wasteEjectionSetting = newSetting;
            this.markReferenceCoordDirty();
        }
    }

    @Override
    public void setControlRodsInsertionRatio(int newRatio) {
        if (this.isAssembled()) {
            ReactorControlRodEntity.setInsertionRatio(this._attachedControlRods, Mth.m_14045_((int)newRatio, (int)0, (int)100));
        }
    }

    @Override
    public void changeControlRodsInsertionRatio(int delta) {
        if (this.isAssembled()) {
            ReactorControlRodEntity.changeInsertionRatio(this._attachedControlRods, delta);
        }
    }

    @Override
    public void ejectFuel() {
        this.ejectFuel(false);
    }

    @Override
    public void ejectFuel(boolean voidLeftover) {
        this.ejectReactant(ReactantType.Fuel, voidLeftover, this.getInputFluidAccessPorts(), this.getInputSolidAccessPorts());
    }

    @Override
    public void ejectFuel(boolean voidLeftover, BlockPos portPosition) {
        this.ejectReactant(ReactantType.Fuel, voidLeftover, this.getInputFluidAccessPorts().filter(port -> portPosition.equals((Object)port.getWorldPosition())), this.getInputSolidAccessPorts().filter(port -> portPosition.equals((Object)port.getWorldPosition())));
    }

    @Override
    public void ejectWaste() {
        this.ejectWaste(false);
    }

    @Override
    public void ejectWaste(boolean voidLeftover) {
        this.ejectReactant(ReactantType.Waste, voidLeftover, this.getOutputFluidAccessPorts(), this.getOutputSolidAccessPorts());
    }

    @Override
    public void ejectWaste(boolean voidLeftover, BlockPos portPosition) {
        this.ejectReactant(ReactantType.Waste, voidLeftover, this.getInputFluidAccessPorts().filter(port -> portPosition.equals((Object)port.getWorldPosition())), this.getInputSolidAccessPorts().filter(port -> portPosition.equals((Object)port.getWorldPosition())));
    }

    @Override
    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (data.m_128441_("wasteeject")) {
            this._wasteEjectionSetting = WasteEjectionSetting.read(data, "wasteeject", WasteEjectionSetting.Automatic);
        }
        this._logic.syncDataFrom(data, syncReason);
        this.syncChildDataEntityFrom((ISyncableEntity)this._fuelContainer, "fuelcontainer", data, syncReason);
        this.syncChildDataEntityFrom((ISyncableEntity)this._fluidContainer, "fluidcontainer", data, syncReason);
        this.syncChildDataEntityFrom(this._fuelHeat, "fuelheat", data, syncReason);
        this.syncChildDataEntityFrom(this._reactorHeat, "reactorheat", data, syncReason);
        if (syncReason.isNetworkUpdate()) {
            this.syncChildDataEntityFrom(this._uiStats, "stats", data, syncReason);
            this.updateClientFuelRodsLayout();
        }
    }

    @Override
    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        WasteEjectionSetting.write(data, "wasteeject", this.getWasteEjectionMode());
        this._logic.syncDataTo(data, syncReason);
        this.syncChildDataEntityTo((ISyncableEntity)this._fuelContainer, "fuelcontainer", data, syncReason);
        this.syncChildDataEntityTo((ISyncableEntity)this._fluidContainer, "fluidcontainer", data, syncReason);
        this.syncChildDataEntityTo(this._fuelHeat, "fuelheat", data, syncReason);
        this.syncChildDataEntityTo(this._reactorHeat, "reactorheat", data, syncReason);
        if (syncReason.isNetworkUpdate()) {
            this.syncChildDataEntityTo(this._uiStats, "stats", data, syncReason);
        }
        return data;
    }

    @Override
    public IMultiblockReactorVariant getVariant() {
        return this._variant;
    }

    protected void sendClientUpdates() {
        ProfilerFiller profiler = this.getWorld().m_46473_();
        profiler.m_6180_("sendTickUpdate");
        this.sendUpdates();
        profiler.m_7238_();
    }

    public boolean isPartCompatible(IMultiblockPart<MultiblockReactor> part) {
        return part instanceof AbstractReactorEntity && ((AbstractReactorEntity)part).getMultiblockVariant().filter(variant -> this.getVariant() == variant).isPresent();
    }

    protected void onPartAdded(IMultiblockPart<MultiblockReactor> newPart) {
        if (newPart instanceof ITickableMultiblockPart && this.calledByLogicalServer()) {
            if (ObjectLists.emptyList() == this._attachedTickables) {
                this._attachedTickables = new ObjectArrayList(4);
            }
            this._attachedTickables.add((ITickableMultiblockPart)newPart);
        }
        if (newPart instanceof ReactorControlRodEntity) {
            this._attachedControlRods.add((ReactorControlRodEntity)newPart);
        } else if (newPart instanceof ReactorFuelRodEntity) {
            this._attachedFuelRods.add((ReactorFuelRodEntity)newPart);
        } else if (newPart instanceof ReactorSolidAccessPortEntity) {
            this._attachedSolidAccessPorts.add((ReactorSolidAccessPortEntity)newPart);
        } else if (newPart instanceof ReactorFluidAccessPortEntity) {
            this._attachedFluidAccessPorts.add((ReactorFluidAccessPortEntity)newPart);
        } else if (newPart instanceof ReactorPowerTapEntity || newPart instanceof ReactorChargingPortEntity) {
            if (ObjectLists.emptyList() == this._attachedPowerTaps) {
                this._attachedPowerTaps = new ObjectArrayList(4);
            }
            this._attachedPowerTaps.add((IPowerPort)newPart);
        } else if (newPart instanceof ReactorFluidPortEntity) {
            if (ObjectLists.emptyList() == this._attachedFluidPorts) {
                this._attachedFluidPorts = new ObjectArrayList(4);
            }
            this._attachedFluidPorts.add((ReactorFluidPortEntity)newPart);
        }
    }

    protected void onPartRemoved(IMultiblockPart<MultiblockReactor> oldPart) {
        if (oldPart instanceof ITickableMultiblockPart && this.calledByLogicalServer() && ObjectLists.emptyList() != this._attachedTickables) {
            this._attachedTickables.remove(oldPart);
        }
        if (oldPart instanceof ReactorControlRodEntity) {
            this._attachedControlRods.remove(oldPart);
        } else if (oldPart instanceof ReactorFuelRodEntity) {
            this._attachedFuelRods.remove((ReactorFuelRodEntity)oldPart);
        } else if (oldPart instanceof ReactorSolidAccessPortEntity) {
            this._attachedSolidAccessPorts.remove(oldPart);
        } else if (oldPart instanceof ReactorFluidAccessPortEntity) {
            this._attachedFluidAccessPorts.remove(oldPart);
        } else if ((oldPart instanceof ReactorPowerTapEntity || oldPart instanceof ReactorChargingPortEntity) && ObjectLists.emptyList() != this._attachedPowerTaps) {
            this._attachedPowerTaps.remove(oldPart);
        } else if (oldPart instanceof ReactorFluidPortEntity && ObjectLists.emptyList() != this._attachedFluidPorts) {
            this._attachedFluidPorts.remove(oldPart);
        }
    }

    protected void onMachineAssembled() {
        if (this._attachedPowerTaps.isEmpty()) {
            this.setOutputEnergySystem(INTERNAL_ENERGY_SYSTEM);
        } else {
            CodeHelper.optionalIfPresentOrThrow(this._attachedPowerTaps.stream().map(IPowerPort::getPowerPortHandler).map(IPowerPortHandler::getEnergySystem).findFirst(), x$0 -> this.setOutputEnergySystem((EnergySystem)x$0));
        }
        this._mode = this.isAnyPartConnected(part -> part instanceof ReactorFluidPortEntity) ? OperationalMode.Active : OperationalMode.Passive;
        this.setInteriorInvisible(!this.isAnyPartConnected(part -> part instanceof ReactorGlassEntity));
        this._fuelRodsLayout = this.createFuelRodsLayout();
        this._attachedControlRods.forEach(rod -> rod.linkToFuelRods(this._fuelRodsLayout.getRodLength()));
        this._fuelRodsLayout.updateFuelRodsOcclusion(this.getWorld(), this._attachedFuelRods, this.isInteriorInvisible());
        this.rebuildFluidPortsSubsets();
        double multiplier = MultiblockReactor.getAdjustedPowerProductionMultiplier() * (double)this.getVariant().getEnergyGenerationEfficiency();
        this.getEnergyBuffer().setCapacity(WideAmount.from((double)((double)((long)this.getVariant().getPartEnergyCapacity() * (long)this.getPartsCount()) * multiplier)));
        this.getEnergyBuffer().setMaxExtract(this.getVariant().getMaxEnergyExtractionRate());
        this.resizeFuelContainer();
        this.calculateReactorVolume();
        this.updateFuelToReactorHeatTransferCoefficient();
        this.updateReactorToCoolantSystemHeatTransferCoefficient();
        this.updateReactorHeatLossCoefficient();
        this.resizeFluidContainer();
        this.callOnLogicalSide(() -> this.markReferenceCoordForUpdate(), () -> {
            this.updateClientFuelRodsLayout();
            this.markMultiblockForRenderUpdate();
        });
        super.onMachineAssembled();
    }

    protected void onMachineDisassembled() {
        this.markMultiblockForRenderUpdate();
    }

    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (this.getControlRodsCount() < 1) {
            validatorCallback.setLastError("multiblock.validation.reactor.too_few_rods", new Object[0]);
            return false;
        }
        if (!this.isAnyPartConnected(part -> part instanceof ReactorControllerEntity)) {
            validatorCallback.setLastError("multiblock.validation.reactor.too_few_controllers", new Object[0]);
            return false;
        }
        if (!this.validateFuelAssemblies(validatorCallback)) {
            return false;
        }
        if (!this.validateEnergySystems(validatorCallback)) {
            return false;
        }
        return super.isMachineWhole(validatorCallback);
    }

    protected void onAssimilate(IMultiblockController<MultiblockReactor> assimilated) {
        WideAmount otherEnergy;
        if (!(assimilated instanceof MultiblockReactor)) {
            Log.LOGGER.warn(Log.REACTOR, "[{}] Reactor @ {} is attempting to assimilate a non-Reactor machine! That machine's data will be lost!", (Object)CodeHelper.getWorldSideName((Level)this.getWorld()), (Object)this.getReferenceCoord());
            return;
        }
        MultiblockReactor otherReactor = (MultiblockReactor)assimilated;
        if (otherReactor._reactorHeat.getAsDouble() > this._reactorHeat.getAsDouble()) {
            this._reactorHeat.set(otherReactor._reactorHeat.getAsDouble());
        }
        if (otherReactor._fuelHeat.getAsDouble() > this._fuelHeat.getAsDouble()) {
            this._fuelHeat.set(otherReactor._fuelHeat.getAsDouble());
        }
        if ((otherEnergy = otherReactor.getEnergyBuffer().getEnergyStored(INTERNAL_ENERGY_SYSTEM)).greaterThan(this.getEnergyBuffer().getEnergyStored(INTERNAL_ENERGY_SYSTEM))) {
            this.getEnergyBuffer().setEnergyStored(otherEnergy, INTERNAL_ENERGY_SYSTEM);
        }
        this._logic.syncDataFrom(otherReactor._logic);
        this._fuelContainer.syncDataFrom((IMergeableEntity)otherReactor._fuelContainer);
        this._fluidContainer.syncDataFrom((IMergeableEntity)otherReactor._fluidContainer);
    }

    protected void onAssimilated(IMultiblockController<MultiblockReactor> assimilator) {
        this._attachedTickables.clear();
        this._attachedControlRods.clear();
        this._attachedFuelRods.clear();
        this._attachedSolidAccessPorts.clear();
        this._attachedFluidAccessPorts.clear();
        this._attachedPowerTaps.clear();
        this._attachedFluidPorts.clear();
        this._attachedOutputFluidPorts = this._attachedInputFluidPorts = ObjectLists.emptyList();
        this._fuelRodsLayout = FuelRodsLayout.EMPTY;
    }

    protected boolean updateServer() {
        ProfilerFiller profiler = this.getWorld().m_46473_();
        profiler.m_6180_("Extreme Reactors|Reactor update");
        profiler.m_6180_("Generate");
        boolean updateResult = this._logic.update();
        profiler.m_6182_("Tickables");
        this._attachedTickables.forEach(ITickableMultiblockPart::onMultiblockServerTick);
        profiler.m_6182_("Updates");
        this.checkAndSendClientUpdates();
        profiler.m_6182_("Mark4Update");
        if (!this._sendUpdateFuelRodsLayout && updateResult) {
            this._sendUpdateFuelRodsLayout = true;
        }
        if (this._sendUpdateFuelRodsLayout) {
            this._sendUpdateFuelRodsLayoutDelayedRunnable.run();
        }
        profiler.m_7238_();
        profiler.m_7238_();
        return updateResult;
    }

    protected boolean isBlockGoodForFrame(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockReactor.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForTop(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockReactor.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForBottom(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockReactor.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForSides(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockReactor.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForInterior(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        BlockPos position = new BlockPos(x, y, z);
        BlockState blockState = world.m_8055_(position);
        if (ReactantHelper.isValidModerator(blockState)) {
            return true;
        }
        validatorCallback.setLastError(position, "multiblock.validation.reactor.invalid_block_for_interior", new Object[]{ModBlock.getNameForTranslation((Block)blockState.m_60734_())});
        return false;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        if (!this.isAssembled()) {
            return;
        }
        messages.addUnlocalized("Active: %s", new Object[]{this.isMachineActive()});
        this.getEnergyBuffer().getDebugMessages(side, messages);
        messages.addUnlocalized("Casing Heat: %1$.4f C; Fuel Heat: %2$.4f C", new Object[]{this._reactorHeat.getAsDouble(), this._fuelHeat.getAsDouble()});
        messages.add(side, (IDebuggable)this._fuelContainer, "Reactant Tanks:");
        boolean activeCooling = this.getOperationalMode().isActive();
        messages.addUnlocalized("Actively Cooled: %1$s", new Object[]{activeCooling});
        if (activeCooling) {
            messages.addUnlocalized("Coolant Tanks:");
            this._fluidContainer.getDebugMessages(side, messages);
        }
    }

    private Stream<IFuelSource<ItemStack>> getInputSolidAccessPorts() {
        return this._attachedSolidAccessPorts.stream().filter(port -> null != port && port.isConnected() && port.getIoDirection().isInput()).map(port -> port);
    }

    private Stream<IFuelSource<ItemStack>> getOutputSolidAccessPorts() {
        return this._attachedSolidAccessPorts.stream().filter(port -> null != port && port.isConnected() && port.getIoDirection().isOutput()).map(port -> port);
    }

    private Stream<IFuelSource<FluidStack>> getInputFluidAccessPorts() {
        return this._attachedFluidAccessPorts.stream().filter(port -> null != port && port.isConnected() && port.getIoDirection().isInput()).map(port -> port);
    }

    private Stream<IFuelSource<FluidStack>> getOutputFluidAccessPorts() {
        return this._attachedFluidAccessPorts.stream().filter(port -> null != port && port.isConnected() && port.getIoDirection().isOutput()).map(port -> port);
    }

    private void rebuildFluidPortsSubsets() {
        ArrayList input = Lists.newArrayListWithCapacity((int)this._attachedFluidPorts.size());
        ArrayList output = Lists.newArrayListWithCapacity((int)this._attachedFluidPorts.size());
        for (ReactorFluidPortEntity port : this._attachedFluidPorts) {
            if (!port.getFluidPortHandler().isActive()) continue;
            (port.getIoDirection().isInput() ? input : output).add(port);
        }
        this._attachedInputFluidPorts = new ObjectArrayList((Collection)input);
        this._attachedOutputFluidPorts = new ObjectArrayList((Collection)output);
    }

    private FuelRodsLayout createFuelRodsLayout() {
        Direction direction = this.getControlRodByIndex(0).flatMap(AbstractCuboidMultiblockPart::getOutwardDirection).orElse(Direction.UP);
        return ExtremeReactors.getProxy().createFuelRodsLayout(direction, switch (direction.m_122434_()) {
            default -> (Integer)this.mapBoundingBoxCoordinates((min, max) -> Math.max(1, max.m_123341_() - min.m_123341_() - 1), 0);
            case Direction.Axis.Y -> (Integer)this.mapBoundingBoxCoordinates((min, max) -> Math.max(1, max.m_123342_() - min.m_123342_() - 1), 0);
            case Direction.Axis.Z -> (Integer)this.mapBoundingBoxCoordinates((min, max) -> Math.max(1, max.m_123343_() - min.m_123343_() - 1), 0);
        });
    }

    private void updateClientFuelRodsLayout() {
        IntSet updatedIndices;
        if (this.isAssembled() && this._fuelRodsLayout.isNotEmpty() && !(updatedIndices = this._fuelRodsLayout.updateFuelData(this._fuelContainer, this.getFuelRodsCount())).isEmpty()) {
            if (updatedIndices.contains(-1)) {
                this._attachedFuelRods.markFuelRodsForRenderUpdate();
            } else {
                this._attachedFuelRods.markFuelRodsForRenderUpdate(updatedIndices);
            }
        }
    }

    private void sendUpdateFuelRodsLayout() {
        if (!this.getReferenceTracker().isInvalid()) {
            CuboidBoundingBox bb = this.getBoundingBox();
            int radius = Math.max(bb.getLengthX(), bb.getLengthZ()) + 32;
            ExtremeReactors.getInstance().sendPacket(new UpdateClientsFuelRodsLayout((AbstractReactorEntity)this.getReferenceTracker().get(), (ISyncableEntity)this._fuelContainer), this.getWorld(), bb.getCenter(), radius);
            this._sendUpdateFuelRodsLayout = false;
        }
    }

    private static boolean invalidBlockForExterior(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        BlockPos position = new BlockPos(x, y, z);
        validatorCallback.setLastError(position, "multiblock.validation.reactor.invalid_block_for_exterior", new Object[]{ModBlock.getNameForTranslation((Block)world.m_8055_(position).m_60734_())});
        return false;
    }

    private boolean refuelSolid() {
        if (this._fuelContainer.getFreeSpace(ReactantType.Fuel) < 1000) {
            return false;
        }
        if (ReactantHelper.refuelSolid(this._fuelContainer, this.getInputSolidAccessPorts(), this.getVariant())) {
            this.markReferenceCoordForUpdate();
            this.markReferenceCoordDirty();
            return true;
        }
        return false;
    }

    private boolean refuelFluid() {
        if (this._fuelContainer.getFreeSpace(ReactantType.Fuel) < 1) {
            return false;
        }
        if (ReactantHelper.refuelFluid(this._fuelContainer, this.getInputFluidAccessPorts(), this.getVariant())) {
            this.markReferenceCoordForUpdate();
            this.markReferenceCoordDirty();
            return true;
        }
        return false;
    }

    private void distributeEnergyEqually() {
        WideEnergyBuffer energyBuffer = this.getEnergyBuffer();
        WideAmount amountDistributed = MultiblockReactor.distributeEnergyEqually(energyBuffer.getEnergyStored(), this._attachedPowerTaps);
        if (amountDistributed.greaterThan(WideAmount.ZERO)) {
            energyBuffer.shrink(amountDistributed);
        }
    }

    private void distributeGasEqually() {
        int amountDistributed = MultiblockReactor.distributeFluidEqually((FluidStack)this._fluidContainer.getStackCopy(FluidType.Gas), this._attachedOutputFluidPorts);
        if (amountDistributed > 0) {
            this._fluidContainer.extract(FluidType.Gas, amountDistributed, OperationMode.Execute);
        }
    }

    private boolean acquireFluidEqually() {
        return MultiblockReactor.acquireFluidEqually(this._fluidContainer.getWrapper(IoDirection.Input), this._fluidContainer.getFreeSpace(FluidType.Liquid), this._attachedInputFluidPorts) > 0;
    }

    private void resizeFuelContainer() {
        this._fuelContainer.setCapacity(this.getFuelRodsCount() * 4000);
    }

    private void resizeFluidContainer() {
        if (this.getOperationalMode().isActive()) {
            int outerVolume = this.getBoundingBox().getVolume() - this.getReactorVolume();
            this._fluidContainer.setCapacity(Mth.m_14045_((int)(outerVolume * this.getVariant().getPartFluidCapacity()), (int)0, (int)this.getVariant().getMaxFluidCapacity()));
        } else {
            this._fluidContainer.setCapacity(0);
        }
    }

    private void calculateReactorVolume() {
        CuboidBoundingBox bb = this.getBoundingBox();
        BlockPos min = bb.getMin().m_7918_(1, 1, 1);
        BlockPos max = bb.getMax().m_7918_(-1, -1, -1);
        this._reactorVolume = CodeHelper.mathVolume((BlockPos)min, (BlockPos)max);
    }

    private void updateFuelToReactorHeatTransferCoefficient() {
        this._fuelToReactorHeatTransferCoefficient = this._attachedFuelRods.getHeatTransferRate();
    }

    private void updateReactorToCoolantSystemHeatTransferCoefficient() {
        this._reactorToCoolantSystemHeatTransferCoefficient = 0.6f * (float)MultiblockReactor.internalSurfaceArea(this.getBoundingBox());
    }

    private void updateReactorHeatLossCoefficient() {
        this._reactorHeatLossCoefficient = 0.001f * (float)MultiblockReactor.externalSurfaceArea(this.getBoundingBox());
    }

    private static int internalSurfaceArea(CuboidBoundingBox bb) {
        int xSize = bb.getLengthX() - 2;
        int ySize = bb.getLengthY() - 2;
        int zSize = bb.getLengthZ() - 2;
        return 2 * (xSize * ySize + xSize * zSize + ySize * zSize);
    }

    private static int externalSurfaceArea(CuboidBoundingBox bb) {
        int xSize = bb.getLengthX();
        int ySize = bb.getLengthY();
        int zSize = bb.getLengthZ();
        return 2 * (xSize * ySize + xSize * zSize + ySize * zSize);
    }

    private boolean validateControlRodsOrientation(Direction firstDirection) {
        return this._attachedControlRods.stream().map(AbstractCuboidMultiblockPart::getOutwardFacingFromWorldPosition).filter(Optional::isPresent).map(Optional::get).allMatch(direction -> firstDirection == direction);
    }

    private int validateFuelAssembly(IMultiblockValidator validatorCallback, BlockPos controlRodPosition, Direction scanDirection) {
        IMultiblockPart part;
        BlockPos.MutableBlockPos scanPosition = controlRodPosition.m_122032_();
        int validRodsFound = 0;
        while (true) {
            scanPosition.m_122173_(scanDirection);
            part = this._connectedParts.get((BlockPos)scanPosition);
            if (!(part instanceof ReactorFuelRodEntity)) break;
            ++validRodsFound;
        }
        if (part instanceof AbstractReactorEntity) {
            if (ReactorPartType.Casing != ((AbstractReactorEntity)part).getPartTypeOrDefault((IMultiblockPartType)ReactorPartType.Glass)) {
                validatorCallback.setLastError((BlockPos)scanPosition, "multiblock.validation.reactor.invalid_base_for_fuel_assembly", new Object[0]);
                return 0;
            }
            return validRodsFound;
        }
        validatorCallback.setLastError((BlockPos)scanPosition, "multiblock.validation.reactor.invalid_block_in_fuel_assembly", new Object[0]);
        return 0;
    }

    private boolean validateFuelAssemblies(IMultiblockValidator validatorCallback) {
        Optional firstDirection = this._attachedControlRods.get(0).getOutwardFacingFromWorldPosition();
        if (!firstDirection.isPresent()) {
            validatorCallback.setLastError("multiblock.validation.reactor.invalid_control_side", new Object[0]);
            return false;
        }
        if (!firstDirection.map(this::validateControlRodsOrientation).orElse(false).booleanValue()) {
            validatorCallback.setLastError("multiblock.validation.reactor.invalid_control_side", new Object[0]);
            return false;
        }
        Direction scanDirection = ((Direction)firstDirection.get()).m_122424_();
        int validRodsFound = 0;
        for (ReactorControlRodEntity controlRod : this._attachedControlRods) {
            int found = this.validateFuelAssembly(validatorCallback, controlRod.getWorldPosition(), scanDirection);
            if (0 == found) {
                return false;
            }
            validRodsFound += found;
        }
        if (this.getFuelRodsCount() != validRodsFound) {
            validatorCallback.setLastError("multiblock.validation.reactor.invalid_fuel_rods", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean validateEnergySystems(IMultiblockValidator validatorCallback) {
        if (!this._attachedPowerTaps.isEmpty() && 1L != this._attachedPowerTaps.stream().map(IPowerPort::getPowerPortHandler).map(IPowerPortHandler::getEnergySystem).distinct().limit(2L).count()) {
            validatorCallback.setLastError("multiblock.validation.reactor.mixed_power_systems", new Object[0]);
            return false;
        }
        return true;
    }

    private void ejectReactant(ReactantType type, boolean voidLeftover, Stream<IFuelSource<FluidStack>> fluidFuelSources, Stream<IFuelSource<ItemStack>> solidFuelSources) {
        if (ReactantHelper.ejectReactant(type, true, this._fuelContainer, voidLeftover, fluidFuelSources) || ReactantHelper.ejectReactant(type, false, this._fuelContainer, voidLeftover, solidFuelSources)) {
            this.markReferenceCoordForUpdate();
            this.markReferenceCoordDirty();
        }
    }
}

