/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.zerocore.lib.recipe.ISerializableRecipe;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IHeldRecipe;
import it.zerono.mods.zerocore.lib.recipe.result.FluidStackRecipeResult;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public interface IFluidizerRecipe
extends ISerializableRecipe {
    public Type getRecipeType();

    public FluidStackRecipeResult getResult();

    public int getEnergyUsageMultiplier();

    default public int getEnergyUsageMultiplier(FluidStack stack) {
        return (int)Math.ceil((double)stack.getAmount() / 1000.0);
    }

    public static enum Type {
        Invalid("invalid_recipe", -1),
        Solid("fluidizersolid", 40),
        SolidMixing("fluidizersolidmixing", 80),
        FluidMixing("fluidizerfluidmixing", 80);

        private final String _name;
        private final ResourceLocation _id;
        private final int _ticks;

        public String getRecipeName() {
            return this._name;
        }

        public ResourceLocation getRecipeId() {
            return this._id;
        }

        public int getTicks() {
            return this._ticks;
        }

        private Type(String name, int ticks) {
            this._name = name;
            this._id = ExtremeReactors.ROOT_LOCATION.buildWithSuffix(name);
            this._ticks = ticks;
        }
    }

    public static interface Held<Recipe extends ModRecipe>
    extends IHeldRecipe<Recipe> {
    }
}

