/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.client.model;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.EnergizerPartType;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType;
import it.zerono.mods.zerocore.lib.block.property.BlockFacingsProperty;
import it.zerono.mods.zerocore.lib.client.model.multiblock.CuboidPartVariantsModelBuilder;
import java.util.function.Function;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;

public class EnergizerModelBuilder
extends CuboidPartVariantsModelBuilder {
    public EnergizerModelBuilder() {
        this("assembledplating");
    }

    protected EnergizerModelBuilder(String templateName) {
        super(EnergizerModelBuilder.getModelRL(templateName), true);
        this.build();
    }

    protected void build() {
        Function<String, ResourceLocation> modelToReplaceIdGetter = blockName -> new ModelResourceLocation(ExtremeReactors.ROOT_LOCATION.buildWithSuffix("energizer" + blockName), "");
        Function<String, ResourceLocation> variantModelIdGetter = EnergizerModelBuilder::getModelRL;
        this.addBlockWithVariants(modelToReplaceIdGetter, variantModelIdGetter, (IMultiblockPartType)EnergizerPartType.Casing, "casing", new String[]{"casing_01_face", "casing_02_frame_ds", "casing_03_frame_de", "casing_04_frame_dn", "casing_05_frame_dw", "casing_06_frame_us", "casing_07_frame_ue", "casing_08_frame_un", "casing_09_frame_uw", "casing_10_frame_se", "casing_11_frame_ne", "casing_12_frame_nw", "casing_13_frame_sw", "casing_14_corner_dsw", "casing_15_corner_dse", "casing_16_corner_dne", "casing_17_corner_dnw", "casing_18_corner_usw", "casing_19_corner_use", "casing_20_corner_une", "casing_21_corner_unw"});
        this.addBlockWithVariants(modelToReplaceIdGetter, variantModelIdGetter, (IMultiblockPartType)EnergizerPartType.Controller, "controller", new String[]{"controller_on", "controller_off"});
        this.addBlockWithVariants(modelToReplaceIdGetter, variantModelIdGetter, (IMultiblockPartType)EnergizerPartType.PowerPortFE, "powerportfe", new String[]{"powerportfe_input", "powerportfe_assembled_input", "powerportfe_assembled_input_connected", "powerportfe_assembled_output", "powerportfe_assembled_output_connected"});
        this.addBlockWithVariants(modelToReplaceIdGetter, variantModelIdGetter, (IMultiblockPartType)EnergizerPartType.ActivePowerPortFE, "powerportfe_active", new String[]{"powerportfe_active_input", "powerportfe_active_assembled_input", "powerportfe_active_assembled_input_connected", "powerportfe_active_assembled_output", "powerportfe_active_assembled_output_connected"});
        this.addBlockWithVariants(modelToReplaceIdGetter, variantModelIdGetter, (IMultiblockPartType)EnergizerPartType.ChargingPortFE, "chargingportfe", new String[]{"charging_assembled"});
        this.addBlockWithVariants(modelToReplaceIdGetter, variantModelIdGetter, (IMultiblockPartType)EnergizerPartType.ComputerPort, "computerport", new String[]{"computerport_assembled_disconnected", "computerport_assembled_connected"});
        this.setFallbackModelData(EnergizerPartType.Casing.ordinal(), BlockFacingsProperty.None.ordinal());
    }

    protected static ResourceLocation getModelRL(String modelName) {
        return ExtremeReactors.ROOT_LOCATION.appendPath(new String[]{"block", "energizer"}).buildWithSuffix(modelName);
    }
}

