/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType;
import it.zerono.mods.zerocore.lib.client.model.multiblock.CuboidPartVariantsModelBuilder;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractMultiblockModelBuilder<PartType extends IMultiblockPartType>
extends CuboidPartVariantsModelBuilder {
    private final String _multiblockShortName;
    private final ResourceLocationBuilder _root;
    private final ResourceLocationBuilder _blockRoot;

    protected AbstractMultiblockModelBuilder(String multiblockShortName, ResourceLocationBuilder root, ResourceLocationBuilder blockRoot, ResourceLocation template, boolean ambientOcclusion) {
        super(template, ambientOcclusion);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)multiblockShortName) ? 1 : 0) != 0, (Object)"Multiblock short name must not be null or empty");
        Preconditions.checkNotNull((Object)root, (Object)"Root must not be null");
        Preconditions.checkNotNull((Object)blockRoot, (Object)"Block root must not be null");
        this._multiblockShortName = multiblockShortName;
        this._root = root;
        this._blockRoot = blockRoot;
    }

    protected void addBlockWithVariants(PartType partType, IMultiblockVariant variant, Predicate<PartType> isPartCompatibleWithVariant, String blockCommonName, String ... additionalVariantsModelNames) {
        this.addBlock(partType, variant, isPartCompatibleWithVariant, blockCommonName);
        this.addBlockVariants(partType, variant, isPartCompatibleWithVariant, blockCommonName, additionalVariantsModelNames);
    }

    protected void addBlock(PartType partType, IMultiblockVariant variant, Predicate<PartType> isPartCompatibleWithVariant, String blockCommonName) {
        if (isPartCompatibleWithVariant.test(partType)) {
            super.addBlock((int)partType.getByteHashCode(), this.getBlockStateRL(variant, blockCommonName), 0, false);
        }
    }

    protected void addBlockVariants(PartType partType, IMultiblockVariant variant, Predicate<PartType> isPartCompatibleWithVariant, String blockCommonName, String ... additionalVariantsModelNames) {
        if (isPartCompatibleWithVariant.test(partType)) {
            ArrayList variants = Lists.newArrayListWithCapacity((int)(1 + additionalVariantsModelNames.length));
            variants.add(this.getBlockStateRL(variant, blockCommonName));
            Arrays.stream(additionalVariantsModelNames).map(name -> this.getModelRL(variant, (String)name)).collect(Collectors.toCollection(() -> variants));
            this.addModels(partType.getByteHashCode(), variants);
        }
    }

    protected ResourceLocation getBlockStateRL(IMultiblockVariant variant, String blockCommonName) {
        return this.getBlockStateRL(variant, blockCommonName, "");
    }

    protected ResourceLocation getBlockStateRL(IMultiblockVariant variant, String blockCommonName, String blockStateVariant) {
        return new ModelResourceLocation(this._root.buildWithSuffix(variant.getName() + "_" + this._multiblockShortName + blockCommonName), blockStateVariant);
    }

    protected ResourceLocation getModelRL(IMultiblockVariant variant, String modelName) {
        return this._blockRoot.appendPath(new String[]{variant.getName()}).buildWithSuffix(modelName);
    }
}

