/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.harvest_with_ease.api;

import it.crystalnest.cobweb.api.block.BlockUtils;
import it.crystalnest.cobweb.api.item.TierUtils;
import it.crystalnest.harvest_with_ease.config.ModConfig;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.NoSuchElementException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.TorchflowerCropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public final class HarvestUtils {
    public static final TagKey<Block> BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("harvest_with_ease", "blacklist"));

    private HarvestUtils() {
    }

    public static boolean isCrop(Block block) {
        return !(block instanceof TorchflowerCropBlock) && (block instanceof CropBlock || block instanceof NetherWartBlock || block instanceof CocoaBlock || block instanceof PitcherCropBlock || ModConfig.getCrops().contains(BlockUtils.getStringKey((Block)block)));
    }

    public static boolean isAllowed(BlockState block) {
        return ModConfig.getBlacklist().stream().noneMatch(id -> id.equalsIgnoreCase(BlockUtils.getStringKey((Block)block.m_60734_()))) && !block.m_204336_(BLACKLIST);
    }

    public static boolean hasEnoughHunger(Player player) {
        return player.m_9236_().m_46791_() == Difficulty.PEACEFUL || ModConfig.getExhaustionMultiplier().compareTo(BigDecimal.ZERO) == 0 || (double)((float)player.m_36324_().m_38702_() + player.m_36324_().m_38722_()) - Math.floor(player.m_36324_().m_150380_() / 4.0f) >= 0.0;
    }

    public static IntegerProperty getAge(BlockState blockState) throws NullPointerException, NoSuchElementException, ClassCastException {
        return (IntegerProperty)blockState.m_61147_().stream().filter(property -> "age".equals(property.m_61708_())).findFirst().orElseThrow();
    }

    public static boolean isMature(BlockState blockState, IntegerProperty age) {
        return blockState.m_61145_((Property)age).orElse(0) >= (Integer)Collections.max(age.m_6908_());
    }

    public static boolean isMature(BlockState blockState) throws NullPointerException, NoSuchElementException, ClassCastException {
        return HarvestUtils.isMature(blockState, HarvestUtils.getAge(blockState));
    }

    public static boolean isTallCrop(BlockGetter level, BlockState blockState, BlockPos blockPos) {
        return blockState.m_204336_(BlockTags.f_13073_) && level.m_8055_(blockPos.m_7495_()).m_60713_(blockState.m_60734_()) || level.m_8055_(blockPos.m_7494_()).m_60713_(blockState.m_60734_());
    }

    public static boolean isTierForMultiHarvest(TieredItem tool) {
        return TierUtils.compare((Tier)tool.m_43314_(), (Tier)TierUtils.getTier((String)ModConfig.getMultiHarvestStartingTier())) >= 0;
    }
}

