/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.mixin.accessors.PaletteAccess;
import blusunrize.immersiveengineering.mixin.accessors.TemplateAccess;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.GameData;

public class MessageMultiblockSync
implements IMessage {
    private final List<SyncedTemplate> templates;

    public MessageMultiblockSync(List<SyncedTemplate> templatesToSync) {
        this.templates = templatesToSync;
    }

    public MessageMultiblockSync(FriendlyByteBuf buf) {
        this.templates = PacketUtils.readList(buf, SyncedTemplate::new);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        PacketUtils.writeList(buf, this.templates, SyncedTemplate::writeTo);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            for (SyncedTemplate synced : this.templates) {
                StructureTemplate template = new StructureTemplate();
                TemplateAccess access = (TemplateAccess)template;
                access.setSize((Vec3i)synced.size);
                access.getPalettes().add(synced.parts);
                TemplateMultiblock.SYNCED_CLIENT_TEMPLATES.put(synced.name, template);
            }
            ImmersiveEngineering.proxy.resetManual();
        });
    }

    public static class SyncedTemplate {
        private final BlockPos size;
        private final ResourceLocation name;
        private final StructureTemplate.Palette parts;

        public SyncedTemplate(StructureTemplate template, ResourceLocation name) {
            this.size = new BlockPos(template.m_163801_());
            this.parts = ((TemplateAccess)template).getPalettes().get(0);
            this.name = name;
        }

        public SyncedTemplate(FriendlyByteBuf buffer) {
            this.size = buffer.m_130135_();
            this.name = buffer.m_130281_();
            this.parts = PaletteAccess.construct(PacketUtils.readList(buffer, SyncedTemplate::readPart));
        }

        public void writeTo(FriendlyByteBuf buffer) {
            buffer.m_130064_(this.size);
            buffer.m_130085_(this.name);
            PacketUtils.writeList(buffer, this.parts.m_74652_(), SyncedTemplate::writePart);
        }

        private static StructureTemplate.StructureBlockInfo readPart(FriendlyByteBuf buffer) {
            IdMapper stateIds = GameData.getBlockStateIDMap();
            BlockState state = (BlockState)stateIds.m_7942_(buffer.m_130242_());
            BlockPos pos = buffer.m_130135_();
            CompoundTag nbt = buffer.m_130260_();
            return new StructureTemplate.StructureBlockInfo(pos, Objects.requireNonNull(state), nbt);
        }

        private static void writePart(StructureTemplate.StructureBlockInfo info, FriendlyByteBuf buffer) {
            IdMapper stateIds = GameData.getBlockStateIDMap();
            buffer.m_130130_(stateIds.m_7447_((Object)info.f_74676_()));
            buffer.m_130064_(info.f_74675_());
            buffer.m_130079_(info.f_74677_());
        }
    }
}

