/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.util;

import io.github.mortuusars.scholar.util.Change;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.Nullable;

public class History {
    protected final Deque<Change> undoStack = new ArrayDeque<Change>(50);
    protected final Deque<Change> redoStack = new ArrayDeque<Change>(50);
    protected final int maxChanges;

    public History(int maxChanges) {
        this.maxChanges = maxChanges;
    }

    public History() {
        this(50);
    }

    public void add(Change change) {
        if (this.undoStack.size() > this.maxChanges) {
            this.undoStack.removeFirst();
        }
        this.undoStack.addLast(change);
        this.redoStack.clear();
    }

    public void add(Runnable apply, Runnable undo) {
        this.add(Change.create(apply, undo));
    }

    @Nullable
    public Change undo() {
        if (!this.undoStack.isEmpty()) {
            Change lastEdit = this.undoStack.removeLast();
            if (!lastEdit.undo()) {
                this.undoStack.clear();
                this.redoStack.clear();
            } else {
                this.redoStack.addLast(lastEdit);
            }
            return lastEdit;
        }
        return null;
    }

    @Nullable
    public Change redo() {
        if (!this.redoStack.isEmpty()) {
            Change change = this.redoStack.removeLast();
            change.apply();
            this.undoStack.addLast(change);
            return change;
        }
        return null;
    }
}

