/*
 * Decompiled with CFR 0.152.
 */
package com.imjustseiyin.justoutdoorstuffs.sit;

import com.imjustseiyin.justoutdoorstuffs.block.custom.ChairBlock;
import com.imjustseiyin.justoutdoorstuffs.block.custom.DoubleChairBlock;
import com.imjustseiyin.justoutdoorstuffs.sit.SitEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.tuple.Pair;

public class SitUtil {
    private static final Map<ResourceLocation, Map<BlockPos, Pair<SitEntity, BlockPos>>> OCCUPIED = new HashMap<ResourceLocation, Map<BlockPos, Pair<SitEntity, BlockPos>>>();

    public static boolean addSitEntity(Level level, BlockPos blockPos, SitEntity entity, BlockPos playerPos) {
        if (!level.m_5776_()) {
            ResourceLocation id = level.m_46472_().m_211136_();
            if (!OCCUPIED.containsKey(id)) {
                OCCUPIED.put(id, new HashMap());
            }
            OCCUPIED.get(id).put(blockPos, (Pair<SitEntity, BlockPos>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static boolean removeSitEntity(Level level, BlockPos pos) {
        ResourceLocation id;
        if (!level.m_5776_() && OCCUPIED.containsKey(id = level.m_46472_().m_211136_())) {
            OCCUPIED.get(id).remove(pos);
            return true;
        }
        return false;
    }

    public static SitEntity getSitEntity(Level level, BlockPos pos) {
        ResourceLocation id;
        if (!level.m_5776_() && OCCUPIED.containsKey(id = level.m_46472_().m_211136_()) && OCCUPIED.get(id).containsKey(pos)) {
            return (SitEntity)((Object)OCCUPIED.get(id).get(pos).getLeft());
        }
        return null;
    }

    public static BlockPos getPreviousPlayerPosition(Player player, SitEntity sitEntity) {
        ResourceLocation id;
        if (!player.m_9236_().m_5776_() && OCCUPIED.containsKey(id = player.m_9236_().m_46472_().m_211136_())) {
            for (Pair<SitEntity, BlockPos> pair : OCCUPIED.get(id).values()) {
                if (pair.getLeft() != sitEntity) continue;
                BlockPos pos = (BlockPos)pair.getRight();
                Block block = player.m_9236_().m_8055_(pos).m_60734_();
                Block blockAbove = player.m_9236_().m_8055_(pos.m_7494_()).m_60734_();
                if (block instanceof ChairBlock || block instanceof DoubleChairBlock) {
                    return pos.m_7494_();
                }
                if (blockAbove instanceof ChairBlock || blockAbove instanceof DoubleChairBlock) {
                    return pos.m_6630_(2);
                }
                return pos;
            }
        }
        return null;
    }

    public static boolean isOccupied(Level level, BlockPos pos) {
        ResourceLocation id = level.m_46472_().m_211136_();
        return OCCUPIED.containsKey(id) && OCCUPIED.get(id).containsKey(pos);
    }
}

