/*
 * Decompiled with CFR 0.152.
 */
package com.imjustseiyin.justoutdoorstuffs.block.custom;

import com.imjustseiyin.justoutdoorstuffs.util.QuadTablePart;
import com.imjustseiyin.justoutdoorstuffs.util.VoxelHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class QuadTableBlock
extends HorizontalDirectionalBlock {
    public static final EnumProperty<QuadTablePart> PART = EnumProperty.m_61587_((String)"part", QuadTablePart.class);
    private final VoxelShape SHAPE;

    public QuadTableBlock(BlockBehaviour.Properties pProperties, VoxelShape voxelShape) {
        super(pProperties);
        this.SHAPE = voxelShape;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)QuadTablePart.FRONTLEFT)));
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (!(pDirection != QuadTableBlock.getDirectionTowardsBackPart((QuadTablePart)((Object)pState.m_61143_(PART)), (Direction)pState.m_61143_((Property)f_54117_)) && pDirection != QuadTableBlock.getDirectionTowardsSidePart((QuadTablePart)((Object)pState.m_61143_(PART)), (Direction)pState.m_61143_((Property)f_54117_)) || pNeighborState.m_60713_((Block)this) && pNeighborState.m_61143_(PART) != pState.m_61143_(PART))) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    private static Direction getDirectionTowardsBackPart(QuadTablePart part, Direction direction) {
        return part == QuadTablePart.FRONTLEFT || part == QuadTablePart.FRONTRIGHT ? direction.m_122424_() : direction;
    }

    private static Direction getDirectionTowardsSidePart(QuadTablePart part, Direction direction) {
        return part == QuadTablePart.FRONTLEFT || part == QuadTablePart.BACKLEFT ? direction.m_122428_() : direction.m_122427_();
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (!pLevel.m_5776_()) {
            Direction direction = (Direction)pState.m_61143_((Property)f_54117_);
            BlockPos backLeftBlockPos = pPos.m_121945_(direction.m_122424_());
            BlockPos backRightBlockPos = backLeftBlockPos.m_121945_(direction.m_122428_());
            BlockPos frontRightBlockPos = backRightBlockPos.m_121945_(direction);
            pLevel.m_7731_(backLeftBlockPos, (BlockState)((BlockState)pState.m_61124_(PART, (Comparable)((Object)QuadTablePart.BACKLEFT))).m_61124_((Property)f_54117_, (Comparable)((Direction)pState.m_61143_((Property)f_54117_))), 3);
            pLevel.m_7731_(backRightBlockPos, (BlockState)((BlockState)pState.m_61124_(PART, (Comparable)((Object)QuadTablePart.BACKRIGHT))).m_61124_((Property)f_54117_, (Comparable)((Direction)pState.m_61143_((Property)f_54117_))), 3);
            pLevel.m_7731_(frontRightBlockPos, (BlockState)((BlockState)pState.m_61124_(PART, (Comparable)((Object)QuadTablePart.FRONTRIGHT))).m_61124_((Property)f_54117_, (Comparable)((Direction)pState.m_61143_((Property)f_54117_))), 3);
            pLevel.m_6289_(pPos, Blocks.f_50016_);
            pState.m_60701_((LevelAccessor)pLevel, pPos, 3);
        }
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.f_46443_ && pPlayer.m_7500_()) {
            QuadTablePart brokenBlockTablePart = (QuadTablePart)((Object)pState.m_61143_(PART));
            Direction brokenFacing = (Direction)pState.m_61143_((Property)f_54117_);
            if (brokenBlockTablePart == QuadTablePart.FRONTLEFT) {
                BlockPos backLeftBlockPos = pPos.m_121945_(QuadTableBlock.getDirectionTowardsBackPart(brokenBlockTablePart, brokenFacing));
                BlockPos backRightBlockPos = backLeftBlockPos.m_121945_(QuadTableBlock.getDirectionTowardsSidePart(brokenBlockTablePart, (Direction)pLevel.m_8055_(backLeftBlockPos).m_61143_((Property)f_54117_)));
                BlockPos frontRightBlockPos = pPos.m_121945_(QuadTableBlock.getDirectionTowardsSidePart(brokenBlockTablePart, brokenFacing));
                this.removeBlockIfMatch(pLevel, pPlayer, backRightBlockPos, QuadTablePart.BACKRIGHT);
                this.removeBlockIfMatch(pLevel, pPlayer, backLeftBlockPos, QuadTablePart.BACKLEFT);
                this.removeBlockIfMatch(pLevel, pPlayer, frontRightBlockPos, QuadTablePart.FRONTRIGHT);
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    private void removeBlockIfMatch(Level world, Player player, BlockPos pos, QuadTablePart part) {
        BlockState posBlockState = world.m_8055_(pos);
        if (posBlockState.m_60713_((Block)this) && posBlockState.m_61143_(PART) == part) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, pos, Block.m_49956_((BlockState)posBlockState));
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction = pContext.m_8125_().m_122424_();
        BlockPos frontLeftBlockPos = pContext.m_8083_();
        BlockPos backLeftBlockPos = frontLeftBlockPos.m_121945_(direction.m_122424_());
        BlockPos backRightBlockPos = frontLeftBlockPos.m_121945_(direction.m_122424_()).m_121945_(direction.m_122428_());
        BlockPos frontRightBlockPos = backRightBlockPos.m_121945_(direction);
        Level world = pContext.m_43725_();
        return this.isBlockEmpty(pContext, world, backLeftBlockPos) != false && this.isBlockEmpty(pContext, world, backRightBlockPos) != false && this.isBlockEmpty(pContext, world, frontRightBlockPos) != false ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    private Boolean isBlockEmpty(BlockPlaceContext ctx, Level world, BlockPos blockPos) {
        return world.m_8055_(blockPos).m_60629_(ctx) && world.m_6857_().m_61937_(blockPos);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((QuadTablePart)((Object)pState.m_61143_(PART))) {
            default -> throw new IncompatibleClassChangeError();
            case QuadTablePart.BACKLEFT -> VoxelHelper.rotateShape(Direction.NORTH, ((Direction)pState.m_61143_((Property)f_54117_)).m_122427_(), this.SHAPE);
            case QuadTablePart.BACKRIGHT -> VoxelHelper.rotateShape(Direction.NORTH, ((Direction)pState.m_61143_((Property)f_54117_)).m_122424_(), this.SHAPE);
            case QuadTablePart.FRONTRIGHT -> VoxelHelper.rotateShape(Direction.NORTH, ((Direction)pState.m_61143_((Property)f_54117_)).m_122428_(), this.SHAPE);
            case QuadTablePart.FRONTLEFT -> VoxelHelper.rotateShape(Direction.NORTH, (Direction)pState.m_61143_((Property)f_54117_), this.SHAPE);
        };
    }

    public RenderShape m_7514_(BlockState pState) {
        return pState.m_61143_(PART) == QuadTablePart.FRONTLEFT ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, PART});
    }

    public long m_7799_(BlockState pState, BlockPos pPos) {
        BlockPos blockpos = pPos.m_5484_((Direction)pState.m_61143_((Property)f_54117_), pState.m_61143_(PART) == QuadTablePart.BACKLEFT ? 0 : 1);
        return Mth.m_14130_((int)blockpos.m_123341_(), (int)pPos.m_123342_(), (int)blockpos.m_123343_());
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

