/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostradar.network;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lostradar.data.ClientMapData;
import mcjty.lostradar.data.EntryPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;

public record PacketReturnSearchResultsToClient(Set<ChunkPos> positions, Set<EntryPos> searchedChunks, int progress) implements CustomPacketPayload
{
    public static ResourceLocation ID = new ResourceLocation("lostradar", "returnsearchresults");

    public static PacketReturnSearchResultsToClient create(FriendlyByteBuf buf) {
        List positions = buf.m_236845_(FriendlyByteBuf::m_178383_);
        List searchedChunks = buf.m_236845_(arg_0 -> EntryPos.STREAM_CODEC.decode(arg_0));
        return new PacketReturnSearchResultsToClient(new HashSet<ChunkPos>(positions), new HashSet<EntryPos>(searchedChunks), buf.readInt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_236828_(this.positions, FriendlyByteBuf::m_178341_);
        buf.m_236828_(this.searchedChunks, (arg_0, arg_1) -> EntryPos.STREAM_CODEC.encode(arg_0, arg_1));
        buf.writeInt(this.progress);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(player -> {
            ClientMapData clientMapData = ClientMapData.getData();
            clientMapData.addSearchResults(this.positions, this.searchedChunks);
            clientMapData.setSearchProgress(this.progress);
        }));
    }
}

