/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostradar.data;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lostradar.data.PlayerMapKnowledge;
import mcjty.lostradar.setup.ModSetup;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerMapKnowledgeDispatcher
implements ICapabilityProvider,
INBTSerializable<Tag> {
    private final PlayerMapKnowledge data = this.createProperties();
    private final LazyOptional<PlayerMapKnowledge> propertiesCap = LazyOptional.of(() -> this.data);

    public static LazyOptional<PlayerMapKnowledge> getPlayerMapKnowledge(Player player) {
        return player.getCapability(ModSetup.PLAYER_KNOWLEDGE);
    }

    private <T> PlayerMapKnowledge createProperties() {
        return new PlayerMapKnowledge();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == ModSetup.PLAYER_KNOWLEDGE) {
            return this.propertiesCap.cast();
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.getCapability(cap);
    }

    public Tag serializeNBT() {
        return this.data.saveNBTData();
    }

    public void deserializeNBT(Tag nbt) {
        this.data.loadNBTData(nbt);
    }
}

