/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostradar.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mcjty.lostcities.api.ILostChunkInfo;
import mcjty.lostcities.api.ILostCityInformation;
import mcjty.lostradar.compat.LostCitiesCompat;
import mcjty.lostradar.data.MapPalette;
import mcjty.lostradar.data.PaletteCache;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;

public class PlayerMapKnowledge {
    private final Set<String> knownCategories = new HashSet<String>();
    private static final Codec<Set<String>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.STRING).fieldOf("categories").forGetter(s -> new ArrayList(s))).apply((Applicative)instance, HashSet::new));
    private static final Component DEFAULT_NAME = Component.m_237113_((String)"@");
    private static final CommandSource EMPTY = new CommandSource(){

        public void m_213846_(Component component) {
        }

        public boolean m_6999_() {
            return false;
        }

        public boolean m_7028_() {
            return false;
        }

        public boolean m_6102_() {
            return false;
        }
    };

    public Set<String> getKnownCategories() {
        return this.knownCategories;
    }

    public Tag saveNBTData() {
        DataResult result = CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.knownCategories);
        return (Tag)result.result().orElseThrow(() -> new IllegalStateException("Failed to encode palette"));
    }

    public void loadNBTData(Tag tag) {
        CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag).resultOrPartial(error -> {
            throw new IllegalStateException("Failed to decode palette: " + error);
        }).ifPresent(palette -> {
            this.knownCategories.clear();
            this.knownCategories.addAll((Collection)palette.getFirst());
        });
    }

    public void copyFrom(PlayerMapKnowledge oldStore) {
        this.knownCategories.clear();
        this.knownCategories.addAll(oldStore.knownCategories);
    }

    public static void register(RegisterCapabilitiesEvent event) {
        event.register(PlayerMapKnowledge.class);
    }

    public void tick(ServerPlayer player) {
        ILostCityInformation lostInfo = LostCitiesCompat.lostCities.getLostInfo(player.m_9236_());
        if (lostInfo != null) {
            ChunkPos pos = player.m_146902_();
            ILostChunkInfo chunkInfo = lostInfo.getChunkInfo(pos.f_45578_, pos.f_45579_);
            if (chunkInfo != null) {
                MapPalette.PaletteEntry entry;
                PaletteCache cache = PaletteCache.getOrCreatePaletteCache(MapPalette.getDefaultPalette(player.m_9236_()));
                ResourceLocation buildingId = chunkInfo.getBuildingId();
                if (buildingId != null && (entry = cache.getEntryForBuilding(buildingId)) != null && this.knownCategories.add(entry.name()) && !entry.commands().isEmpty()) {
                    MinecraftServer server = player.f_8924_;
                    CommandSourceStack stack = new CommandSourceStack(EMPTY, Vec3.m_82512_((Vec3i)player.m_20183_()), Vec2.f_82462_, (ServerLevel)player.m_9236_(), 2, DEFAULT_NAME.getString(), DEFAULT_NAME, server, (Entity)player);
                    for (String command : entry.commands()) {
                        server.m_129892_().m_230957_(stack, command);
                    }
                }
            }
        }
    }

    public void clearKnowledge() {
        this.knownCategories.clear();
    }
}

