/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostradar.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lostradar.data.EntryPos;
import mcjty.lostradar.data.MapChunk;
import mcjty.lostradar.data.MapPalette;
import mcjty.lostradar.data.PaletteCache;
import mcjty.lostradar.network.Messages;
import mcjty.lostradar.network.PacketRequestMapChunk;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ClientMapData {
    private final Map<EntryPos, MapChunk> mapChunks = new HashMap<EntryPos, MapChunk>();
    private final Set<EntryPos> requestedChunks = new HashSet<EntryPos>();
    private final Set<ChunkPos> searchResults = new HashSet<ChunkPos>();
    private final Set<EntryPos> searchedChunks = new HashSet<EntryPos>();
    private static final ClientMapData INSTANCE = new ClientMapData();
    private String searchString = "";
    private int searchProgress = 100;
    private boolean paused = false;

    @Nonnull
    public static ClientMapData getData() {
        return INSTANCE;
    }

    private ClientMapData() {
    }

    public void cleanup() {
        this.mapChunks.clear();
        this.requestedChunks.clear();
        this.searchResults.clear();
        this.searchedChunks.clear();
        this.searchString = "";
        this.searchProgress = 100;
        this.paused = false;
    }

    public void clearSearchResults() {
        this.searchResults.clear();
        this.searchedChunks.clear();
        this.searchProgress = 100;
        this.paused = false;
    }

    public void setPauseState(boolean paused) {
        this.paused = paused;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setSearchProgress(int progress) {
        this.searchProgress = progress;
    }

    public int getSearchProgress() {
        return this.searchProgress;
    }

    public void addSearchResults(Set<ChunkPos> positions, Set<EntryPos> chunks) {
        this.searchResults.addAll(positions);
        this.searchedChunks.addAll(chunks);
        this.paused = false;
    }

    public Set<ChunkPos> getSearchResults() {
        return this.searchResults;
    }

    public Set<EntryPos> getSearchedChunks() {
        return this.searchedChunks;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public void addChunk(ResourceKey<Level> level, MapChunk chunk) {
        EntryPos entryPos = new EntryPos(level, chunk.chunkX(), chunk.chunkZ());
        this.requestedChunks.remove(entryPos);
        this.mapChunks.put(entryPos, chunk);
    }

    public int getBiomeColor(Level level, ChunkPos pos) {
        EntryPos entryPos = EntryPos.fromChunkPos((ResourceKey<Level>)level.m_46472_(), pos);
        MapChunk mapChunk = this.mapChunks.get(entryPos);
        if (mapChunk == null) {
            return -1;
        }
        return mapChunk.getBiomeColorAt(pos);
    }

    @Nullable
    public MapPalette.PaletteEntry getPaletteEntry(Level level, ChunkPos pos) {
        EntryPos entryPos = EntryPos.fromChunkPos((ResourceKey<Level>)level.m_46472_(), pos);
        MapChunk mapChunk = this.mapChunks.get(entryPos);
        if (mapChunk == null) {
            if (this.requestedChunks.contains(entryPos)) {
                return null;
            }
            Messages.sendToServer(new PacketRequestMapChunk(entryPos));
            this.requestedChunks.add(entryPos);
            return null;
        }
        int dataAt = mapChunk.getDataAt(pos);
        if (dataAt < 0) {
            return null;
        }
        PaletteCache palette = PaletteCache.getOrCreatePaletteCache(MapPalette.getDefaultPalette(level));
        return palette.getPalette().palette().get(dataAt);
    }
}

