/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostradar.data;

import com.mojang.serialization.Codec;
import mcjty.lib.varia.codec.StreamCodec;
import net.minecraft.network.FriendlyByteBuf;

public enum BiomeColorIndex {
    OCEAN(255),
    MOUNTAIN(9127187),
    DESERT(0xFFFF00),
    FOREST(25600),
    PLAINS(65280),
    OTHER(0x22EE22);

    public static final Codec<BiomeColorIndex> CODEC;
    public static final StreamCodec<FriendlyByteBuf, BiomeColorIndex[]> ARRAY_STREAM_CODEC;
    private final int color;

    private BiomeColorIndex(int color) {
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public static BiomeColorIndex fromOrdinal(int idx) {
        if (idx < 0 || idx >= BiomeColorIndex.values().length) {
            return OTHER;
        }
        return BiomeColorIndex.values()[idx];
    }

    static {
        CODEC = Codec.INT.xmap(BiomeColorIndex::fromOrdinal, Enum::ordinal);
        ARRAY_STREAM_CODEC = new StreamCodec<FriendlyByteBuf, BiomeColorIndex[]>(){

            public BiomeColorIndex[] decode(FriendlyByteBuf buffer) {
                int cnt = buffer.m_130242_();
                if (cnt <= 0) {
                    return new BiomeColorIndex[0];
                }
                BiomeColorIndex[] value = new BiomeColorIndex[cnt];
                for (int i = 0; i < cnt; ++i) {
                    value[i] = BiomeColorIndex.fromOrdinal(buffer.m_130242_());
                }
                return value;
            }

            public void encode(FriendlyByteBuf buffer, BiomeColorIndex[] value) {
                buffer.m_130130_(value.length);
                for (BiomeColorIndex v : value) {
                    buffer.m_130130_(v.ordinal());
                }
            }
        };
    }
}

