/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.infection.ImmuneEffect;
import net.smileycorp.hordes.infection.InfectedEffect;

public class HordesInfection {
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"hordes");
    public static final TagKey<EntityType<?>> INFECTION_ENTITIES_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)Constants.loc("infection_entities"));
    public static final TagKey<Item> INFECTION_CURES_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Constants.loc("infection_cures"));
    public static final RegistryObject<MobEffect> INFECTED = EFFECTS.register("infected", InfectedEffect::new);
    public static final RegistryObject<MobEffect> IMMUNITY = EFFECTS.register("immunity", ImmuneEffect::new);
    public static final ResourceKey<DamageType> INFECTION_DAMAGE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)Constants.loc("infection"));

    public static DamageSource getInfectionDamage(LivingEntity entity) {
        return entity.m_269291_().m_269079_(INFECTION_DAMAGE);
    }

    public static List<ItemStack> getCureList() {
        return ForgeRegistries.ITEMS.tags().getTag(INFECTION_CURES_TAG).stream().map(ItemStack::new).collect(Collectors.toList());
    }

    public static boolean isCure(ItemStack stack) {
        return stack.m_204117_(INFECTION_CURES_TAG);
    }

    public static boolean canCauseInfection(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        return entity.m_6095_().m_204039_(INFECTION_ENTITIES_TAG);
    }
}

