/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.data.DataRegistry;
import net.smileycorp.hordes.common.data.conditions.Condition;
import net.smileycorp.hordes.common.event.HordePlayerEvent;
import net.smileycorp.hordes.hordeevent.data.functions.FunctionRegistry;
import net.smileycorp.hordes.hordeevent.data.functions.HordeFunction;
import net.smileycorp.hordes.hordeevent.data.functions.MultipleFunction;

public class HordeScript<T extends HordePlayerEvent> {
    protected final HordeFunction<T> func;
    protected final Class<T> type;
    private final ResourceLocation name;
    private final Condition[] conditions;

    private HordeScript(HordeFunction<T> func, Class<T> type, ResourceLocation name, Condition ... conditions) {
        this.func = func;
        this.type = type;
        this.name = name;
        this.conditions = conditions;
    }

    public void apply(T event) {
        this.func.apply(event);
    }

    public Class<T> getType() {
        return this.type;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public boolean shouldApply(Level level, LivingEntity entity, ServerPlayer player, RandomSource rand) {
        for (Condition condition : this.conditions) {
            if (condition.apply(level, entity, player, rand)) continue;
            return false;
        }
        return true;
    }

    public int sort(HordeScript other) {
        String a = this.name.toString();
        String b = other.name.toString();
        int ia = 0;
        int ib = 0;
        while (true) {
            int result;
            int nzb = 0;
            int nza = 0;
            char ca = this.charAt(a, ia);
            char cb = this.charAt(b, ib);
            while (ca == '0') {
                nza = ca == '0' ? ++nza : 0;
                if (!Character.isDigit(this.charAt(a, ia + 1))) break;
                ca = this.charAt(a, ia++);
            }
            while (cb == '0') {
                nzb = cb == '0' ? ++nzb : 0;
                if (!Character.isDigit(this.charAt(b, ib + 1))) break;
                cb = this.charAt(b, ib++);
            }
            if (Character.isDigit(ca) && Character.isDigit(cb) && (result = this.compareRight(a.substring(ia), b.substring(ib))) != 0) {
                return result;
            }
            if (ca == '\u0000' && cb == '\u0000') {
                return nza - nzb;
            }
            if (ca < cb) {
                return -1;
            }
            if (ca > cb) {
                return 1;
            }
            ++ia;
            ++ib;
        }
    }

    private char charAt(String s, int i) {
        return i >= s.length() ? (char)'\u0000' : Character.toUpperCase(s.charAt(i));
    }

    private int compareRight(String a, String b) {
        int bias = 0;
        int ia = 0;
        int ib = 0;
        while (true) {
            char ca = this.charAt(a, ia);
            char cb = this.charAt(b, ib);
            if (!Character.isDigit(ca) && !Character.isDigit(cb)) {
                return bias;
            }
            if (!Character.isDigit(ca)) {
                return -1;
            }
            if (!Character.isDigit(cb)) {
                return 1;
            }
            if (ca < cb) {
                if (bias == 0) {
                    bias = -1;
                } else if (ca > cb) {
                    if (bias == 0) {
                        bias = 1;
                    } else if (ca == '\u0000' && cb == '\u0000') {
                        return bias;
                    }
                }
            }
            ++ia;
            ++ib;
        }
    }

    public static HordeScript deserialize(ResourceLocation key, JsonElement json) {
        try {
            if (json instanceof JsonArray) {
                Pair pair = MultipleFunction.deserialize(json.getAsJsonArray());
                return new HordeScript((HordeFunction)pair.getSecond(), (Class)pair.getFirst(), key, new Condition[0]);
            }
            JsonObject obj = json.getAsJsonObject();
            Pair pair = FunctionRegistry.readFunction(obj);
            Class clazz = (Class)pair.getFirst();
            HordeFunction function = (HordeFunction)pair.getSecond();
            if (function == null || clazz == null) {
                throw new Exception("invalid function: " + obj.get("function").getAsString());
            }
            ArrayList conditions = Lists.newArrayList();
            if (obj.has("conditions")) {
                obj.get("conditions").getAsJsonArray().forEach(condition -> conditions.add(DataRegistry.readCondition(condition.getAsJsonObject())));
            }
            return new HordeScript(function, clazz, key, conditions.toArray(new Condition[0]));
        }
        catch (Exception e) {
            HordesLogger.logError("Error loading script " + key + " " + e.getCause() + " " + e.getMessage(), e);
            return null;
        }
    }
}

