/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.capability;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.network.AbstractMessage;
import net.smileycorp.atlas.api.network.GenericStringMessage;
import net.smileycorp.atlas.api.util.DirectionUtils;
import net.smileycorp.atlas.api.util.WeightedOutputs;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.ai.HordeTrackPlayerGoal;
import net.smileycorp.hordes.common.capability.HordesCapabilities;
import net.smileycorp.hordes.common.event.HordeBuildSpawnDataEvent;
import net.smileycorp.hordes.common.event.HordeEndEvent;
import net.smileycorp.hordes.common.event.HordeFindSpawnPosEvent;
import net.smileycorp.hordes.common.event.HordePlayerEvent;
import net.smileycorp.hordes.common.event.HordeSpawnEntityEvent;
import net.smileycorp.hordes.common.event.HordeStartEvent;
import net.smileycorp.hordes.common.event.HordeStartWaveEvent;
import net.smileycorp.hordes.config.HordeEventConfig;
import net.smileycorp.hordes.hordeevent.HordeSpawnData;
import net.smileycorp.hordes.hordeevent.HordeSpawnEntry;
import net.smileycorp.hordes.hordeevent.HordeSpawnTable;
import net.smileycorp.hordes.hordeevent.capability.HordeSavedData;
import net.smileycorp.hordes.hordeevent.capability.HordeSpawn;
import net.smileycorp.hordes.hordeevent.data.HordeScriptLoader;
import net.smileycorp.hordes.hordeevent.data.HordeTableLoader;
import net.smileycorp.hordes.hordeevent.network.HordeEventPacketHandler;
import net.smileycorp.hordes.hordeevent.network.HordeSoundMessage;
import net.smileycorp.hordes.hordeevent.network.UpdateClientHordeMessage;

public class HordeEvent {
    private final HordeSavedData data;
    private static UUID FOLLOW_RANGE_MODIFIER = UUID.fromString("51cfe045-4248-409e-be37-556d67de4b97");
    private RandomSource rand;
    private Set<Mob> entitiesSpawned = new HashSet<Mob>();
    private int timer = 0;
    private int day = 0;
    private int nextDay = -1;
    private HordeSpawnData spawnData = null;
    int sentDay = 0;
    private String username;

    HordeEvent(HordeSavedData data) {
        this.data = data;
        this.nextDay = ((Boolean)HordeEventConfig.hordeEventByPlayerTime.get()).booleanValue() ? (((Boolean)HordeEventConfig.spawnFirstDay.get()).booleanValue() ? 0 : (Integer)HordeEventConfig.hordeSpawnDays.get()) : data.getNextDay();
    }

    public void readFromNBT(CompoundTag nbt) {
        this.entitiesSpawned.clear();
        if (nbt.m_128441_("timer")) {
            this.timer = nbt.m_128451_("timer");
        }
        if (nbt.m_128441_("nextDay")) {
            this.nextDay = nbt.m_128451_("nextDay");
        }
        if (nbt.m_128441_("day")) {
            this.day = nbt.m_128451_("day");
        }
        if (nbt.m_128441_("spawnData")) {
            this.spawnData = new HordeSpawnData(this, nbt.m_128469_("spawnData"));
        }
        if (nbt.m_128441_("loadedTable")) {
            this.spawnData = new HordeSpawnData(this);
            this.spawnData.setTable(HordeTableLoader.INSTANCE.getTable(new ResourceLocation(nbt.m_128461_("loadedTable"))));
        }
    }

    public CompoundTag writeToNBT(CompoundTag nbt, UUID uuid) {
        ServerPlayer player;
        nbt.m_128405_("timer", this.timer);
        nbt.m_128405_("nextDay", this.nextDay);
        nbt.m_128405_("day", this.day);
        if (this.spawnData != null) {
            nbt.m_128365_("spawnData", (Tag)this.spawnData.save());
        }
        nbt.m_128359_("username", (player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid)) == null ? (this.username == null ? uuid.toString() : this.username) : player.m_7755_().getString());
        return nbt;
    }

    public void update(ServerPlayer player) {
        Level level = player.m_9236_();
        if (level.m_46472_() != Level.f_46428_) {
            return;
        }
        if (this.spawnData == null) {
            return;
        }
        if (this.timer % this.spawnData.getSpawnInterval() == 0) {
            this.spawnWave(player, this.getMobCount(player, level));
        }
        --this.timer;
        if (this.timer == 0) {
            this.stopEvent(player, false);
        }
    }

    private int getMobCount(ServerPlayer player, Level level) {
        int amount = this.spawnData.getSpawnAmount();
        List players = level.m_6907_();
        for (Player other : players) {
            if (!this.shouldReduce(player, (ServerPlayer)other)) continue;
            amount = (int)Math.floor((double)amount * (Double)HordeEventConfig.hordeMultiplayerScaling.get());
        }
        return amount;
    }

    private boolean shouldReduce(ServerPlayer player, ServerPlayer other) {
        if (other == player || player.m_20270_((Entity)other) > 25.0f) {
            return false;
        }
        HordeEvent horde = this.data.getEvent(other);
        return horde != null && horde.isActive(other);
    }

    public void spawnWave(ServerPlayer player, int count) {
        WeightedOutputs<HordeSpawnEntry> spawntable;
        RandomSource rand = this.getRandom();
        this.cleanSpawns();
        if (this.spawnData == null) {
            HordeBuildSpawnDataEvent buildTableEvent = new HordeBuildSpawnDataEvent(player, this);
            this.postEvent(buildTableEvent);
            this.spawnData = buildTableEvent.getSpawnData();
        }
        if (this.spawnData == null || this.spawnData.getTable() == null) {
            this.logError("Cannot load wave spawn data, cancelling spawns.", new Exception());
            return;
        }
        ServerLevel level = player.m_284548_();
        HordeStartWaveEvent startEvent = new HordeStartWaveEvent(player, this, count);
        this.postEvent(startEvent);
        if (startEvent.isCanceled()) {
            return;
        }
        count = startEvent.getCount();
        Vec3 basedir = DirectionUtils.getRandomDirectionVecXZ((RandomSource)rand);
        BlockPos basepos = this.getBasePos(level, basedir, player, true);
        int i = 0;
        while (basepos.equals((Object)player.m_20183_())) {
            basedir = DirectionUtils.getRandomDirectionVecXZ((RandomSource)rand);
            basepos = this.getBasePos(level, basedir, player, true);
            if (!this.spawnData.getSpawnType().canSpawn(level, basepos)) {
                basepos = player.m_20183_();
            }
            if (i++ < (Integer)HordeEventConfig.hordeSpawnChecks.get()) continue;
            this.logInfo("Unable to find unlit pos for horde " + this + " ignoring light level");
            basedir = DirectionUtils.getRandomDirectionVecXZ((RandomSource)rand);
            basepos = this.getBasePos(level, basedir, player, false);
            break;
        }
        if ((spawntable = this.spawnData.getTable().getSpawnTable(this.day)).isEmpty()) {
            this.logInfo("Spawntable is empty, stopping wave spawn.");
            return;
        }
        if (count <= 0) {
            this.logInfo("Stopping wave spawn because count is " + count);
            return;
        }
        HordeEventPacketHandler.sendTo(new HordeSoundMessage(basedir, this.spawnData.getSpawnSound()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        for (HordeSpawnEntry entry : spawntable.getResults(rand, count)) {
            if (this.entitiesSpawned.size() > (Integer)HordeEventConfig.hordeSpawnMax.get()) {
                this.logInfo("Can't spawn wave because max cap has been reached");
                return;
            }
            Vec3 pos = this.getSpawnPos(level, basepos.m_252807_());
            EntityType<?> type = entry.getEntity();
            try {
                AtomicBoolean cancelled = new AtomicBoolean(false);
                CompoundTag nbt = entry.getNBT();
                nbt.m_128359_("id", entry.getName().toString());
                Mob newEntity = (Mob)EntityType.m_20645_((CompoundTag)nbt, (Level)level, entity -> this.loadEntity(level, player, (Mob)entity, pos, cancelled));
                if (cancelled.get()) continue;
                newEntity.m_7378_(entry.getNBT());
                if (!level.m_8860_((Entity)newEntity)) {
                    this.logError("Unable to spawn entity from " + type, new Exception());
                    continue;
                }
                this.finalizeEntity(newEntity, player);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logError("Unable to spawn entity from " + type, e);
            }
        }
    }

    private BlockPos getBasePos(ServerLevel level, Vec3 basedir, ServerPlayer player, boolean checkLight) {
        double radius = (Double)HordeEventConfig.hordeSpawnDistance.get();
        BlockPos basepos = checkLight ? DirectionUtils.getClosestLoadedPos((Level)level, (BlockPos)player.m_20183_(), (Vec3)basedir, (double)radius, (int)7, (int)0) : DirectionUtils.getClosestLoadedPos((Level)level, (BlockPos)player.m_20183_(), (Vec3)basedir, (double)radius);
        HordeFindSpawnPosEvent event = new HordeFindSpawnPosEvent(player, this, basedir, basepos, checkLight);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getPos();
    }

    private Vec3 getSpawnPos(ServerLevel level, Vec3 basepos) {
        for (int j = 0; j < 5; ++j) {
            double x = basepos.m_7096_() + (double)this.rand.m_188503_(10);
            double z = basepos.m_7094_() + (double)this.rand.m_188503_(10);
            Vec3 pos = new Vec3(x, (double)level.m_6924_(Heightmap.Types.MOTION_BLOCKING, (int)x, (int)z), z);
            if (!this.spawnData.getSpawnType().canSpawn(level, BlockPos.m_274446_((Position)pos))) continue;
            return pos;
        }
        return basepos;
    }

    private Entity loadEntity(ServerLevel level, ServerPlayer player, Mob entity, Vec3 pos, AtomicBoolean cancel) {
        HordeSpawnEntityEvent spawnEntityEvent = new HordeSpawnEntityEvent(player, entity, pos, this);
        this.postEvent(spawnEntityEvent);
        if (!spawnEntityEvent.isCanceled()) {
            entity = spawnEntityEvent.getEntity();
            pos = spawnEntityEvent.getPos();
            entity.m_6518_((ServerLevelAccessor)level, level.m_6436_(BlockPos.m_274446_((Position)pos)), null, null, null);
            entity.m_6034_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
            return entity;
        }
        this.logInfo("Entity spawn event has been cancelled, not spawning entity  of class " + entity.m_6095_());
        cancel.set(true);
        return entity;
    }

    private void finalizeEntity(Mob entity, ServerPlayer player) {
        entity.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier(FOLLOW_RANGE_MODIFIER, "hordes:horde_range", 75.0, AttributeModifier.Operation.ADDITION));
        LazyOptional optional = entity.getCapability(HordesCapabilities.HORDESPAWN);
        if (optional.isPresent()) {
            ((HordeSpawn)optional.orElseGet(null)).setPlayerUUID(player.m_20148_().toString());
            this.registerEntity(entity, player);
        }
        entity.f_21346_.m_25386_().forEach(WrappedGoal::m_8041_);
        if (entity instanceof PathfinderMob) {
            entity.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)entity, new Class[0]));
        }
        entity.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal(entity, ServerPlayer.class, true));
        for (Entity passenger : entity.m_20197_()) {
            if (!(passenger instanceof Mob)) continue;
            this.finalizeEntity((Mob)passenger, player);
        }
    }

    private void cleanSpawns() {
        ArrayList<Mob> toRemove = new ArrayList<Mob>();
        for (Mob entity : this.entitiesSpawned) {
            LazyOptional optional;
            if (entity.m_6084_() | !entity.m_213877_() || !(optional = entity.getCapability(HordesCapabilities.HORDESPAWN, null)).isPresent()) continue;
            HordeSpawn cap = (HordeSpawn)optional.orElseGet(null);
            cap.setPlayerUUID("");
            toRemove.add(entity);
        }
        this.entitiesSpawned.removeAll(toRemove);
    }

    public boolean isHordeDay(ServerPlayer player) {
        ServerLevel level = player.m_284548_();
        if (level.m_46472_() != Level.f_46428_) {
            return false;
        }
        return this.isActive(player) || this.getCurrentDay(player) >= this.nextDay;
    }

    public boolean isActive(ServerPlayer player) {
        return this.timer > 0;
    }

    public void setPlayer(ServerPlayer player) {
        this.setNextDay(player);
        this.cleanSpawns();
        this.entitiesSpawned.forEach(entity -> this.fixGoals(player, (Mob)entity));
    }

    private void fixGoals(ServerPlayer player, Mob entity) {
        for (WrappedGoal entry : (WrappedGoal[])entity.f_21345_.m_25386_().toArray(WrappedGoal[]::new)) {
            if (!(entry.m_26015_() instanceof HordeTrackPlayerGoal)) continue;
            entity.f_21345_.m_25363_(entry.m_26015_());
            entity.f_21345_.m_25352_(6, (Goal)new HordeTrackPlayerGoal(entity, (Entity)player, this.spawnData.getEntitySpeed()));
            return;
        }
    }

    public void tryStartEvent(ServerPlayer player, int duration, boolean isCommand) {
        this.rand = this.data.getRandom(this.day);
        this.cleanSpawns();
        if ((Boolean)HordeEventConfig.hordesCommandOnly.get() & !isCommand) {
            return;
        }
        if (!isCommand) {
            this.logInfo("Trying to start horde event on day " + this.getCurrentDay(player) + " with nextDay " + this.nextDay + " and time " + player.m_9236_().m_46468_() % (long)((Integer)HordeEventConfig.dayLength.get()).intValue());
        }
        if (player == null) {
            this.logError("player is null for " + this, new NullPointerException());
            return;
        }
        ServerLevel level = player.m_284548_();
        if (level.m_46472_() != Level.f_46428_) {
            return;
        }
        HordeStartEvent startEvent = new HordeStartEvent(player, this, isCommand);
        this.postEvent(startEvent);
        if (startEvent.isCanceled()) {
            this.spawnData = null;
            return;
        }
        if (this.spawnData == null) {
            HordeBuildSpawnDataEvent event = new HordeBuildSpawnDataEvent(player, this);
            this.postEvent(event);
            this.spawnData = event.getSpawnData();
        }
        if (this.spawnData == null || this.spawnData.getTable() == null || this.spawnData.getTable().getSpawnTable(this.day).isEmpty()) {
            this.spawnData = null;
            this.logInfo("Spawntable is empty, canceling event start.");
        } else {
            this.timer = duration <= 0 ? this.spawnData.getSpawnDuration() : duration;
            this.sendMessage(player, this.spawnData.getStartMessage());
            this.day = isCommand ? this.getCurrentDay(player) : this.nextDay;
        }
        if (!isCommand) {
            this.setNextDay(player);
        }
    }

    public void setSpawntable(HordeSpawnTable table) {
        if (table == null || table == HordeTableLoader.INSTANCE.getFallbackTable()) {
            this.spawnData = null;
            return;
        }
        if (this.spawnData == null) {
            this.spawnData = new HordeSpawnData(this);
        }
        this.spawnData.setTable(table);
    }

    public HordeSpawnTable getSpawntable() {
        return this.spawnData == null ? null : this.spawnData.getTable();
    }

    public void setNextDay(int day) {
        this.nextDay = day;
    }

    public int getNextDay() {
        return this.nextDay;
    }

    private void sendMessage(ServerPlayer player, String str) {
        HordeEventPacketHandler.sendTo((AbstractMessage)new GenericStringMessage(str), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void stopEvent(ServerPlayer player, boolean isCommand) {
        this.entitiesSpawned.clear();
        HordeEndEvent endEvent = new HordeEndEvent(player, this, isCommand, this.spawnData.getEndMessage());
        this.postEvent(endEvent);
        HordeEventPacketHandler.sendTo(new UpdateClientHordeMessage(false), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        this.sentDay = this.getCurrentDay(player);
        this.timer = 0;
        this.spawnData = null;
        this.sendMessage(player, endEvent.getMessage());
        for (Mob entity : this.entitiesSpawned) {
            LazyOptional cap;
            for (WrappedGoal entry : (WrappedGoal[])entity.f_21345_.m_25386_().toArray(WrappedGoal[]::new)) {
                if (!(entry.m_26015_() instanceof HordeTrackPlayerGoal)) continue;
                entity.f_21345_.m_25363_(entry.m_26015_());
                break;
            }
            if (!(cap = entity.getCapability(HordesCapabilities.HORDESPAWN)).isPresent()) continue;
            ((HordeSpawn)cap.orElseGet(null)).setPlayerUUID("");
            entity.m_21051_(Attributes.f_22277_).m_22120_(FOLLOW_RANGE_MODIFIER);
        }
        this.rand = null;
    }

    public void removeEntity(Mob entity) {
        this.entitiesSpawned.remove(entity);
    }

    public void registerEntity(Mob entity, ServerPlayer player) {
        if (!this.isActive(player) || this.spawnData == null) {
            LazyOptional optional = entity.getCapability(HordesCapabilities.HORDESPAWN);
            if (optional.isPresent()) {
                ((HordeSpawn)optional.orElseGet(null)).setPlayerUUID("");
            }
            return;
        }
        if (!this.entitiesSpawned.contains(entity)) {
            this.entitiesSpawned.add(entity);
        }
        entity.f_21345_.m_25352_(6, (Goal)new HordeTrackPlayerGoal(entity, (Entity)player, this.spawnData.getEntitySpeed()));
    }

    private void postEvent(HordePlayerEvent event) {
        HordeScriptLoader.INSTANCE.applyScripts(event);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public void reset(ServerPlayer player) {
        this.entitiesSpawned.clear();
        this.setNextDay(player);
        this.spawnData = null;
        this.timer = 0;
    }

    private void setNextDay(ServerPlayer player) {
        if (!((Boolean)HordeEventConfig.hordeEventByPlayerTime.get()).booleanValue()) {
            this.nextDay = this.data.getNextDay();
            return;
        }
        int expectedDay = (Integer)HordeEventConfig.hordeSpawnDays.get() * (this.getCurrentDay(player) / (Integer)HordeEventConfig.hordeSpawnDays.get() + 1);
        if (this.nextDay <= this.getCurrentDay(player) || Math.abs(this.nextDay - expectedDay) > (Integer)HordeEventConfig.hordeSpawnDays.get() + (Integer)HordeEventConfig.hordeSpawnVariation.get()) {
            if ((Integer)HordeEventConfig.hordeSpawnVariation.get() > 0) {
                expectedDay += this.getRandom().m_188503_(((Integer)HordeEventConfig.hordeSpawnVariation.get()).intValue());
            }
            this.nextDay = expectedDay;
        }
    }

    public boolean hasSynced(int day) {
        return this.sentDay >= day;
    }

    public void sync(ServerPlayer player, int day) {
        HordeEventPacketHandler.sendTo(new UpdateClientHordeMessage(this.isHordeDay(player)), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        this.sentDay = day;
    }

    public int getDay() {
        return this.day;
    }

    public int getCurrentDay(ServerPlayer player) {
        return (int)Math.floor(((Boolean)HordeEventConfig.hordeEventByPlayerTime.get() != false ? (long)player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_144255_)) : player.m_9236_().m_46468_()) / (long)((Integer)HordeEventConfig.dayLength.get()).intValue());
    }

    private void logInfo(Object message) {
        HordesLogger.logInfo("[" + this + "]" + message);
    }

    private void logError(Object message, Exception e) {
        HordesLogger.logError("[" + this + "]" + message, e);
    }

    public String toString(String player) {
        return "OngoingHordeEvent@" + Integer.toHexString(this.hashCode()) + "[player = " + (player == null ? "null" : player) + ", isActive = " + (this.timer > 0) + ", ticksLeft=" + this.timer + ", entityCount=" + this.entitiesSpawned.size() + ", nextDay=" + this.nextDay + ", day=" + this.day + "]";
    }

    public List<String> getEntityStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\tentities: {" + (this.entitiesSpawned.isEmpty() ? "}" : ""));
        ArrayList<Mob> entitylist = new ArrayList<Mob>(this.entitiesSpawned);
        for (int i = 0; i < entitylist.size(); i += 10) {
            List sublist = entitylist.subList(i, Math.min(i + 9, entitylist.size() - 1));
            StringBuilder builder = new StringBuilder();
            builder.append("\t\t");
            for (Mob entity : sublist) {
                builder.append(entity.getClass().getSimpleName() + "@");
                builder.append(Integer.toHexString(entity.hashCode()));
                if (entitylist.indexOf(entity) >= entitylist.size() - 1) continue;
                builder.append(", ");
            }
            builder.append("}");
            result.add(builder.toString());
        }
        return result;
    }

    public RandomSource getRandom() {
        if (this.rand == null) {
            this.rand = this.data.getRandom(this.day);
        }
        return this.rand;
    }
}

