/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.data.conditions;

import com.google.gson.JsonElement;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.data.conditions.Condition;
import net.smileycorp.hordes.common.data.values.ValueGetter;
import net.smileycorp.hordes.config.HordeEventConfig;

public class PlayerDayCondition
implements Condition {
    protected ValueGetter<Integer> day;

    public PlayerDayCondition(ValueGetter<Integer> day) {
        this.day = day;
    }

    @Override
    public boolean apply(Level level, LivingEntity entity, ServerPlayer player, RandomSource rand) {
        return (float)player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_144255_)) / (float)((Integer)HordeEventConfig.dayLength.get()).intValue() > (float)this.day.get(level, entity, player, rand).intValue();
    }

    public static PlayerDayCondition deserialize(JsonElement json) {
        try {
            return new PlayerDayCondition(ValueGetter.readValue(DataType.INT, json));
        }
        catch (Exception e) {
            HordesLogger.logError("Incorrect parameters for condition hordes:player_day", e);
            return null;
        }
    }
}

