/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.data.conditions;

import com.google.gson.JsonElement;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.data.conditions.Condition;
import net.smileycorp.hordes.common.data.values.ValueGetter;

public class LocalDifficultyCondition
implements Condition {
    protected ValueGetter<Double> difficulty;

    public LocalDifficultyCondition(ValueGetter<Double> difficulty) {
        this.difficulty = difficulty;
    }

    @Override
    public boolean apply(Level level, LivingEntity entity, ServerPlayer player, RandomSource rand) {
        return (double)level.m_6436_(player.m_20183_()).m_19057_() > this.difficulty.get(level, entity, player, rand);
    }

    public static LocalDifficultyCondition deserialize(JsonElement json) {
        try {
            return new LocalDifficultyCondition(ValueGetter.readValue(DataType.DOUBLE, json));
        }
        catch (Exception e) {
            HordesLogger.logError("Incorrect parameters for condition hordes:local_difficulty", e);
            return null;
        }
    }
}

