/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.smileycorp.atlas.api.data.BinaryOperation;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.atlas.api.data.LogicalOperation;
import net.smileycorp.atlas.api.data.UnaryOperation;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.data.conditions.AdvancementCondition;
import net.smileycorp.hordes.common.data.conditions.BiomeCondition;
import net.smileycorp.hordes.common.data.conditions.ComparisonCondition;
import net.smileycorp.hordes.common.data.conditions.Condition;
import net.smileycorp.hordes.common.data.conditions.DayCondition;
import net.smileycorp.hordes.common.data.conditions.EntityTypeCondition;
import net.smileycorp.hordes.common.data.conditions.GameDifficultyCondition;
import net.smileycorp.hordes.common.data.conditions.GameStagesCondition;
import net.smileycorp.hordes.common.data.conditions.LocalDifficultyCondition;
import net.smileycorp.hordes.common.data.conditions.LogicalCondition;
import net.smileycorp.hordes.common.data.conditions.NotCondition;
import net.smileycorp.hordes.common.data.conditions.PlayerDayCondition;
import net.smileycorp.hordes.common.data.conditions.RandomCondition;
import net.smileycorp.hordes.common.data.values.BinaryOperationValueGetter;
import net.smileycorp.hordes.common.data.values.EntityNBTGetter;
import net.smileycorp.hordes.common.data.values.EntityPosGetter;
import net.smileycorp.hordes.common.data.values.LevelNBTGetter;
import net.smileycorp.hordes.common.data.values.PlayerNBTGetter;
import net.smileycorp.hordes.common.data.values.PlayerPosGetter;
import net.smileycorp.hordes.common.data.values.UnaryOperationValueGetter;
import net.smileycorp.hordes.common.data.values.ValueGetter;
import net.smileycorp.hordes.common.data.values.WeightedRandomValueGetter;
import net.smileycorp.hordes.config.HordeEventConfig;
import net.smileycorp.hordes.hordeevent.data.functions.FunctionRegistry;

public class DataRegistry {
    private static Map<ResourceLocation, BiFunction<JsonObject, DataType, ValueGetter>> VALUE_GETTERS = Maps.newHashMap();
    private static Map<ResourceLocation, Function<JsonElement, Condition>> CONDITION_DESERIALIZERS = Maps.newHashMap();

    public static void init() {
        DataRegistry.registerValueGetters();
        DataRegistry.registerConditionDeserializers();
        if (((Boolean)HordeEventConfig.enableHordeEvent.get()).booleanValue()) {
            FunctionRegistry.registerFunctionSerializers();
        }
    }

    private static void registerValueGetters() {
        UnaryOperation.values().forEach(operation -> DataRegistry.registerValueGetter(Constants.loc(operation.getName()), (obj, type) -> UnaryOperationValueGetter.deserialize(operation, type, obj)));
        BinaryOperation.values().forEach(operation -> DataRegistry.registerValueGetter(Constants.loc(operation.getName()), (obj, type) -> BinaryOperationValueGetter.deserialize(operation, type, obj)));
        DataRegistry.registerValueGetter(Constants.loc("weighted_random"), WeightedRandomValueGetter::deserialize);
        DataRegistry.registerValueGetter(Constants.loc("level_nbt"), LevelNBTGetter::deserialize);
        DataRegistry.registerValueGetter(Constants.loc("player_nbt"), PlayerNBTGetter::deserialize);
        DataRegistry.registerValueGetter(Constants.loc("player_pos"), PlayerPosGetter::deserialize);
        DataRegistry.registerValueGetter(Constants.loc("entity_nbt"), EntityNBTGetter::deserialize);
        DataRegistry.registerValueGetter(Constants.loc("entity_pos"), EntityPosGetter::deserialize);
    }

    public static void registerConditionDeserializers() {
        for (LogicalOperation operation : LogicalOperation.values()) {
            DataRegistry.registerConditionDeserializer(Constants.loc(operation.getName()), e -> LogicalCondition.deserialize(operation, e));
        }
        DataRegistry.registerConditionDeserializer(Constants.loc("not"), NotCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("comparison"), ComparisonCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("random"), RandomCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("biome"), BiomeCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("day"), DayCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("player_day"), PlayerDayCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("local_difficulty"), LocalDifficultyCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("game_difficulty"), GameDifficultyCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("advancement"), AdvancementCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("entity_type"), EntityTypeCondition::deserialize);
        if (ModList.get().isLoaded("gamestages")) {
            DataRegistry.registerConditionDeserializer(new ResourceLocation("gamestages:gamestage"), GameStagesCondition::deserialize);
        }
    }

    public static ValueGetter readValue(DataType type, JsonObject json) {
        if (json.has("name") && json.has("value")) {
            try {
                ResourceLocation loc = new ResourceLocation(json.get("name").getAsString());
                BiFunction<JsonObject, DataType, ValueGetter> getter = VALUE_GETTERS.get(loc);
                if (getter == null) {
                    throw new NullPointerException("value getter " + loc + " is not registered");
                }
                return getter.apply(json, type);
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to read value " + json, e);
            }
        }
        return null;
    }

    public static Condition readCondition(JsonObject json) {
        if (json.has("name") && json.has("value")) {
            try {
                ResourceLocation loc = new ResourceLocation(json.get("name").getAsString());
                Function<JsonElement, Condition> deserializer = CONDITION_DESERIALIZERS.get(loc);
                if (deserializer == null) {
                    throw new NullPointerException("condition " + loc + " is not registered");
                }
                return deserializer.apply(json.get("value"));
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to read condition " + json, e);
            }
        }
        return null;
    }

    public static void registerValueGetter(ResourceLocation name, BiFunction<JsonObject, DataType, ValueGetter> getter) {
        VALUE_GETTERS.put(name, getter);
    }

    public static void registerConditionDeserializer(ResourceLocation name, Function<JsonElement, Condition> serializer) {
        CONDITION_DESERIALIZERS.put(name, serializer);
    }

    public static CompoundTag parseNBT(String name, String nbtstring) {
        CompoundTag nbt = null;
        try {
            CompoundTag parsed = TagParser.m_129359_((String)nbtstring);
            if (parsed == null) {
                throw new NullPointerException("Parsed NBT is null.");
            }
            nbt = parsed;
        }
        catch (Exception e) {
            HordesLogger.logError("Failed to read config, " + e.getCause() + " " + e.getMessage(), e);
            HordesLogger.logError("Error parsing nbt for entity " + name + " " + e.getMessage(), e);
        }
        return nbt;
    }
}

