/*
 * Decompiled with CFR 0.152.
 */
package com.delta.redeco.block.entity.custom;

import com.delta.redeco.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class CrateBlockEntity
extends BlockEntity {
    private static final int INVENTORY_SLOT_COUNT = 4;
    private final ItemStackHandler inventory = this.createHandler();

    public CrateBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CRATE_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        } else {
            this.inventory.deserializeNBT(compound);
        }
    }

    public void m_183515_(CompoundTag compound) {
        this.writeItems(compound);
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    public int getNextEmptySlot() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (!slotStack.m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public int getNextFullSlot() {
        int slot = this.getNextEmptySlot() - 1;
        if (slot < 0) {
            slot = 0;
        }
        return slot;
    }

    public boolean addItem(ItemStack itemStackIn, int slot) {
        ItemStack slotStack;
        if (0 <= slot && slot < this.inventory.getSlots() && (slotStack = this.inventory.getStackInSlot(slot)).m_41619_()) {
            this.inventory.setStackInSlot(slot, itemStackIn.m_41777_());
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty(0)) {
            ItemStack item = this.getStoredItem();
            this.inventory.setSize(item.m_41741_());
            this.inventoryChanged();
            return item;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty(int slot) {
        return this.inventory.getStackInSlot(slot).m_41619_();
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    protected void inventoryChanged() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(4){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

