/*
 * Decompiled with CFR 0.152.
 */
package com.delta.redeco.block.custom;

import com.delta.redeco.block.custom.VoxelShapeHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TableBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public TableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape TABLE_TOP = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape LEG_NORTH_EAST = Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)13.0, (double)4.0);
        VoxelShape LEG_SOUTH_EAST = Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)13.0, (double)15.0);
        VoxelShape LEG_NORTH_WEST = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)13.0, (double)4.0);
        VoxelShape LEG_SOUTH_WEST = Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)13.0, (double)15.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            boolean north = (Boolean)state.m_61143_((Property)NORTH);
            boolean east = (Boolean)state.m_61143_((Property)EAST);
            boolean south = (Boolean)state.m_61143_((Property)SOUTH);
            boolean west = (Boolean)state.m_61143_((Property)WEST);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(TABLE_TOP);
            if (!north && !west) {
                shapes.add(LEG_NORTH_WEST);
            }
            if (!north && !east) {
                shapes.add(LEG_NORTH_EAST);
            }
            if (!south && !west) {
                shapes.add(LEG_SOUTH_WEST);
            }
            if (!south && !east) {
                shapes.add(LEG_SOUTH_EAST);
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        boolean north = this.isTable(level, pos, Direction.NORTH);
        boolean east = this.isTable(level, pos, Direction.EAST);
        boolean south = this.isTable(level, pos, Direction.SOUTH);
        boolean west = this.isTable(level, pos, Direction.WEST);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    private boolean isTable(LevelAccessor level, BlockPos source, Direction direction) {
        BlockState state = level.m_8055_(source.m_121945_(direction));
        return state.m_60734_() == this;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidState = pContext.m_43725_().m_6425_(pContext.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }
}

