/*
 * Decompiled with CFR 0.152.
 */
package com.delta.redeco.block.custom;

import com.delta.redeco.item.ModItems;
import com.delta.redeco.tags.ModTags;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;

public class StoneLanternBlock
extends Block
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)2.0, (double)0.0, (double)11.0, (double)5.0, (double)1.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)5.0, (double)1.0, (double)5.0), Block.m_49796_((double)11.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)5.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)14.0, (double)1.0, (double)14.0), Block.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_LEGLESS = Stream.of(Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static IntegerProperty MOSSING = IntegerProperty.m_61631_((String)"mossing", (int)0, (int)3);
    public static IntegerProperty WAXED = IntegerProperty.m_61631_((String)"waxed", (int)0, (int)1);
    public static IntegerProperty LEGS = IntegerProperty.m_61631_((String)"legs", (int)0, (int)1);

    public StoneLanternBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)super.m_49966_().m_61124_((Property)MOSSING, (Comparable)Integer.valueOf(0))).m_61124_((Property)LEGS, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MOSSING, WAXED, WATERLOGGED, LEGS});
        super.m_7926_(builder);
    }

    public int getMaxMossingStage() {
        return 3;
    }

    public IntegerProperty getAgeProperty() {
        return MOSSING;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.f_46443_) {
            return;
        }
        float chance = 0.0f;
        int maxLight = 0;
        chance += maxLight > 12 ? 0.1f : 0.05f;
        if ((Integer)state.m_61143_((Property)WAXED) == 0 && level.m_213780_().m_188501_() <= chance) {
            if (((Integer)state.m_61143_((Property)MOSSING)).intValue() == this.getMaxMossingStage()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MOSSING, (Comparable)Integer.valueOf(this.getMaxMossingStage())), 3);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MOSSING, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)MOSSING) + 1)), 3);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if ((Integer)state.m_61143_((Property)MOSSING) > 0) {
            if (heldStack.m_204117_(Tags.Items.SHEARS) && (Integer)state.m_61143_((Property)MOSSING) == 3) {
                StoneLanternBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_151015_));
                level.m_5594_(null, pos, SoundEvents.f_12075_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5594_(null, pos, SoundEvents.f_144187_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MOSSING, (Comparable)Integer.valueOf(0)), 2);
                if (!level.f_46443_) {
                    heldStack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(hand));
                }
                return InteractionResult.SUCCESS;
            }
            if (heldStack.m_204117_(Tags.Items.SHEARS) && (Integer)state.m_61143_((Property)MOSSING) <= 2) {
                level.m_5594_(null, pos, SoundEvents.f_12075_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5594_(null, pos, SoundEvents.f_144187_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MOSSING, (Comparable)Integer.valueOf(0)), 2);
                if (!level.f_46443_) {
                    heldStack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(hand));
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (heldStack.m_150930_(Items.f_42784_) && (Integer)state.m_61143_((Property)WAXED) == 0) {
            level.m_5594_(null, pos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)WAXED, (Comparable)Integer.valueOf(1)), 2);
            if (!level.f_46443_ && !player.m_7500_()) {
                heldStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (heldStack.m_204117_(ModTags.Items.AXES) && (Integer)state.m_61143_((Property)WAXED) == 1) {
            level.m_5594_(null, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)WAXED, (Comparable)Integer.valueOf(0)), 2);
            if (!level.f_46443_) {
                heldStack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
        }
        if (heldStack.m_204117_(ModTags.Items.PICKAXES) || heldStack.m_150930_((Item)ModItems.HAMMER.get())) {
            if ((Integer)state.m_61143_((Property)LEGS) == 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)LEGS, (Comparable)Integer.valueOf(1)), 2);
                level.m_5594_(null, pos, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if ((Integer)state.m_61143_((Property)LEGS) == 1) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)LEGS, (Comparable)Integer.valueOf(0)), 2);
                level.m_5594_(null, pos, SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (!level.f_46443_) {
                heldStack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Integer)pState.m_61143_((Property)LEGS)) {
            case 0: {
                return SHAPE_LEGLESS;
            }
        }
        return SHAPE;
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return (Integer)pState.m_61143_((Property)this.getAgeProperty()) < this.getMaxMossingStage();
    }

    public boolean m_214167_(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    protected int getBonemealAgeIncrease(Level level) {
        return Mth.m_216271_((RandomSource)level.f_46441_, (int)1, (int)1);
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        int age = Math.min(this.getMaxMossingStage(), (Integer)state.m_61143_((Property)MOSSING) + this.getBonemealAgeIncrease((Level)level));
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)MOSSING, (Comparable)Integer.valueOf(age)), 2);
        if (((Integer)state.m_61143_((Property)MOSSING)).intValue() == this.getMaxMossingStage()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)MOSSING, (Comparable)Integer.valueOf(3)), 3);
        }
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidState = pContext.m_43725_().m_6425_(pContext.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

