/*
 * Decompiled with CFR 0.152.
 */
package com.delta.redeco.block.custom;

import com.delta.redeco.tags.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;

public class LatticeBlock
extends LadderBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static IntegerProperty LEAVES = IntegerProperty.m_61631_((String)"leaves", (int)0, (int)3);
    public static BooleanProperty WAXED = BooleanProperty.m_61465_((String)"waxed");
    private static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public LatticeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LEAVES, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_54338_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WAXED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.m_61143_((Property)FACING)) {
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case EAST: {
                return EAST;
            }
        }
        return NORTH;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LEAVES, WAXED});
        super.m_7926_(builder);
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    private Integer leafType(LevelAccessor level, BlockPos source, Direction direction) {
        BlockState state = level.m_8055_(source.m_121945_(direction));
        if (state.m_60734_() == this) {
            return (Integer)state.m_61143_((Property)LEAVES);
        }
        return 0;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.f_46443_) {
            return;
        }
        float chance = 0.0f;
        int maxLight = 0;
        for (BlockPos neighborPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
            int light = level.m_45517_(LightLayer.SKY, neighborPos.m_7494_());
            if (light <= maxLight) continue;
            maxLight = light;
        }
        chance += maxLight > 12 ? 0.1f : 0.05f;
        if (!((Boolean)state.m_61143_((Property)WAXED)).booleanValue()) {
            Integer north = this.leafType((LevelAccessor)level, pos, Direction.NORTH);
            Integer south = this.leafType((LevelAccessor)level, pos, Direction.SOUTH);
            Integer east = this.leafType((LevelAccessor)level, pos, Direction.EAST);
            Integer west = this.leafType((LevelAccessor)level, pos, Direction.WEST);
            Integer up = this.leafType((LevelAccessor)level, pos, Direction.UP);
            Integer down = this.leafType((LevelAccessor)level, pos, Direction.DOWN);
            if (level.m_213780_().m_188501_() <= chance) {
                if ((Integer)state.m_61143_((Property)LEAVES) == 0) {
                    if (north == 1 || south == 1 || east == 1 || west == 1 || up == 1 || down == 1) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LEAVES, (Comparable)Integer.valueOf(1)), 2);
                    }
                    if (north == 2 || south == 2 || east == 2 || west == 2 || up == 2 || down == 2) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LEAVES, (Comparable)Integer.valueOf(1)), 2);
                    }
                    if (north == 3 || south == 3 || east == 3 || west == 3 || up == 3 || down == 3) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LEAVES, (Comparable)Integer.valueOf(3)), 2);
                    }
                }
                if ((Integer)state.m_61143_((Property)LEAVES) == 2) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)LEAVES, (Comparable)Integer.valueOf(1)), 2);
                }
                if ((Integer)state.m_61143_((Property)LEAVES) == 1) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)LEAVES, (Comparable)Integer.valueOf(2)), 2);
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_150930_(Items.f_42784_) && !((Boolean)state.m_61143_((Property)WAXED)).booleanValue()) {
            level.m_5594_(null, pos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)WAXED, (Comparable)Boolean.valueOf(true)), 2);
            if (!level.f_46443_) {
                heldStack.m_41764_(heldStack.m_41613_() - 1);
            }
            return InteractionResult.SUCCESS;
        }
        if (heldStack.m_204117_(ModTags.Items.AXES) && ((Boolean)state.m_61143_((Property)WAXED)).booleanValue()) {
            level.m_5594_(null, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 0.5f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)WAXED, (Comparable)Boolean.valueOf(false)), 2);
            if (!level.f_46443_) {
                heldStack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
        }
        if (heldStack.m_204117_(Tags.Items.SHEARS) && (Integer)state.m_61143_((Property)LEAVES) > 0) {
            if ((Integer)state.m_61143_((Property)LEAVES) == 1) {
                LatticeBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_151009_));
                level.m_5594_(null, pos, SoundEvents.f_144073_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if ((Integer)state.m_61143_((Property)LEAVES) == 2) {
                LatticeBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_186362_));
                level.m_5594_(null, pos, SoundEvents.f_144073_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if ((Integer)state.m_61143_((Property)LEAVES) == 3) {
                LatticeBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_271517_));
                level.m_5594_(null, pos, SoundEvents.f_271319_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LEAVES, (Comparable)Integer.valueOf(0)), 2);
            if (!level.f_46443_) {
                heldStack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        if (heldStack.m_150930_(Items.f_151009_) && (Integer)state.m_61143_((Property)LEAVES) == 0) {
            level.m_5594_(null, pos, SoundEvents.f_144057_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LEAVES, (Comparable)Integer.valueOf(1)), 2);
            if (!level.f_46443_) {
                heldStack.m_41774_(1);
                if (player.m_7500_()) {
                    heldStack.m_41769_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (heldStack.m_150930_(Items.f_186362_) && (Integer)state.m_61143_((Property)LEAVES) == 0) {
            level.m_5594_(null, pos, SoundEvents.f_144057_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LEAVES, (Comparable)Integer.valueOf(2)), 2);
            if (!level.f_46443_) {
                heldStack.m_41774_(1);
                if (player.m_7500_()) {
                    heldStack.m_41769_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (heldStack.m_150930_(Items.f_271517_) && (Integer)state.m_61143_((Property)LEAVES) == 0) {
            level.m_5594_(null, pos, SoundEvents.f_271127_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LEAVES, (Comparable)Integer.valueOf(3)), 2);
            if (!level.f_46443_) {
                heldStack.m_41774_(1);
                if (player.m_7500_()) {
                    heldStack.m_41769_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

