/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.handlers;

import com.alrex.parcool.api.unstable.action.ParCoolActionEvent;
import com.alrex.parcool.common.action.impl.BreakfallReady;
import com.alrex.parcool.common.action.impl.ChargeJump;
import com.alrex.parcool.common.action.impl.Dodge;
import com.alrex.parcool.common.action.impl.HideInBlock;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.action.impl.Tap;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.network.StartBreakfallMessage;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.WorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerDamageHandler {
    @SubscribeEvent
    public static void onAttack(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Parkourability parkourability = Parkourability.get(player);
            if (parkourability == null) {
                return;
            }
            Dodge dodge = parkourability.get(Dodge.class);
            if (dodge.isDoing()) {
                if (!parkourability.getServerLimitation().get(ParCoolConfig.Server.Booleans.DodgeProvideInvulnerableFrame).booleanValue()) {
                    return;
                }
                if (event.getSource().m_269533_(DamageTypeTags.f_268490_)) {
                    return;
                }
                if (dodge.getDoingTick() <= 10) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            parkourability = Parkourability.get((Player)player);
            if (parkourability == null) {
                return;
            }
            if (((Parkourability)parkourability).get(BreakfallReady.class).isDoing() && (((Parkourability)parkourability).getActionInfo().can(Tap.class) || ((Parkourability)parkourability).getActionInfo().can(Roll.class))) {
                boolean justTime = ((Parkourability)parkourability).get(BreakfallReady.class).getDoingTick() < 5;
                float distance = event.getDistance();
                if (!((double)distance > ((Parkourability)parkourability).getClientInfo().get(ParCoolConfig.Client.Doubles.LowestFallDistanceForBreakfall))) {
                    return;
                }
                StartBreakfallMessage.send(player, justTime);
                if (distance < 6.0f || justTime && distance < 8.0f) {
                    event.setCanceled(true);
                } else {
                    event.setDamageMultiplier(event.getDamageMultiplier() * (justTime ? 0.4f : 0.6f));
                }
            } else {
                Tuple<BlockPos, BlockPos> area;
                HideInBlock hideInBlock = ((Parkourability)parkourability).get(HideInBlock.class);
                if (hideInBlock.isStandbyInAir((Parkourability)parkourability) && ((Parkourability)parkourability).getActionInfo().can(HideInBlock.class) && !MinecraftForge.EVENT_BUS.post((Event)new ParCoolActionEvent.TryToStartEvent((Player)player, hideInBlock)) && (area = WorldUtil.getHideAbleSpace((Entity)player, new BlockPos((Vec3i)player.m_20183_().m_7495_()))) != null) {
                    boolean stand;
                    boolean bl = stand = player.m_20206_() < (float)(Math.abs(((BlockPos)area.m_14419_()).m_123342_() - ((BlockPos)area.m_14418_()).m_123342_()) + 1);
                    if (!stand) {
                        if (event.getDistance() < 10.0f) {
                            event.setCanceled(true);
                        } else {
                            event.setDamageMultiplier(event.getDamageMultiplier() * 0.4f);
                        }
                    }
                }
            }
        } else {
            parkourability = event.getEntity();
            if (parkourability instanceof Player) {
                Player player = (Player)parkourability;
                if (!player.m_7578_()) {
                    return;
                }
                parkourability = Parkourability.get(player);
                if (parkourability == null) {
                    return;
                }
                if (((Parkourability)parkourability).getAdditionalProperties().getNotLandingTick() > 5 && event.getDistance() < 0.4f) {
                    ((Parkourability)parkourability).get(ChargeJump.class).onLand(player, (Parkourability)parkourability);
                }
            }
        }
    }
}

