/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.HorizontalWallRunAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.Dodge;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.action.impl.Vault;
import com.alrex.parcool.common.action.impl.WallJump;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.VectorUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class HorizontalWallRun
extends Action {
    private int coolTime = 0;
    private float bodyYaw = 0.0f;
    private boolean wallIsRightward = false;
    private Vec3 runningWallDirection = null;
    private Vec3 runningDirection = null;

    private int getMaxRunningTick(ActionInfo info) {
        Integer value = info.getClientSetting().get(ParCoolConfig.Client.Integers.WallRunContinuableTick);
        if (value == null) {
            value = ParCoolConfig.Client.Integers.WallRunContinuableTick.DefaultValue;
        }
        return Math.min(value, info.getServerLimitation().get(ParCoolConfig.Server.Integers.MaxWallRunContinuableTick));
    }

    @Override
    public void onClientTick(Player player, Parkourability parkourability, IStamina stamina) {
        if (this.coolTime > 0) {
            --this.coolTime;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWorkingTickInLocalClient(Player player, Parkourability parkourability, IStamina stamina) {
        Vec3 wallDirection = WorldUtil.getRunnableWall((LivingEntity)player, player.m_20205_() * 0.65f);
        if (wallDirection == null) {
            return;
        }
        if (this.runningWallDirection == null) {
            return;
        }
        if (this.runningDirection == null) {
            return;
        }
        Vec3 lookVec = VectorUtil.fromYawDegree(player.f_20883_);
        double differenceAngle = Math.asin(new Vec3(lookVec.m_7096_() * this.runningDirection.m_7096_() + lookVec.m_7094_() * this.runningDirection.m_7094_(), 0.0, -lookVec.m_7096_() * this.runningDirection.m_7094_() + lookVec.m_7094_() * this.runningDirection.m_7096_()).m_82541_().m_7094_());
        this.bodyYaw = (float)VectorUtil.toYawDegree(lookVec.m_82524_((float)(differenceAngle / 10.0)));
        Vec3 movement = player.m_20184_();
        BlockPos leanedBlock = new BlockPos((int)(player.m_20185_() + this.runningWallDirection.m_7096_()), (int)(player.m_20191_().f_82289_ + (double)player.m_20206_() * 0.5), (int)(player.m_20189_() + this.runningWallDirection.m_7094_()));
        if (!player.m_20193_().m_46749_(leanedBlock)) {
            return;
        }
        float slipperiness = player.m_20193_().m_8055_(leanedBlock).getFriction((LevelReader)player.m_20193_(), leanedBlock, (Entity)player);
        if ((double)slipperiness <= 0.8) {
            double speedScale = 0.2;
            AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
            if (attr != null) {
                speedScale *= attr.m_22135_() / attr.m_22115_();
            }
            player.m_20334_(this.runningDirection.m_7096_() * speedScale, movement.m_7098_() * ((double)slipperiness - 0.1) * (double)this.getDoingTick() / (double)this.getMaxRunningTick(parkourability.getActionInfo()), this.runningDirection.m_7094_() * speedScale);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        Vec3 wallDirection = WorldUtil.getRunnableWall((LivingEntity)player, player.m_20205_() * 0.65f);
        if (wallDirection == null) {
            return false;
        }
        Vec3 wallVec = wallDirection.m_82541_();
        Vec3 lookDirection = VectorUtil.fromYawDegree(player.f_20883_);
        lookDirection = new Vec3(lookDirection.m_7096_(), 0.0, lookDirection.m_7094_()).m_82541_();
        Vec3 dividedVec = new Vec3(wallVec.m_7096_() * lookDirection.m_7096_() + wallVec.m_7094_() * lookDirection.m_7094_(), 0.0, -wallVec.m_7096_() * lookDirection.m_7094_() + wallVec.m_7094_() * lookDirection.m_7096_()).m_82541_();
        if (Math.abs(dividedVec.m_7094_()) < 0.9) {
            return false;
        }
        BufferUtil.wrap(startInfo).putBoolean(dividedVec.m_7094_() > 0.0);
        Vec3 runDirection = wallVec.m_82524_(1.5707964f);
        if (runDirection.m_82526_(lookDirection) < 0.0) {
            runDirection = runDirection.m_82548_();
        }
        startInfo.putDouble(wallDirection.m_7096_()).putDouble(wallDirection.m_7094_()).putDouble(runDirection.m_7096_()).putDouble(runDirection.m_7094_());
        return !parkourability.get(WallJump.class).justJumped() && (ParCoolConfig.Client.HWallRunControl.get() == ControlType.PressKey && KeyBindings.getKeyHorizontalWallRun().m_90857_() || ParCoolConfig.Client.HWallRunControl.get() == ControlType.Auto) && !parkourability.get(Crawl.class).isDoing() && !parkourability.get(Dodge.class).isDoing() && !parkourability.get(Vault.class).isDoing() && !parkourability.get(ClingToCliff.class).isDoing() && !player.m_20072_() && Math.abs(player.m_20184_().m_7098_()) < 0.5 && this.coolTime == 0 && !player.m_20096_() && parkourability.getAdditionalProperties().getNotLandingTick() > 5 && (parkourability.get(FastRun.class).canActWithRunning(player) || parkourability.get(FastRun.class).getNotDashTick(parkourability.getAdditionalProperties()) < 10) && !stamina.isExhausted();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        Vec3 wallDirection = WorldUtil.getRunnableWall((LivingEntity)player, player.m_20205_() * 0.65f);
        if (wallDirection == null) {
            return false;
        }
        if (!(player instanceof LocalPlayer)) {
            return false;
        }
        LocalPlayer localPlayer = (LocalPlayer)player;
        if (localPlayer.f_108618_ == null) {
            return false;
        }
        Vec2 moveVector = localPlayer.f_108618_.m_108575_();
        Vec3 actualInputVector = new Vec3((double)moveVector.f_82470_, 0.0, (double)moveVector.f_82471_).m_82541_().m_82524_((float)(-Math.toRadians(player.m_146908_())));
        if (wallDirection.m_82541_().m_82526_(actualInputVector) < -0.86) {
            return false;
        }
        return this.getDoingTick() < this.getMaxRunningTick(parkourability.getActionInfo()) && !stamina.isExhausted() && !parkourability.get(WallJump.class).justJumped() && !parkourability.get(Crawl.class).isDoing() && !parkourability.get(Dodge.class).isDoing() && !parkourability.get(Vault.class).isDoing() && (ParCoolConfig.Client.HWallRunControl.get() == ControlType.PressKey && KeyBindings.getKeyHorizontalWallRun().m_90857_() || ParCoolConfig.Client.HWallRunControl.get() == ControlType.Auto) && !player.m_20096_();
    }

    @Override
    public void onStop(Player player) {
        this.coolTime = 10;
    }

    @Override
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        Animation animation;
        this.wallIsRightward = BufferUtil.getBoolean(startData);
        this.runningWallDirection = new Vec3(startData.getDouble(), 0.0, startData.getDouble());
        this.runningDirection = new Vec3(startData.getDouble(), 0.0, startData.getDouble());
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.HORIZONTAL_WALL_RUN.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new HorizontalWallRunAnimator(this.wallIsRightward));
        }
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        this.wallIsRightward = BufferUtil.getBoolean(startData);
        this.runningWallDirection = new Vec3(startData.getDouble(), 0.0, startData.getDouble());
        this.runningDirection = new Vec3(startData.getDouble(), 0.0, startData.getDouble());
        Animation animation = Animation.get(player);
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.HORIZONTAL_WALL_RUN.get(), 1.0f, 1.0f);
        }
        if (animation != null) {
            animation.setAnimator(new HorizontalWallRunAnimator(this.wallIsRightward));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
        if (this.isDoing()) {
            if (this.runningDirection == null) {
                return;
            }
            Vec3 lookVec = VectorUtil.fromYawDegree(player.m_6080_());
            double differenceAngle = Math.asin(new Vec3(lookVec.m_7096_() * this.runningDirection.m_7096_() + lookVec.m_7094_() * this.runningDirection.m_7094_(), 0.0, -lookVec.m_7096_() * this.runningDirection.m_7094_() + lookVec.m_7094_() * this.runningDirection.m_7096_()).m_82541_().m_7094_());
            if (Math.abs(differenceAngle) > 0.7853981633974483) {
                player.m_146922_((float)VectorUtil.toYawDegree(this.runningDirection.m_82524_((float)(-Math.signum(differenceAngle) * Math.PI / 4.0))));
            }
            player.f_20884_ = player.f_20883_ = this.bodyYaw;
        }
    }

    @Override
    public void onWorkingTickInClient(Player player, Parkourability parkourability, IStamina stamina) {
        this.spawnRunningParticle(player);
    }

    @Override
    public void saveSynchronizedState(ByteBuffer buffer) {
        buffer.putFloat(this.bodyYaw);
    }

    @Override
    public void restoreSynchronizedState(ByteBuffer buffer) {
        this.bodyYaw = buffer.getFloat();
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnRunningParticle(Player player) {
        Vec3 pos;
        BlockPos leanedBlock;
        if (!ParCoolConfig.Client.Booleans.EnableActionParticles.get().booleanValue()) {
            return;
        }
        if (this.runningDirection == null || this.runningWallDirection == null) {
            return;
        }
        Level level = player.m_9236_();
        if (!level.m_46749_(leanedBlock = new BlockPos((int)Math.floor((pos = player.m_20182_()).m_7096_() + this.runningWallDirection.m_7096_()), (int)Math.floor(pos.m_7098_() + (double)player.m_20206_() * 0.25), (int)Math.floor(pos.m_7094_() + this.runningWallDirection.m_7094_())))) {
            return;
        }
        float width = player.m_20205_();
        BlockState blockstate = level.m_8055_(leanedBlock);
        Vec3 wallDirection = this.runningWallDirection.m_82541_();
        Vec3 orthogonalToWallVec = wallDirection.m_82524_(1.5707964f);
        Vec3 particleBaseDirection = this.runningDirection.m_82546_(wallDirection);
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            Vec3 particlePos = new Vec3(pos.m_7096_() + (wallDirection.m_7096_() * 0.4 + orthogonalToWallVec.m_7096_() * (player.m_217043_().m_188500_() - 0.5)) * (double)width, pos.m_7098_() + 0.1 + 0.3 * player.m_217043_().m_188500_(), pos.m_7094_() + (wallDirection.m_7094_() * 0.4 + orthogonalToWallVec.m_7094_() * (player.m_217043_().m_188500_() - 0.5)) * (double)width);
            Vec3 particleSpeed = particleBaseDirection.m_82524_((float)(0.6283185307179586 * (player.m_217043_().m_188500_() - 0.5))).m_82490_(3.0 + 6.0 * player.m_217043_().m_188500_()).m_82520_(0.0, 1.5, 0.0);
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(leanedBlock), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), particleSpeed.m_7096_(), particleSpeed.m_7098_(), particleSpeed.m_7094_());
        }
    }

    public static enum ControlType {
        PressKey,
        Auto;

    }
}

