/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.ritchiesprojectilelib.projectile_burst;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.ritchiesprojectilelib.network.ClientboundSyncBurstSubProjectilesPacket;
import rbasamoyai.ritchiesprojectilelib.network.RPLNetwork;
import rbasamoyai.ritchiesprojectilelib.projectile_burst.ProjectileBurstClipContext;

public abstract class ProjectileBurst
extends Projectile {
    protected int age = 0;
    protected final List<SubProjectile> subProjectiles = new LinkedList<SubProjectile>();

    protected ProjectileBurst(EntityType<? extends ProjectileBurst> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_7380_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (SubProjectile subProjectile : this.subProjectiles) {
            list.add((Object)subProjectile.toTag());
        }
        tag.m_128365_("SubProjectiles", (Tag)list);
        tag.m_128405_("Age", this.age);
    }

    protected void m_7378_(CompoundTag tag) {
        this.subProjectiles.clear();
        ListTag list = tag.m_128437_("SubProjectiles", 10);
        int sz = list.size();
        for (int i = 0; i < sz; ++i) {
            this.subProjectiles.add(SubProjectile.fromTag(list.m_128728_(i)));
        }
        this.age = tag.m_128451_("Age");
    }

    protected void m_8097_() {
    }

    protected void syncAllDataToServer() {
        RPLNetwork.sendToClientTracking(new ClientboundSyncBurstSubProjectilesPacket(this.m_19879_(), this.age, new LinkedList<SubProjectile>(this.subProjectiles)), (Entity)this);
    }

    public void updateClientData(int age, List<SubProjectile> subProjectiles) {
        this.age = age;
        this.subProjectiles.clear();
        this.subProjectiles.addAll(subProjectiles);
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && this.f_19797_ % 10 == 1) {
            this.syncAllDataToServer();
        }
        Iterator<SubProjectile> iter = this.subProjectiles.iterator();
        while (iter.hasNext()) {
            SubProjectile subProjectile = iter.next();
            HitResult result = this.clipAndDamage(subProjectile);
            if (result.m_6662_() != HitResult.Type.MISS) {
                this.onSubProjectileHit(result, subProjectile);
                iter.remove();
                continue;
            }
            subProjectile.displacement[0] = subProjectile.displacement[0] + subProjectile.velocity[0];
            subProjectile.displacement[1] = subProjectile.displacement[1] + subProjectile.velocity[1];
            subProjectile.displacement[2] = subProjectile.displacement[2] + subProjectile.velocity[2];
            this.applyForces(subProjectile.velocity, subProjectile.displacement);
        }
        super.m_8119_();
        if (++this.age >= this.getLifetime()) {
            this.m_146870_();
        }
    }

    protected abstract int getLifetime();

    protected abstract void applyForces(double[] var1, double[] var2);

    protected HitResult clipAndDamage(SubProjectile info) {
        Vec3 vel = new Vec3(info.velocity[0], info.velocity[1], info.velocity[2]);
        Vec3 start = new Vec3(info.displacement[0] + this.m_20185_(), info.displacement[1] + this.m_20186_(), info.displacement[2] + this.m_20189_());
        Vec3 end = start.m_82549_(vel);
        double halfHeight = this.getSubProjectileHeight() / 2.0;
        double halfWidth = this.getSubProjectileWidth() / 2.0;
        BlockHitResult hitResult = this.m_9236_().m_45547_((ClipContext)new ProjectileBurstClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this, start.f_82480_ - halfHeight));
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            end = hitResult.m_82450_();
        }
        AABB aabb = new AABB(start.f_82479_ - halfWidth, start.f_82480_ - halfHeight, start.f_82481_ - halfWidth, start.f_82479_ + halfWidth, start.f_82480_ + halfHeight, start.f_82481_ + halfWidth);
        EntityHitResult hitResult2 = ProjectileUtil.m_150175_((Level)this.m_9236_(), (Entity)this, (Vec3)start, (Vec3)end, (AABB)aabb.m_82369_(vel).m_82400_(1.0), this::m_5603_, (float)((float)halfWidth));
        if (hitResult2 != null) {
            hitResult = hitResult2;
        }
        return hitResult;
    }

    public void addSubProjectile(double dispX, double dispY, double dispZ, double velX, double velY, double velZ) {
        this.subProjectiles.add(new SubProjectile(new double[]{dispX, dispY, dispZ}, new double[]{velX, velY, velZ}));
    }

    public int getSubProjectileCount() {
        return this.subProjectiles.size();
    }

    public List<SubProjectile> getSubProjectiles() {
        return this.subProjectiles;
    }

    public abstract double getSubProjectileWidth();

    public abstract double getSubProjectileHeight();

    public boolean m_6087_() {
        return false;
    }

    protected boolean m_5603_(Entity target) {
        return super.m_5603_(target) && !target.f_19794_;
    }

    protected void onSubProjectileHit(HitResult result, SubProjectile subProjectile) {
        HitResult.Type type = result.m_6662_();
        if (type == HitResult.Type.ENTITY) {
            this.onSubProjectileHitEntity((EntityHitResult)result, subProjectile);
        } else if (type == HitResult.Type.BLOCK) {
            this.onSubProjectileHitBlock((BlockHitResult)result, subProjectile);
        }
        if (type != HitResult.Type.MISS) {
            this.m_9236_().m_220400_((Entity)this, GameEvent.f_157777_, new Vec3(subProjectile.displacement[0] + this.m_20185_(), subProjectile.displacement[1] + this.m_20186_(), subProjectile.displacement[2] + this.m_20189_()));
        }
    }

    protected void onSubProjectileHitEntity(EntityHitResult result, SubProjectile subProjectile) {
    }

    protected void onSubProjectileHitBlock(BlockHitResult result, SubProjectile subProjectile) {
        BlockState blockState = this.m_9236_().m_8055_(result.m_82425_());
        blockState.m_60669_(this.m_9236_(), blockState, result, (Projectile)this);
    }

    public record SubProjectile(double[] displacement, double[] velocity) {
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            ListTag posTag = new ListTag();
            posTag.add((Object)DoubleTag.m_128500_((double)this.displacement[0]));
            posTag.add((Object)DoubleTag.m_128500_((double)this.displacement[1]));
            posTag.add((Object)DoubleTag.m_128500_((double)this.displacement[2]));
            tag.m_128365_("Pos", (Tag)posTag);
            ListTag velTag = new ListTag();
            velTag.add((Object)DoubleTag.m_128500_((double)this.velocity[0]));
            velTag.add((Object)DoubleTag.m_128500_((double)this.velocity[1]));
            velTag.add((Object)DoubleTag.m_128500_((double)this.velocity[2]));
            tag.m_128365_("Vel", (Tag)velTag);
            return tag;
        }

        public static SubProjectile fromTag(CompoundTag tag) {
            ListTag posTag = tag.m_128437_("Pos", 6);
            ListTag velTag = tag.m_128437_("Vel", 6);
            return new SubProjectile(new double[]{posTag.m_128772_(0), posTag.m_128772_(1), posTag.m_128772_(2)}, new double[]{velTag.m_128772_(0), velTag.m_128772_(1), velTag.m_128772_(2)});
        }
    }
}

