/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import com.cozary.nameless_trinkets.utils.EntityUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class TrueHeartOfTheSea
extends TrinketItem<Stats>
implements ICurioItem {
    public static TrueHeartOfTheSea INSTANCE;
    private final MutablePair<String, UUID> TearOfTHeSea_MOD = new MutablePair((Object)"nameless_trinkets:tear_of_the_sea_swim_speed", (Object)UUID.randomUUID());

    public TrueHeartOfTheSea() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    @SubscribeEvent
    public static void function(PlayerEvent.BreakSpeed event) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (event.getEntity() != null && !event.getEntity().m_5833_()) {
            Player player = event.getEntity();
            Optional stack1 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.TRUE_HEART_OF_THE_SEA.get());
            if (stack1.isPresent() && player.m_204029_(FluidTags.f_13131_)) {
                event.setNewSpeed(event.getOriginalSpeed() * config.miningUnderwaterSpeed);
            }
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.TRUE_HEART_OF_THE_SEA.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.true_heart_of_the_sea_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.true_heart_of_the_sea_1", (Object[])new Object[]{config.swimSpeedMultiplier + "%"}).m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.true_heart_of_the_sea_2").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.true_heart_of_the_sea_3").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.true_heart_of_the_sea_4", (Object[])new Object[]{Float.valueOf(config.miningUnderwaterSpeed)}).m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(slotContext.entity() instanceof Player)) {
            return;
        }
        if (livingEntity.m_20146_() == -20) {
            Vec3 vector3d = livingEntity.m_20184_();
            livingEntity.m_20301_(0);
            Random random = new Random();
            for (int i = 0; i < 8; ++i) {
                double d2 = random.nextDouble() - random.nextDouble();
                double d3 = random.nextDouble() - random.nextDouble();
                double d4 = random.nextDouble() - random.nextDouble();
                livingEntity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, livingEntity.m_20185_() + d2, livingEntity.m_20186_() + d3, livingEntity.m_20189_() + d4, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
            }
            if (config.blindnessWhenChoking) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 30, 10, false, false));
            }
            livingEntity.m_6469_(livingEntity.m_269291_().m_269063_(), config.chokingDamage);
        } else if (!livingEntity.m_204029_(FluidTags.f_13131_) || livingEntity.m_9236_().m_8055_(new BlockPos((int)livingEntity.m_20185_(), (int)livingEntity.m_20188_(), (int)livingEntity.m_20189_())).m_60713_(Blocks.f_50628_)) {
            livingEntity.m_20301_(livingEntity.m_20146_() - config.airReductionSpeed);
        } else {
            livingEntity.m_20301_(300);
        }
        Level world = livingEntity.m_20193_();
        if (world.m_5776_() || livingEntity.f_19797_ % 20 != 0) {
            return;
        }
        AttributeInstance attribSpeed = livingEntity.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
        AttributeModifier speedModifier = new AttributeModifier((UUID)this.TearOfTHeSea_MOD.getRight(), (String)this.TearOfTHeSea_MOD.getLeft(), config.swimSpeedMultiplier / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        assert (attribSpeed != null);
        EntityUtils.applyAttributeModifier(attribSpeed, speedModifier);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.entity().m_21051_((Attribute)ForgeMod.SWIM_SPEED.get())), new AttributeModifier((UUID)this.TearOfTHeSea_MOD.getRight(), (String)this.TearOfTHeSea_MOD.getLeft(), ((Stats)this.config).swimSpeedMultiplier / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    public static class Stats
    extends TrinketsStats {
        public float miningUnderwaterSpeed = 3.0f;
        public float chokingDamage = 1.5f;
        public boolean blindnessWhenChoking = true;
        public int airReductionSpeed = 5;
        public double swimSpeedMultiplier = 300.0;
        public boolean isEnable = true;
    }
}

