/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class Tick
extends TrinketItem<Stats>
implements ICurioItem {
    public static Tick INSTANCE;

    public Tick() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    public static boolean isValidTarget(LivingEntity ent) {
        return ent.m_6095_() != EntityType.f_20532_ && !ent.m_20147_();
    }

    @SubscribeEvent
    public static void function(TickEvent.PlayerTickEvent event) {
        Optional stack;
        Player player;
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.player instanceof Player)) {
            return;
        }
        if (event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer && !player.m_5833_() && (stack = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.TICK.get())).isPresent()) {
            AABB targetBox = new AABB(player.m_20182_(), player.m_20182_()).m_82400_((double)config.rangeToActivate);
            List foundTarget = player.m_9236_().m_6443_(LivingEntity.class, targetBox, Tick::isValidTarget);
            if (!foundTarget.isEmpty()) {
                for (LivingEntity livingEntity : foundTarget) {
                    if (livingEntity.m_21233_() > 50.0f && livingEntity.m_21223_() > livingEntity.m_21233_() / 2.0f && player.m_21223_() >= 5.0f) {
                        livingEntity.m_6469_(livingEntity.m_269291_().m_269264_(), livingEntity.m_21233_() * (config.entityDamagePercentage / 100.0f));
                        player.m_6469_(livingEntity.m_269291_().m_269264_(), player.m_21233_() * (config.playerDamagePercentage / 100.0f));
                        continue;
                    }
                    if (!(livingEntity.m_21233_() > 50.0f) || !(livingEntity.m_21223_() > livingEntity.m_21233_() / 2.0f) || player.m_36324_().m_38702_() < 5) continue;
                    livingEntity.m_6469_(livingEntity.m_269291_().m_269264_(), livingEntity.m_21233_() * (config.entityDamagePercentage / 100.0f));
                    player.m_36399_((float)player.m_36324_().m_38702_() * (config.playerHungerPercentage / 100.0f));
                }
            }
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.TICK.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        Player player = (Player)livingEntity;
        return livingEntity.m_6060_() || player.m_150110_().f_35937_;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.tick_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.tick_1", (Object[])new Object[]{config.entityDamagePercentage + "%"}).m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.tick_2").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.tick_3").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.tick_4").m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public float rangeToActivate = 25.0f;
        public float entityDamagePercentage = 1.0f;
        public float playerDamagePercentage = 5.0f;
        public float playerHungerPercentage = 10.0f;
        public boolean isEnable = true;
    }
}

