/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class SleepingPills
extends TrinketItem<Stats>
implements ICurioItem {
    public static SleepingPills INSTANCE;

    public SleepingPills() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    @SubscribeEvent
    public static void general(TickEvent.PlayerTickEvent event) {
        Optional stack0;
        Player player;
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.player instanceof Player)) {
            return;
        }
        if (event.phase == TickEvent.Phase.START && (player = event.player) != null && !player.m_5833_() && (stack0 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.SLEEPING_PILLS.get())).isPresent()) {
            List list;
            if (!player.m_21023_(MobEffects.f_19611_) || Objects.requireNonNull(player.m_21124_(MobEffects.f_19611_)).m_19557_() < 600) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, config.nightVisionTime, 0, false, false));
            }
            if (!player.m_21023_(MobEffects.f_19613_) || Objects.requireNonNull(player.m_21124_(MobEffects.f_19613_)).m_19557_() < 600) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, config.weaknessTime, 0, false, false));
            }
            if (!(list = player.m_9236_().m_6443_(Phantom.class, player.m_20191_().m_82400_(config.phantomRange), EntitySelector.f_20402_)).isEmpty()) {
                for (Phantom phantomEntity : list) {
                    if (!phantomEntity.m_9236_().f_46443_) {
                        Vec3 vector3d = phantomEntity.m_20184_();
                        ((ServerLevel)phantomEntity.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123783_, phantomEntity.m_20185_(), phantomEntity.m_20186_(), phantomEntity.m_20189_(), 250, vector3d.f_82479_, 0.3, vector3d.f_82481_, 5.0);
                    }
                    phantomEntity.m_146870_();
                }
            }
        }
    }

    @SubscribeEvent
    public static void antiSleep(PlayerSleepInBedEvent event) {
        Optional stack0;
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = event.getEntity();
        if (player != null && !player.m_5833_() && (stack0 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.SLEEPING_PILLS.get())).isPresent() && config.bedDisabled) {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.SLEEPING_PILLS.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.sleeping_pills_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.sleeping_pills_1", (Object[])new Object[]{config.phantomRange}).m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.sleeping_pills_2").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.sleeping_pills_3").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.sleeping_pills_4").m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
                tooltip.add((Component)Component.m_237115_((String)(ChatFormatting.GRAY + "Suggested By: JayOnline_")));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public int nightVisionTime = 1200;
        public int weaknessTime = 1200;
        public double phantomRange = 2.0;
        public boolean bedDisabled = true;
        public boolean isEnable = true;
    }
}

