/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.capability.NewCapabilities;
import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class SigilOfBaphomet
extends TrinketItem<Stats>
implements ICurioItem {
    public static SigilOfBaphomet INSTANCE;

    public SigilOfBaphomet() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    @SubscribeEvent
    public static void SigilOfBaphometCount(LivingDeathEvent event) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Optional stack0 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.SIGIL_OF_BAPHOMET.get());
            NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
                if (stack0.isPresent() && trinketsData.getSigil() <= 10.0f) {
                    trinketsData.setSigil(trinketsData.getSigil() + 1.0f);
                }
            });
        }
    }

    @SubscribeEvent
    public static void SigilOfBaphometTime(TickEvent.PlayerTickEvent event) {
        Player player;
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.player instanceof Player)) {
            return;
        }
        if (event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            Optional stack0 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.SIGIL_OF_BAPHOMET.get());
            NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
                if (stack0.isPresent() && trinketsData.getSigil() > 0.0f && trinketsData.getTick() >= 20.0f) {
                    trinketsData.setSigil(trinketsData.getSigil() - 1.0f);
                    trinketsData.setTick(0.0f);
                } else if (stack0.isPresent() && trinketsData.getSigil() > 0.0f) {
                    trinketsData.setTick(trinketsData.getTick() + 1.0f);
                } else if (stack0.isEmpty() && trinketsData.getTick() > 0.0f) {
                    trinketsData.setTick(0.0f);
                }
            });
        }
    }

    @SubscribeEvent
    public static void SigilOfBaphometImmunity(LivingHurtEvent event) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getEntity() == player) {
                Optional stack0 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.SIGIL_OF_BAPHOMET.get());
                NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
                    if (stack0.isPresent() && trinketsData.getSigil() > 0.0f && !player.m_9236_().f_46443_) {
                        ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123809_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 50, 0.5, 1.0, 0.5, 0.1);
                        event.setAmount(0.0f);
                    }
                });
            }
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.SIGIL_OF_BAPHOMET.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.sigil_of_baphomet_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.sigil_of_baphomet_1").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.sigil_of_baphomet_2").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.sigil_of_baphomet_3").m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public boolean isEnable = true;
    }
}

