/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class MissingPage
extends TrinketItem<Stats>
implements ICurioItem {
    public static MissingPage INSTANCE;

    public MissingPage() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    public static boolean isValidTarget(LivingEntity ent) {
        return ent.m_6095_() != EntityType.f_20532_ && !ent.m_20147_();
    }

    @SubscribeEvent
    public static void function(LivingDamageEvent event) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        DamageSource source = event.getSource();
        Entity src = source.m_7639_();
        Random random = new Random();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Optional stack = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.MISSING_PAGE.get());
            if (stack.isPresent() && random.nextInt(100) <= config.activationPercentage) {
                AABB targetBox = new AABB(player.m_20182_(), player.m_20182_()).m_82400_((double)config.radiusInBlocks);
                List foundTarget = event.getEntity().m_9236_().m_6443_(LivingEntity.class, targetBox, MissingPage::isValidTarget);
                if (!(src == null || src instanceof Player || foundTarget.isEmpty() || player.m_9236_().f_46443_)) {
                    for (LivingEntity livingEntity2 : foundTarget) {
                        ((ServerLevel)livingEntity2.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123746_, livingEntity2.m_20185_(), livingEntity2.m_20186_(), livingEntity2.m_20189_(), 35, 1.0, 1.0, 1.0, 0.1);
                        livingEntity2.m_6469_(livingEntity2.m_269291_().m_269264_(), livingEntity2.m_21233_() * (config.percentageOfDamage / 100.0f));
                    }
                }
            }
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.MISSING_PAGE.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.missing_page_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.missing_page_1", (Object[])new Object[]{config.activationPercentage + "%", Float.valueOf(config.radiusInBlocks)}).m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.missing_page_2", (Object[])new Object[]{config.percentageOfDamage + "%"}).m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public int activationPercentage = 25;
        public float radiusInBlocks = 25.0f;
        public float percentageOfDamage = 20.0f;
        public boolean isEnable = true;
    }
}

