/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class IceCube
extends TrinketItem<Stats>
implements ICurioItem {
    public static IceCube INSTANCE;

    public IceCube() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    @SubscribeEvent
    public static void function(LivingHurtEvent event) {
        Optional stack0;
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        DamageSource source = event.getSource();
        Entity src = source.m_7639_();
        if (src instanceof Player && (stack0 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)src, (Item)ModItems.ICE_CUBE.get())).isPresent()) {
            MobEffectInstance effectinstance = new MobEffectInstance(MobEffects.f_19597_, config.slownessTime, config.slownessLevel);
            LivingEntity potionGo = event.getEntity();
            potionGo.m_7292_(effectinstance);
        }
    }

    @SubscribeEvent
    public static void IceCubeGround(TickEvent.PlayerTickEvent event) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.player instanceof Player)) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            Optional stack0;
            Player player = event.player;
            BlockPos pos = player.m_20183_();
            Level world = player.m_9236_();
            if (player instanceof ServerPlayer && !player.m_5833_() && (stack0 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.ICE_CUBE.get())).isPresent() && !player.m_9236_().f_46443_) {
                BlockState block = Blocks.f_50126_.m_49966_();
                ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), player.m_20185_(), player.m_20186_(), player.m_20189_(), 1, 0.5, 1.0, 0.5, 0.1);
                if (player.m_20096_()) {
                    BlockState blockstate = Blocks.f_50449_.m_49966_();
                    float f = Math.min(16, 2 + config.frostWalkerLevel);
                    BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
                    for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_((int)(-f), -1, (int)(-f)), (BlockPos)pos.m_7918_((int)f, -1, (int)f))) {
                        boolean isFull;
                        if (!blockpos.m_203195_((Position)player.m_20182_(), (double)f)) continue;
                        blockpos$mutable.m_122178_(blockpos.m_123341_(), blockpos.m_123342_() + 1, blockpos.m_123343_());
                        BlockState blockstate1 = world.m_8055_((BlockPos)blockpos$mutable);
                        if (!blockstate1.m_60795_()) continue;
                        BlockState blockstate2 = world.m_8055_(blockpos);
                        boolean bl = isFull = blockstate2.m_60734_() == Blocks.f_49990_ && (Integer)blockstate2.m_61143_((Property)LiquidBlock.f_54688_) == 0;
                        if (blockstate2 != FrostedIceBlock.m_278844_() || !isFull || !blockstate.m_60710_((LevelReader)world, blockpos) || !world.m_45752_(blockstate, blockpos, CollisionContext.m_82749_()) || ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)blockpos), (Direction)Direction.UP)) continue;
                        world.m_46597_(blockpos, blockstate);
                        world.m_186460_(blockpos, Blocks.f_50449_, Mth.m_216271_((RandomSource)player.m_217043_(), (int)60, (int)120));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void IceCubeInmune(LivingHurtEvent event) {
        Optional stack0;
        Player player;
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_5833_() && event.getEntity() == player && (stack0 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.ICE_CUBE.get())).isPresent() && config.inmuneToFreezing && event.getSource().m_276093_(DamageTypes.f_268444_)) {
            event.setCanceled(true);
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.ICE_CUBE.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.ice_cube_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.ice_cube_1", (Object[])new Object[]{config.slownessLevel + 1, config.slownessTime / 20}).m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.ice_cube_2").m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public int slownessTime = 200;
        public int slownessLevel = 1;
        public int frostWalkerLevel = 3;
        public boolean isEnable = true;
        public boolean inmuneToFreezing = true;
    }
}

