/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import com.cozary.nameless_trinkets.utils.ConfigurationHandler;
import com.cozary.nameless_trinkets.utils.EntityUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class GodsCrown
extends TrinketItem<Stats>
implements ICurioItem {
    private static final String PREFIX = "nameless_trinkets:gods_crown_";
    public static GodsCrown INSTANCE;
    private final Map<String, MutablePair<String, UUID>> modifiers = new HashMap<String, MutablePair<String, UUID>>();

    public GodsCrown() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
        this.initModifiers();
    }

    @SubscribeEvent
    public static void onFOVUpdate(ComputeFovModifierEvent event) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        Optional stack1 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.CRACKED_CROWN.get());
        if (stack1.isPresent() && !((Boolean)ConfigurationHandler.SPAWN.disable.get()).booleanValue()) {
            event.setNewFovModifier(1.0f);
        }
    }

    private void initModifiers() {
        this.modifiers.put("max_health", (MutablePair<String, UUID>)new MutablePair((Object)"nameless_trinkets:gods_crown_max_health", (Object)UUID.randomUUID()));
        this.modifiers.put("movement_speed", (MutablePair<String, UUID>)new MutablePair((Object)"nameless_trinkets:gods_crown_movement_speed", (Object)UUID.randomUUID()));
        this.modifiers.put("flying_speed", (MutablePair<String, UUID>)new MutablePair((Object)"nameless_trinkets:gods_crown_flying_speed", (Object)UUID.randomUUID()));
        this.modifiers.put("attack_damage", (MutablePair<String, UUID>)new MutablePair((Object)"nameless_trinkets:gods_crown_attack_damage", (Object)UUID.randomUUID()));
        this.modifiers.put("armor", (MutablePair<String, UUID>)new MutablePair((Object)"nameless_trinkets:gods_crown_armor", (Object)UUID.randomUUID()));
        this.modifiers.put("attack_speed", (MutablePair<String, UUID>)new MutablePair((Object)"nameless_trinkets:gods_crown_attack_speed", (Object)UUID.randomUUID()));
        this.modifiers.put("armor_thougness", (MutablePair<String, UUID>)new MutablePair((Object)"nameless_trinkets:gods_crown_armor_thougness", (Object)UUID.randomUUID()));
        this.modifiers.put("attack_knockback", (MutablePair<String, UUID>)new MutablePair((Object)"nameless_trinkets:gods_crown_attack_knockback", (Object)UUID.randomUUID()));
        this.modifiers.put("knockback_resistance", (MutablePair<String, UUID>)new MutablePair((Object)"nameless_trinkets:gods_crown_knockback_resistance", (Object)UUID.randomUUID()));
        this.modifiers.put("luck", (MutablePair<String, UUID>)new MutablePair((Object)"nameless_trinkets:gods_crown_luck", (Object)UUID.randomUUID()));
        this.modifiers.put("swim_speed", (MutablePair<String, UUID>)new MutablePair((Object)"nameless_trinkets:gods_crown_swim_speed", (Object)UUID.randomUUID()));
        this.modifiers.put("block_reach", (MutablePair<String, UUID>)new MutablePair((Object)"nameless_trinkets:gods_crown_block_reach", (Object)UUID.randomUUID()));
        this.modifiers.put("entity_reach", (MutablePair<String, UUID>)new MutablePair((Object)"nameless_trinkets:gods_crown_entity_reach", (Object)UUID.randomUUID()));
        this.modifiers.put("step_height_addition", (MutablePair<String, UUID>)new MutablePair((Object)"nameless_trinkets:gods_crown_step_height_addition", (Object)UUID.randomUUID()));
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.GODS_CROWN.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.gods_crown_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                if ((config.percentageExtraAttack + config.percentageExtraAttackKnockback + config.percentageExtraAttackSpeed + config.percentageExtraMaxHealth + config.percentageExtraSpeed) / 5.0 == 120.0) {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.gods_crown_1").m_130940_(ChatFormatting.GOLD));
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.gods_crown_2").m_130940_(ChatFormatting.GOLD));
                }
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(slotContext.entity() instanceof Player)) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        Level world = livingEntity.m_20193_();
        if (world.m_5776_() || livingEntity.f_19797_ % 20 != 0) {
            return;
        }
        this.applyModifiers(livingEntity, config);
    }

    private void applyModifiers(LivingEntity livingEntity, Stats config) {
        for (Map.Entry<String, MutablePair<String, UUID>> entry : this.modifiers.entrySet()) {
            String key = entry.getKey();
            MutablePair<String, UUID> modifierData = entry.getValue();
            AttributeInstance attribute = this.getAttribute(livingEntity, key);
            if (attribute == null) continue;
            AttributeModifier modifier = this.createAttributeModifier(modifierData, config, key);
            EntityUtils.applyAttributeModifier(attribute, modifier);
        }
    }

    private AttributeInstance getAttribute(LivingEntity entity, String key) {
        return switch (key) {
            case "max_health" -> entity.m_21051_(Attributes.f_22276_);
            case "movement_speed" -> entity.m_21051_(Attributes.f_22279_);
            case "flying_speed" -> entity.m_21051_(Attributes.f_22280_);
            case "attack_damage" -> entity.m_21051_(Attributes.f_22281_);
            case "armor" -> entity.m_21051_(Attributes.f_22284_);
            case "attack_speed" -> entity.m_21051_(Attributes.f_22283_);
            case "armor_thougness" -> entity.m_21051_(Attributes.f_22285_);
            case "attack_knockback" -> entity.m_21051_(Attributes.f_22282_);
            case "knockback_resistance" -> entity.m_21051_(Attributes.f_22278_);
            case "luck" -> entity.m_21051_(Attributes.f_22286_);
            case "swim_speed" -> entity.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
            case "block_reach" -> entity.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get());
            case "entity_reach" -> entity.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get());
            case "step_height_addition" -> entity.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
            default -> null;
        };
    }

    private AttributeModifier createAttributeModifier(MutablePair<String, UUID> modifierData, Stats config, String key) {
        double percentage = this.getPercentageForKey(config, key);
        return new AttributeModifier((UUID)modifierData.getRight(), (String)modifierData.getLeft(), percentage / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    private double getPercentageForKey(Stats config, String key) {
        switch (key) {
            case "max_health": {
                return config.percentageExtraMaxHealth;
            }
            case "movement_speed": {
                return config.percentageExtraSpeed;
            }
            case "flying_speed": {
                return config.percentageExtraFlySpeed;
            }
            case "attack_damage": {
                return config.percentageExtraAttack;
            }
            case "armor": {
                return config.percentageExtraArmor;
            }
            case "attack_speed": {
                return config.percentageExtraAttackSpeed;
            }
            case "armor_thougness": {
                return config.percentageExtraArmorThougness;
            }
            case "attack_knockback": {
                return config.percentageExtraAttackKnockback;
            }
            case "knockback_resistance": {
                return config.percentageExtraKnockbackResistance;
            }
            case "luck": {
                return config.percentageExtraLuck;
            }
            case "swim_speed": {
                return config.percentageExtraSwimSpeed;
            }
            case "block_reach": {
                return config.percentageExtraBlockReach;
            }
            case "entity_reach": {
                return config.percentageExtraEntityReach;
            }
            case "step_height_addition": {
                return config.percentageExtraStepHeightAddition;
            }
        }
        return 0.0;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable || !(slotContext.entity() instanceof Player)) {
            return;
        }
        this.removeModifiers(slotContext.getWearer(), config);
    }

    private void removeModifiers(LivingEntity wearer, Stats config) {
        for (Map.Entry<String, MutablePair<String, UUID>> entry : this.modifiers.entrySet()) {
            String key = entry.getKey();
            AttributeInstance attribute = this.getAttribute(wearer, key);
            if (attribute == null) continue;
            AttributeModifier modifier = this.createAttributeModifier(entry.getValue(), config, key);
            EntityUtils.removeAttributeModifier(attribute, modifier);
        }
    }

    public static class Stats
    extends TrinketsStats {
        public double percentageExtraMaxHealth = 120.0;
        public double percentageExtraSpeed = 120.0;
        public double percentageExtraFlySpeed = 0.0;
        public double percentageExtraAttack = 120.0;
        public double percentageExtraArmor = 120.0;
        public double percentageExtraAttackSpeed = 120.0;
        public double percentageExtraArmorThougness = 120.0;
        public double percentageExtraAttackKnockback = 120.0;
        public double percentageExtraKnockbackResistance = 120.0;
        public double percentageExtraLuck = 120.0;
        public double percentageExtraSwimSpeed = 0.0;
        public double percentageExtraBlockReach = 0.0;
        public double percentageExtraEntityReach = 0.0;
        public double percentageExtraStepHeightAddition = 0.0;
        public boolean isEnable = true;
    }
}

