/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class FourLeafClover
extends TrinketItem<Stats>
implements ICurioItem {
    public static FourLeafClover INSTANCE;

    public FourLeafClover() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    @SubscribeEvent
    public static void entityKilled(LivingDeathEvent event) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Optional stack0;
            Player player = (Player)entity;
            if (!player.m_9236_().f_46443_ && (stack0 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.FOUR_LEAF_CLOVER.get())).isPresent()) {
                Level level = player.m_9236_();
                LootTable loot = Objects.requireNonNull(level.m_7654_()).m_278653_().m_278676_(event.getEntity().m_6095_().m_20677_());
                LootParams context = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)event.getEntity().m_20183_())).m_287286_(LootContextParams.f_81455_, (Object)event.getEntity()).m_287286_(LootContextParams.f_81457_, (Object)player.m_269291_().m_269075_(player)).m_287235_(LootContextParamSets.f_81415_);
                ObjectArrayList drops = loot.m_287195_(context);
                for (int i = 1; i < config.extraLoots; ++i) {
                    for (ItemStack drop : drops) {
                        ItemEntity itementity = new ItemEntity(level, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), drop);
                        itementity.m_32060_();
                        itementity.m_20256_(itementity.m_20184_().m_82520_((double)((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.1f), (double)(level.f_46441_.m_188501_() * 0.05f), (double)((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.1f)));
                        level.m_7967_((Entity)itementity);
                    }
                }
            }
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.FOUR_LEAF_CLOVER.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.four_leaf_clover_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.four_leaf_clover_1", (Object[])new Object[]{config.extraLoots}).m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public int extraLoots = 2;
        public boolean isEnable = true;
    }
}

