/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.special;

import com.cozary.nameless_trinkets.init.ModTags;
import com.cozary.nameless_trinkets.utils.ConfigurationHandler;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;

public class MysteriousTrinket
extends Item {
    private final MutablePair<String, UUID> MysteriousTrinket_MOD = new MutablePair((Object)"nameless_trinkets:more_trinkets", (Object)UUID.randomUUID());

    public MysteriousTrinket() {
        super(new Item.Properties().m_41497_(Rarity.EPIC).m_41487_(64));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Random random = new Random();
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12639_, SoundSource.NEUTRAL, 0.5f, 0.4f / (player.m_217043_().m_188501_() * 0.4f + 0.8f));
        if (!level.f_46443_) {
            List trinketItems = BuiltInRegistries.f_257033_.m_203561_(ModTags.NAMELESS_TRINKETS_TAG).m_203614_().toList();
            Item selectedTrinket = (Item)((Holder)trinketItems.get(random.nextInt(trinketItems.size()))).get();
            BlockPos playerPos = player.m_20097_();
            if (selectedTrinket != null) {
                ServerLevel serverLevel = (ServerLevel)player.m_20193_();
                this.spawnParticles(serverLevel, player);
                this.spawnItemEntity((Level)serverLevel, selectedTrinket, playerPos);
                this.maybeAddTrinketSlot(player, random);
            }
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    private void spawnParticles(ServerLevel serverLevel, Player player) {
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 100, 1.0, 1.0, 1.0, 0.1);
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 100, 1.0, 1.0, 1.0, 0.1);
    }

    private void spawnItemEntity(Level level, Item trinketItem, BlockPos pos) {
        ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), trinketItem.m_7968_());
        itemEntity.m_32060_();
        level.m_7967_((Entity)itemEntity);
    }

    private void maybeAddTrinketSlot(Player player, Random random) {
        if (random.nextInt(100) <= (Integer)ConfigurationHandler.SPAWN.slot_probability.get()) {
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> handler.getStacksHandler("trinkets").ifPresent(stacks -> {
                int maxSlots = (Integer)ConfigurationHandler.SPAWN.slots.get();
                if (stacks.getSlots() < maxSlots) {
                    stacks.addPermanentModifier(new AttributeModifier((UUID)this.MysteriousTrinket_MOD.getRight(), (String)this.MysteriousTrinket_MOD.getLeft(), (double)Math.min(maxSlots, stacks.getSlots() + 1), AttributeModifier.Operation.ADDITION));
                }
            }));
        }
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.mysterious_trinket_1").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.mysterious_trinket_2").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.mysterious_trinket_3", (Object[])new Object[]{Component.m_237115_((String)((Integer)ConfigurationHandler.SPAWN.slot_probability.get()).toString())}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.mysterious_trinket_4", (Object[])new Object[]{Component.m_237115_((String)((Integer)ConfigurationHandler.SPAWN.slotsQuantity.get()).toString())}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }
}

