/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigHelper {
    private static final Gson serializer = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    private static final Path rootPath = FMLPaths.CONFIGDIR.get().resolve("nameless_trinkets");

    public static void createJSONConfig(Path path, Object source) {
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            serializer.toJson(source, (Appendable)writer);
            ((Writer)writer).flush();
        }
    }

    @Nullable
    public static Object readJSONConfig(Path path, Type target) {
        Object result;
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            result = serializer.fromJson((Reader)reader, target);
        }
        return result;
    }

    public static Gson getSerializer() {
        return serializer;
    }

    public static Path getRootPath() {
        return rootPath;
    }
}

