/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetdevice;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.ItemBaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import com.supermartijn642.core.gui.widget.premade.LabelWidget;
import com.supermartijn642.core.gui.widget.premade.TextFieldWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.portal.screen.ScreenBlockRenderer;
import com.supermartijn642.wormhole.screen.WormholeColoredButton;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceAddPacket;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceRemovePacket;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class TargetDeviceScreen
extends ItemBaseWidget {
    private static final ResourceLocation BACKGROUND = TargetDeviceScreen.getTexture("select_target_screen/device_background");
    private static final ResourceLocation SELECT_HIGHLIGHT = TargetDeviceScreen.getTexture("select_target_screen/device_select_highlight");
    private static final ResourceLocation HOVER_HIGHLIGHT = TargetDeviceScreen.getTexture("select_target_screen/device_hover_highlight");
    private static final ResourceLocation LOCATION_ICON = TargetDeviceScreen.getTexture("select_target_screen/location_icon");
    private static final ResourceLocation ENERGY_ICON = TargetDeviceScreen.getTexture("select_target_screen/lightning_icon");
    private static final ResourceLocation DIMENSION_ICON = TargetDeviceScreen.getTexture("select_target_screen/dimension_icon");
    private static final ResourceLocation DIRECTION_ICON = TargetDeviceScreen.getTexture("select_target_screen/direction_icon");
    private static final ResourceLocation SEPARATOR = TargetDeviceScreen.getTexture("select_target_screen/separator");
    private static final int WIDTH = 324;
    private static final int HEIGHT = 185;
    private final InteractionHand hand;
    private final BlockPos currentPos;
    private final float currentYaw;
    private int selectedTarget;
    private boolean selectedCurrentTarget = false;
    private TextFieldWidget currentTargetNameField;
    private final List<LabelWidget> targetNameLabels = new LinkedList<LabelWidget>();
    private WormholeColoredButton removeButton;

    private static ResourceLocation getTexture(String name) {
        return new ResourceLocation("wormhole", "textures/gui/" + name + ".png");
    }

    public TargetDeviceScreen(InteractionHand hand, BlockPos pos, float yaw) {
        super(0, 0, 324, 185, hand, stack -> stack.m_41720_() instanceof TargetDeviceItem);
        this.hand = hand;
        this.currentPos = pos;
        this.currentYaw = yaw;
        this.selectedTarget = this.getOrDefault(list -> {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null) continue;
                return i;
            }
            return -1;
        }, -1);
        if (this.selectedTarget == -1) {
            this.selectedCurrentTarget = true;
        }
    }

    protected Component getNarrationMessage(ItemStack object) {
        return TextComponents.translation((String)"wormhole.target_device.gui.title").get();
    }

    protected void addWidgets(ItemStack stack) {
        int targetCapacity = TargetDeviceItem.getMaxTargetCount(stack);
        int count = 0;
        while (count < Math.min(10, targetCapacity)) {
            int index = count++;
            int y = 18 + index * 16;
            this.targetNameLabels.add((LabelWidget)this.addWidget((Widget)new LabelWidget(7, y, 102, 12, () -> TextComponents.string((String)this.getOrDefault(list -> list.size() > index ? ((PortalTarget)list.get((int)index)).name : "", "")).get())));
        }
        this.currentTargetNameField = (TextFieldWidget)this.addWidget((Widget)new TextFieldWidget(215, 18, 102, 12, "", 10));
        this.currentTargetNameField.setSuggestion(TextComponents.translation((String)"wormhole.target_device.gui.target_name").format());
        if (this.selectedCurrentTarget) {
            this.currentTargetNameField.setFocused(true);
        }
        this.removeButton = (WormholeColoredButton)this.addWidget((Widget)new WormholeColoredButton(131, 160, 62, 11, (Component)TextComponents.empty().get(), () -> {
            if (this.selectedTarget >= 0) {
                Wormhole.CHANNEL.sendToServer((BasePacket)new TargetDeviceRemovePacket(this.hand, this.selectedTarget));
            } else if (this.selectedCurrentTarget) {
                Wormhole.CHANNEL.sendToServer((BasePacket)new TargetDeviceAddPacket(this.hand, this.currentTargetNameField.getText().trim(), this.currentPos, this.currentYaw));
            }
        }));
    }

    protected void renderBackground(WidgetRenderContext context, int mouseX, int mouseY, ItemStack object) {
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)0.0f, (float)0.0f, (float)this.width(), (float)this.height());
        if (this.selectedTarget >= 0) {
            ScreenUtils.bindTexture((ResourceLocation)SELECT_HIGHLIGHT);
            ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)5.0f, (float)(16 + 16 * this.selectedTarget), (float)106.0f, (float)16.0f);
        } else if (this.selectedCurrentTarget) {
            ScreenUtils.bindTexture((ResourceLocation)SELECT_HIGHLIGHT);
            ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)213.0f, (float)16.0f, (float)106.0f, (float)16.0f);
        }
        super.renderBackground(context, mouseX, mouseY, (Object)object);
    }

    protected void renderForeground(WidgetRenderContext context, int mouseX, int mouseY, ItemStack object) {
        super.renderForeground(context, mouseX, mouseY, (Object)object);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"wormhole.target_device.gui.title").get(), (float)58.0f, (float)3.0f, (int)Integer.MAX_VALUE);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"wormhole.target_device.gui.current_location").get(), (float)266.0f, (float)3.0f, (int)Integer.MAX_VALUE);
        if (mouseX > 5 && mouseX < 111 && mouseY > 16 && mouseY < 176) {
            int targetIndex = (mouseY - 16) / 16;
            if (this.getOrDefault(list -> list.size() > targetIndex && list.get(targetIndex) != null, false).booleanValue()) {
                ScreenUtils.bindTexture((ResourceLocation)HOVER_HIGHLIGHT);
                ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)5.0f, (float)(16 + targetIndex * 16), (float)106.0f, (float)16.0f);
            }
        } else if (mouseX > 213 && mouseX < 319 && mouseY > 16 && mouseY < 32) {
            ScreenUtils.bindTexture((ResourceLocation)HOVER_HIGHLIGHT);
            ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)213.0f, (float)16.0f, (float)106.0f, (float)16.0f);
        }
        if (this.selectedTarget >= 0) {
            PortalTarget target = this.getOrDefault(list -> list.size() > this.selectedTarget ? (PortalTarget)list.get(this.selectedTarget) : null, null);
            if (target != null) {
                this.renderTargetInfo(context.poseStack(), target.name, target.getPos(), target.dimension, target.dimensionDisplayName, target.yaw);
            }
        } else if (this.selectedCurrentTarget) {
            ResourceKey dimension = ClientUtils.getWorld().m_46472_();
            this.renderTargetInfo(context.poseStack(), this.currentTargetNameField.getText().trim(), this.currentPos, (ResourceKey<Level>)dimension, (Component)TextComponents.dimension((ResourceKey)dimension).get(), this.currentYaw);
        }
        this.updateAddRemoveButton();
    }

    private void renderTargetInfo(PoseStack poseStack, String name, BlockPos pos, ResourceKey<Level> dimension, Component dimensionName, float yaw) {
        ScreenUtils.drawCenteredString((PoseStack)poseStack, (String)name, (float)162.0f, (float)31.0f, (int)Integer.MAX_VALUE);
        ScreenUtils.bindTexture((ResourceLocation)SEPARATOR);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)124.0f, (float)41.0f, (float)77.0f, (float)1.0f);
        ScreenUtils.bindTexture((ResourceLocation)LOCATION_ICON);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)121.0f, (float)47.0f, (float)9.0f, (float)9.0f);
        ScreenUtils.drawString((PoseStack)poseStack, (String)("(" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + ")"), (float)132.0f, (float)48.0f, (int)Integer.MAX_VALUE);
        Block block = null;
        if (dimension.equals((Object)Level.f_46428_)) {
            block = Blocks.f_152481_;
        } else if (dimension.equals((Object)Level.f_46429_)) {
            block = Blocks.f_50134_;
        } else if (dimension.equals((Object)Level.f_46430_)) {
            block = Blocks.f_50259_;
        }
        if (block == null) {
            ScreenUtils.bindTexture((ResourceLocation)DIMENSION_ICON);
            ScreenUtils.drawTexture((PoseStack)poseStack, (float)121.0f, (float)59.0f, (float)9.0f, (float)9.0f);
        } else {
            ScreenBlockRenderer.drawBlock(poseStack, block, 125.5, 63.5, 5.5, 45.0f, 40.0f);
        }
        ScreenUtils.drawString((PoseStack)poseStack, (Component)dimensionName, (float)132.0f, (float)60.0f, (int)Integer.MAX_VALUE);
        ScreenUtils.bindTexture((ResourceLocation)DIRECTION_ICON);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)119.0f, (float)69.0f, (float)13.0f, (float)13.0f);
        ScreenUtils.drawString((PoseStack)poseStack, (Component)TextComponents.translation((String)("wormhole.direction." + Direction.m_122364_((double)yaw))).get(), (float)132.0f, (float)72.0f, (int)Integer.MAX_VALUE);
    }

    public void renderTooltips(WidgetRenderContext context, int mouseX, int mouseY, ItemStack object) {
        if (mouseX >= 120 && mouseX <= 131 && mouseY >= 46 && mouseY <= 57) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"wormhole.target.location").get(), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 120 && mouseX <= 131 && mouseY >= 58 && mouseY <= 69) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"wormhole.target.dimension").get(), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 120 && mouseX <= 131 && mouseY >= 70 && mouseY <= 81) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"wormhole.target.direction").get(), (int)mouseX, (int)mouseY);
        }
    }

    private void updateAddRemoveButton() {
        if (this.selectedTarget >= 0) {
            boolean notEmpty = this.getOrDefault(list -> list.size() > this.selectedTarget && list.get(this.selectedTarget) != null, false);
            this.removeButton.setVisible();
            this.removeButton.setColorRed();
            this.removeButton.setText((Component)TextComponents.translation((String)"wormhole.portal.targets.gui.remove").get());
            this.removeButton.setActive(notEmpty);
        } else if (this.selectedCurrentTarget) {
            boolean notEmpty = !this.currentTargetNameField.getText().trim().isEmpty();
            boolean space = this.getOrDefault(list -> {
                if (list.size() < TargetDeviceItem.getMaxTargetCount((ItemStack)this.object)) {
                    return true;
                }
                for (PortalTarget target : list) {
                    if (target != null) continue;
                    return true;
                }
                return false;
            }, false);
            this.removeButton.setVisible();
            this.removeButton.setColorWhite();
            this.removeButton.setText((Component)TextComponents.translation((String)"wormhole.portal.targets.gui.add").get());
            this.removeButton.setActive(notEmpty && space);
        } else {
            this.removeButton.setInvisible();
        }
    }

    public <T> T getOrDefault(Function<List<PortalTarget>, T> function, T other) {
        if (this.validateObjectOrClose()) {
            return function.apply(TargetDeviceItem.getTargets((ItemStack)this.object));
        }
        return other;
    }

    protected boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled, ItemStack object) {
        hasBeenHandled |= super.mousePressed(mouseX, mouseY, button, hasBeenHandled, (Object)object);
        if (button == 0) {
            if (mouseX > 5 && mouseX < 111 && mouseY > 16 && mouseY < 176) {
                int targetIndex = (mouseY - 16) / 16;
                if (this.getOrDefault(list -> list.size() > targetIndex && list.get(targetIndex) != null, false).booleanValue()) {
                    AbstractButtonWidget.playClickSound();
                    this.selectedTarget = targetIndex;
                    this.selectedCurrentTarget = false;
                }
                return true;
            }
            if (mouseX > 213 && mouseX < 319 && mouseY > 16 && mouseY < 32) {
                AbstractButtonWidget.playClickSound();
                this.selectedTarget = -1;
                this.selectedCurrentTarget = true;
                return true;
            }
        }
        return hasBeenHandled;
    }
}

