/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;

public class ScreenBlockRenderer {
    public static void drawBlock(PoseStack poseStack, Block block, double x, double y, double scale, float yaw, float pitch) {
        BlockState state = block.m_49966_();
        poseStack.m_85836_();
        poseStack.m_85837_(x, y, 350.0);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        Lighting.m_84930_();
        poseStack.m_252781_(new Quaternionf().setAngleAxis((double)(pitch / 180.0f) * Math.PI, 1.0, 0.0, 0.0));
        poseStack.m_252781_(new Quaternionf().setAngleAxis((double)(yaw / 180.0f) * Math.PI, 0.0, 1.0, 0.0));
        BakedModel model = ClientUtils.getBlockRenderer().m_110910_(state);
        ModelData modelData = ModelData.EMPTY;
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        for (RenderType renderType : model.getRenderTypes(state, RandomSource.m_216335_((long)42L), modelData)) {
            ScreenBlockRenderer.renderModel(model, state, poseStack, bufferSource.m_6299_(renderType), modelData, renderType);
        }
        bufferSource.m_109911_();
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
        Lighting.m_84931_();
    }

    private static void renderModel(BakedModel model, BlockState state, PoseStack poseStack, VertexConsumer buffer, ModelData modelData, RenderType renderType) {
        RandomSource random = RandomSource.m_216327_();
        for (Direction direction : Direction.values()) {
            random.m_188584_(42L);
            ScreenBlockRenderer.renderQuads(poseStack, buffer, model.getQuads(state, direction, random, modelData, renderType));
        }
        random.m_188584_(42L);
        ScreenBlockRenderer.renderQuads(poseStack, buffer, model.getQuads(state, null, random, modelData, renderType));
    }

    private static void renderQuads(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads) {
        PoseStack.Pose matrix = poseStack.m_85850_();
        for (BakedQuad bakedquad : quads) {
            buffer.putBulkData(matrix, bakedquad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, false);
        }
    }
}

