/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal;

import com.google.common.collect.Lists;
import com.supermartijn642.wormhole.PortalBlock;
import com.supermartijn642.wormhole.StabilizerBlockEntity;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.portal.IEnergyCellEntity;
import com.supermartijn642.wormhole.portal.IPortalGroupEntity;
import com.supermartijn642.wormhole.portal.ITargetCellEntity;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class PortalShape {
    public static final Map<Direction.Axis, List<BlockPos>> DIRECT_OFFSETS = new EnumMap<Direction.Axis, List<BlockPos>>(Direction.Axis.class);
    private static final Map<Direction.Axis, List<BlockPos>> INDIRECT_OFFSETS = new EnumMap<Direction.Axis, List<BlockPos>>(Direction.Axis.class);
    private static final Map<Direction.Axis, List<BlockPos>> ALL_OFFSETS = new EnumMap<Direction.Axis, List<BlockPos>>(Direction.Axis.class);
    public final Direction.Axis axis;
    public final List<BlockPos> area = new ArrayList<BlockPos>();
    public final List<BlockPos> frame = new ArrayList<BlockPos>();
    public final List<BlockPos> stabilizers = new ArrayList<BlockPos>();
    public final List<BlockPos> energyCells = new ArrayList<BlockPos>();
    public final List<BlockPos> targetCells = new ArrayList<BlockPos>();
    public final double span;
    public final BlockPos minCorner;
    public final BlockPos maxCorner;

    public static PortalShape find(BlockGetter level, BlockPos center) {
        for (Direction.Axis axis : Direction.Axis.values()) {
            PortalShape shape = PortalShape.find(level, center, axis);
            if (shape == null) continue;
            return shape;
        }
        return null;
    }

    private static PortalShape find(BlockGetter level, BlockPos center, Direction.Axis axis) {
        for (BlockPos offset : ALL_OFFSETS.get(axis)) {
            PortalShape shape;
            Block offsetBlock = level.m_8055_(center.m_121955_((Vec3i)offset)).m_60734_();
            if (!offsetBlock.m_49966_().m_60795_() && offsetBlock != Blocks.f_49990_ || (shape = PortalShape.findArea(level, center.m_121955_((Vec3i)offset), axis)) == null) continue;
            return shape;
        }
        return null;
    }

    private static PortalShape findArea(BlockGetter level, BlockPos start, Direction.Axis axis) {
        LinkedList<BlockPos> next = new LinkedList<BlockPos>();
        LinkedList<BlockPos> current = new LinkedList<BlockPos>();
        current.add(start);
        ArrayList<BlockPos> done = new ArrayList<BlockPos>();
        ArrayList<BlockPos> frame = new ArrayList<BlockPos>();
        ArrayList<BlockPos> corners = new ArrayList<BlockPos>();
        ArrayList<BlockPos> stabilizers = new ArrayList<BlockPos>();
        ArrayList<BlockPos> energyCells = new ArrayList<BlockPos>();
        ArrayList<BlockPos> targetCells = new ArrayList<BlockPos>();
        while (!current.isEmpty()) {
            for (BlockPos pos : current) {
                int frames = 0;
                for (BlockPos offset : DIRECT_OFFSETS.get(axis)) {
                    BlockPos offPos = pos.m_121955_((Vec3i)offset);
                    BlockState state = level.m_8055_(offPos);
                    BlockEntity entity = level.m_7702_(offPos);
                    if (state.m_60795_() || state.m_60734_() == Blocks.f_49990_) {
                        if (done.contains(offPos) || current.contains(offPos) || next.contains(offPos)) continue;
                        next.add(offPos);
                        continue;
                    }
                    if (entity instanceof IPortalGroupEntity && !((IPortalGroupEntity)entity).hasGroup()) {
                        if (!frame.contains(offPos)) {
                            frame.add(offPos);
                            if (entity instanceof StabilizerBlockEntity) {
                                stabilizers.add(offPos);
                            }
                            if (entity instanceof IEnergyCellEntity) {
                                energyCells.add(offPos);
                            }
                            if (entity instanceof ITargetCellEntity) {
                                targetCells.add(offPos);
                            }
                        }
                        ++frames;
                        continue;
                    }
                    return null;
                }
                if (frames < 2) continue;
                corners.add(pos);
            }
            if (done.size() + current.size() + next.size() > WormholeConfig.maxPortalSize.get()) {
                return null;
            }
            done.addAll(current);
            current.clear();
            current.addAll(next);
            next.clear();
        }
        if (WormholeConfig.requireCorners.get().booleanValue()) {
            if (!PortalShape.validateCorners(level, done, frame, corners, stabilizers, energyCells, targetCells, axis)) {
                return null;
            }
        } else {
            PortalShape.collectCorners(level, done, frame, corners, stabilizers, energyCells, targetCells, axis);
        }
        if (stabilizers.size() == 0) {
            return null;
        }
        return new PortalShape(axis, done, frame, stabilizers, energyCells, targetCells);
    }

    private static void collectCorners(BlockGetter level, List<BlockPos> area, List<BlockPos> frame, List<BlockPos> corners, List<BlockPos> stabilizers, List<BlockPos> energyCells, List<BlockPos> targetCells, Direction.Axis axis) {
        BlockPos dir1pos = axis == Direction.Axis.Y ? BlockPos.f_121853_.m_122029_() : BlockPos.f_121853_.m_7494_();
        BlockPos dir1neg = axis == Direction.Axis.Y ? BlockPos.f_121853_.m_122024_() : BlockPos.f_121853_.m_7495_();
        BlockPos dir2pos = axis == Direction.Axis.Z ? BlockPos.f_121853_.m_122029_() : BlockPos.f_121853_.m_122012_();
        BlockPos dir2neg = axis == Direction.Axis.Z ? BlockPos.f_121853_.m_122024_() : BlockPos.f_121853_.m_122019_();
        for (BlockPos corner : corners) {
            PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2pos);
            PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2neg);
            PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2pos);
            PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2neg);
        }
    }

    private static boolean validateCorners(BlockGetter level, List<BlockPos> area, List<BlockPos> frame, List<BlockPos> corners, List<BlockPos> stabilizers, List<BlockPos> energyCells, List<BlockPos> targetCells, Direction.Axis axis) {
        BlockPos dir1pos = axis == Direction.Axis.Y ? BlockPos.f_121853_.m_122029_() : BlockPos.f_121853_.m_7494_();
        BlockPos dir1neg = axis == Direction.Axis.Y ? BlockPos.f_121853_.m_122024_() : BlockPos.f_121853_.m_7495_();
        BlockPos dir2pos = axis == Direction.Axis.Z ? BlockPos.f_121853_.m_122029_() : BlockPos.f_121853_.m_122012_();
        BlockPos dir2neg = axis == Direction.Axis.Z ? BlockPos.f_121853_.m_122024_() : BlockPos.f_121853_.m_122019_();
        for (BlockPos corner : corners) {
            if (!PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2pos)) {
                return false;
            }
            if (!PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2neg)) {
                return false;
            }
            if (!PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2pos)) {
                return false;
            }
            if (PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2neg)) continue;
            return false;
        }
        return true;
    }

    private static boolean collectCorner(BlockGetter level, List<BlockPos> area, List<BlockPos> frame, List<BlockPos> stabilizers, List<BlockPos> energyCells, List<BlockPos> targetCells, BlockPos corner, BlockPos dir1, BlockPos dir2) {
        if (frame.contains(corner.m_121955_((Vec3i)dir1)) && frame.contains(corner.m_121955_((Vec3i)dir2))) {
            BlockPos pos = corner.m_121955_((Vec3i)dir1).m_121955_((Vec3i)dir2);
            BlockEntity entity = level.m_7702_(pos);
            if (entity instanceof IPortalGroupEntity ? ((IPortalGroupEntity)entity).hasGroup() : !area.contains(pos)) {
                return false;
            }
            if (!frame.contains(pos)) {
                frame.add(pos);
                if (entity instanceof StabilizerBlockEntity) {
                    stabilizers.add(pos);
                }
                if (entity instanceof IEnergyCellEntity) {
                    energyCells.add(pos);
                }
                if (entity instanceof ITargetCellEntity) {
                    targetCells.add(pos);
                }
            }
        }
        return true;
    }

    public PortalShape(Direction.Axis axis, List<BlockPos> area, List<BlockPos> frame, List<BlockPos> stabilizers, List<BlockPos> energyCells, List<BlockPos> targetCells) {
        this.axis = axis;
        this.area.addAll(area);
        this.frame.addAll(frame);
        this.stabilizers.addAll(stabilizers);
        this.energyCells.addAll(energyCells);
        this.targetCells.addAll(targetCells);
        double span = 0.0;
        int minX = frame.get(0).m_123341_();
        int minY = frame.get(0).m_123342_();
        int minZ = frame.get(0).m_123343_();
        int maxX = frame.get(0).m_123341_();
        int maxY = frame.get(0).m_123342_();
        int maxZ = frame.get(0).m_123343_();
        for (int i = 0; i < frame.size(); ++i) {
            BlockPos pos1 = frame.get(i);
            for (int j = i + 1; j < frame.size(); ++j) {
                BlockPos pos2 = frame.get(j);
                double distance = pos1.m_123331_((Vec3i)pos2);
                if (!(distance > span)) continue;
                span = distance;
            }
            if (pos1.m_123341_() < minX) {
                minX = pos1.m_123341_();
            }
            if (pos1.m_123342_() < minY) {
                minY = pos1.m_123342_();
            }
            if (pos1.m_123343_() < minZ) {
                minZ = pos1.m_123343_();
            }
            if (pos1.m_123341_() > maxX) {
                maxX = pos1.m_123341_();
            }
            if (pos1.m_123342_() > maxY) {
                maxY = pos1.m_123342_();
            }
            if (pos1.m_123343_() <= maxZ) continue;
            maxZ = pos1.m_123343_();
        }
        this.span = Math.sqrt((maxX - minX + 1) * (maxX - minX + 1) + (maxY - minY + 1) * (maxY - minY + 1) + (maxZ - minZ + 1) * (maxZ - minZ + 1));
        this.minCorner = new BlockPos(minX, minY, minZ);
        this.maxCorner = new BlockPos(maxX, maxY, maxZ);
    }

    public PortalShape(CompoundTag tag) {
        this.axis = Enum.valueOf(Direction.Axis.class, tag.m_128461_("axis"));
        if (tag.m_128425_("area", 10)) {
            CompoundTag areaTag = tag.m_128469_("area");
            for (int i = 0; i < areaTag.m_128440_(); ++i) {
                CompoundTag pos = areaTag.m_128469_("" + i);
                this.area.add(new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z")));
            }
            CompoundTag frameTag = tag.m_128469_("frame");
            for (int i = 0; i < areaTag.m_128440_(); ++i) {
                CompoundTag pos = frameTag.m_128469_("" + i);
                this.frame.add(new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z")));
            }
            CompoundTag stabilizerTag = tag.m_128469_("stabilizers");
            for (int i = 0; i < areaTag.m_128440_(); ++i) {
                CompoundTag pos = stabilizerTag.m_128469_("" + i);
                this.stabilizers.add(new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z")));
            }
            CompoundTag energyCellsTag = tag.m_128469_("energyCells");
            for (int i = 0; i < areaTag.m_128440_(); ++i) {
                CompoundTag pos = energyCellsTag.m_128469_("" + i);
                this.energyCells.add(new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z")));
            }
            CompoundTag targetCellsTag = tag.m_128469_("targetCells");
            for (int i = 0; i < areaTag.m_128440_(); ++i) {
                CompoundTag pos = targetCellsTag.m_128469_("" + i);
                this.targetCells.add(new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z")));
            }
        } else {
            int[] area = tag.m_128465_("area");
            for (int i = 0; i < area.length / 3; ++i) {
                this.area.add(new BlockPos(area[i * 3], area[i * 3 + 1], area[i * 3 + 2]));
            }
            int[] frame = tag.m_128465_("frame");
            for (int i = 0; i < frame.length / 3; ++i) {
                this.frame.add(new BlockPos(frame[i * 3], frame[i * 3 + 1], frame[i * 3 + 2]));
            }
            int[] stabilizers = tag.m_128465_("stabilizers");
            for (int i = 0; i < stabilizers.length / 3; ++i) {
                this.stabilizers.add(new BlockPos(stabilizers[i * 3], stabilizers[i * 3 + 1], stabilizers[i * 3 + 2]));
            }
            int[] energyCells = tag.m_128465_("energyCells");
            for (int i = 0; i < energyCells.length / 3; ++i) {
                this.energyCells.add(new BlockPos(energyCells[i * 3], energyCells[i * 3 + 1], energyCells[i * 3 + 2]));
            }
            int[] targetCells = tag.m_128465_("targetCells");
            for (int i = 0; i < targetCells.length / 3; ++i) {
                this.targetCells.add(new BlockPos(targetCells[i * 3], targetCells[i * 3 + 1], targetCells[i * 3 + 2]));
            }
        }
        this.span = tag.m_128459_("span");
        this.minCorner = new BlockPos(tag.m_128451_("minCornerX"), tag.m_128451_("minCornerY"), tag.m_128451_("minCornerZ"));
        this.maxCorner = new BlockPos(tag.m_128451_("maxCornerX"), tag.m_128451_("maxCornerY"), tag.m_128451_("maxCornerZ"));
    }

    public void createPortals(Level level, DyeColor color) {
        if (color == null) {
            color = DyeColor.values()[new Random().nextInt(DyeColor.values().length)];
        }
        for (BlockPos pos : this.area) {
            BlockState state = level.m_8055_(pos);
            if (state.m_60734_() instanceof PortalBlock && state.m_61143_(PortalBlock.AXIS_PROPERTY) == this.axis && state.m_61143_(PortalBlock.COLOR_PROPERTY) == color) continue;
            boolean waterlogged = level.m_6425_(pos).m_76152_() == Fluids.f_76193_;
            level.m_46597_(pos, (BlockState)((BlockState)((BlockState)Wormhole.portal.m_49966_().m_61124_(PortalBlock.AXIS_PROPERTY, (Comparable)this.axis)).m_61124_(PortalBlock.COLOR_PROPERTY, (Comparable)color)).m_61124_((Property)PortalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)));
        }
    }

    public void destroyPortals(Level world) {
        for (BlockPos pos : this.area) {
            BlockState state = world.m_8055_(pos);
            if (!(state.m_60734_() instanceof PortalBlock)) continue;
            if (((Boolean)state.m_61143_((Property)PortalBlock.WATERLOGGED)).booleanValue()) {
                world.m_46597_(pos, Blocks.f_49990_.m_49966_());
                continue;
            }
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    public boolean validateFrame(BlockGetter world) {
        for (BlockPos pos : this.frame) {
            if (world.m_8055_(pos).m_60734_() instanceof IPortalGroupEntity) continue;
            return false;
        }
        return true;
    }

    public boolean validatePortal(BlockGetter world) {
        for (BlockPos pos : this.area) {
            BlockState state = world.m_8055_(pos);
            if (state.m_60734_() instanceof PortalBlock && state.m_61143_(PortalBlock.AXIS_PROPERTY) == this.axis || state.m_60795_() || state.m_60734_() == Blocks.f_49990_) continue;
            return false;
        }
        return true;
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("axis", this.axis.name());
        int[] areaData = new int[this.area.size() * 3];
        for (int i = 0; i < this.area.size(); ++i) {
            areaData[i * 3] = this.area.get(i).m_123341_();
            areaData[i * 3 + 1] = this.area.get(i).m_123342_();
            areaData[i * 3 + 2] = this.area.get(i).m_123343_();
        }
        tag.m_128385_("area", areaData);
        int[] frameData = new int[this.frame.size() * 3];
        for (int i = 0; i < this.frame.size(); ++i) {
            frameData[i * 3] = this.frame.get(i).m_123341_();
            frameData[i * 3 + 1] = this.frame.get(i).m_123342_();
            frameData[i * 3 + 2] = this.frame.get(i).m_123343_();
        }
        tag.m_128385_("frame", frameData);
        int[] stabilizersData = new int[this.stabilizers.size() * 3];
        for (int i = 0; i < this.stabilizers.size(); ++i) {
            stabilizersData[i * 3] = this.stabilizers.get(i).m_123341_();
            stabilizersData[i * 3 + 1] = this.stabilizers.get(i).m_123342_();
            stabilizersData[i * 3 + 2] = this.stabilizers.get(i).m_123343_();
        }
        tag.m_128385_("stabilizers", stabilizersData);
        int[] energyCellsData = new int[this.energyCells.size() * 3];
        for (int i = 0; i < this.energyCells.size(); ++i) {
            energyCellsData[i * 3] = this.energyCells.get(i).m_123341_();
            energyCellsData[i * 3 + 1] = this.energyCells.get(i).m_123342_();
            energyCellsData[i * 3 + 2] = this.energyCells.get(i).m_123343_();
        }
        tag.m_128385_("energyCells", energyCellsData);
        int[] targetCellsData = new int[this.targetCells.size() * 3];
        for (int i = 0; i < this.targetCells.size(); ++i) {
            targetCellsData[i * 3] = this.targetCells.get(i).m_123341_();
            targetCellsData[i * 3 + 1] = this.targetCells.get(i).m_123342_();
            targetCellsData[i * 3 + 2] = this.targetCells.get(i).m_123343_();
        }
        tag.m_128385_("targetCells", targetCellsData);
        tag.m_128347_("span", this.span);
        tag.m_128405_("minCornerX", this.minCorner.m_123341_());
        tag.m_128405_("minCornerY", this.minCorner.m_123342_());
        tag.m_128405_("minCornerZ", this.minCorner.m_123343_());
        tag.m_128405_("maxCornerX", this.maxCorner.m_123341_());
        tag.m_128405_("maxCornerY", this.maxCorner.m_123342_());
        tag.m_128405_("maxCornerZ", this.maxCorner.m_123343_());
        return tag;
    }

    public static PortalShape read(CompoundTag tag) {
        return new PortalShape(tag);
    }

    static {
        DIRECT_OFFSETS.put(Direction.Axis.X, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.f_121853_.m_7494_(), BlockPos.f_121853_.m_7495_(), BlockPos.f_121853_.m_122012_(), BlockPos.f_121853_.m_122019_()}));
        DIRECT_OFFSETS.put(Direction.Axis.Y, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.f_121853_.m_122012_(), BlockPos.f_121853_.m_122029_(), BlockPos.f_121853_.m_122019_(), BlockPos.f_121853_.m_122024_()}));
        DIRECT_OFFSETS.put(Direction.Axis.Z, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.f_121853_.m_7494_(), BlockPos.f_121853_.m_7495_(), BlockPos.f_121853_.m_122029_(), BlockPos.f_121853_.m_122024_()}));
        INDIRECT_OFFSETS.put(Direction.Axis.X, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.f_121853_.m_7494_().m_122012_(), BlockPos.f_121853_.m_7494_().m_122019_(), BlockPos.f_121853_.m_7495_().m_122012_(), BlockPos.f_121853_.m_7495_().m_122019_()}));
        INDIRECT_OFFSETS.put(Direction.Axis.Y, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.f_121853_.m_122012_().m_122029_(), BlockPos.f_121853_.m_122012_().m_122024_(), BlockPos.f_121853_.m_122019_().m_122029_(), BlockPos.f_121853_.m_122019_().m_122024_()}));
        INDIRECT_OFFSETS.put(Direction.Axis.Z, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.f_121853_.m_7494_().m_122029_(), BlockPos.f_121853_.m_7494_().m_122024_(), BlockPos.f_121853_.m_7495_().m_122029_(), BlockPos.f_121853_.m_7495_().m_122024_()}));
        for (Direction.Axis axis : Direction.Axis.values()) {
            ArrayList pos = new ArrayList();
            pos.addAll(DIRECT_OFFSETS.get(axis));
            pos.addAll(INDIRECT_OFFSETS.get(axis));
            ALL_OFFSETS.put(axis, pos);
        }
    }
}

