/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.data;

import com.supermartijn642.core.generator.ModelGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.wormhole.targetcell.TargetCellType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class WormholeModelGenerator
extends ModelGenerator {
    public WormholeModelGenerator(ResourceCache cache) {
        super("wormhole", cache);
    }

    public void generate() {
        this.cubeAll("block/portal_frame", new ResourceLocation("wormhole", "portal_frame"));
        this.model("item/portal_frame").parent("block/portal_frame");
        this.model("block/portals/portal_x").parent("minecraft", "block/block").texture("portal", "#all").particleTexture("#all").element(element -> element.shape(6.0f, 0.0f, 0, 10.0f, 16.0f, 16.0f).face(Direction.EAST, face -> face.texture("portal")).face(Direction.WEST, face -> face.texture("portal")));
        this.model("block/portals/portal_y").parent("minecraft", "block/block").texture("portal", "#all").particleTexture("#all").element(element -> element.shape(0.0f, 6.0f, 0, 16.0f, 10.0f, 16.0f).face(Direction.UP, face -> face.texture("portal")).face(Direction.DOWN, face -> face.texture("portal")));
        this.model("block/portals/portal_z").parent("minecraft", "block/block").texture("portal", "#all").particleTexture("#all").element(element -> element.shape(0.0f, 0.0f, 6, 16.0f, 16.0f, 10.0f).face(Direction.NORTH, face -> face.texture("portal")).face(Direction.SOUTH, face -> face.texture("portal")));
        for (DyeColor color : DyeColor.values()) {
            this.model("block/portals/portal_x_" + color.m_41065_()).parent("block/portals/portal_x").texture("all", "portal/portal_" + color.m_41065_());
            this.model("block/portals/portal_y_" + color.m_41065_()).parent("block/portals/portal_y").texture("all", "portal/portal_" + color.m_41065_());
            this.model("block/portals/portal_z_" + color.m_41065_()).parent("block/portals/portal_z").texture("all", "portal/portal_" + color.m_41065_());
        }
        this.model("item/portal").parent("block/portals/portal_x_red");
        this.cubeAll("block/portal_stabilizer_off", new ResourceLocation("wormhole", "portal_stabilizer_off"));
        this.cubeAll("block/portal_stabilizer_on", new ResourceLocation("wormhole", "portal_stabilizer_on"));
        this.model("item/portal_stabilizer").parent("block/portal_stabilizer_off");
        for (int i = 0; i < 16; ++i) {
            this.cubeAll("block/energy_cells/basic_energy_cell_" + i, new ResourceLocation("wormhole", "energy_cells/basic_energy_cell_" + i));
            this.cubeAll("block/energy_cells/advanced_energy_cell_" + i, new ResourceLocation("wormhole", "energy_cells/basic_energy_cell_" + i));
        }
        this.cubeAll("block/energy_cells/creative_energy_cell", new ResourceLocation("wormhole", "energy_cells/basic_energy_cell_15"));
        this.model("item/basic_energy_cell").parent("block/energy_cells/basic_energy_cell_0");
        this.model("item/advanced_energy_cell").parent("block/energy_cells/advanced_energy_cell_0");
        this.model("item/creative_energy_cell").parent("block/energy_cells/creative_energy_cell");
        for (TargetCellType type : TargetCellType.values()) {
            for (int i = 0; i <= type.getVisualCapacity(); ++i) {
                this.cubeAll("block/target_cells/" + type.getRegistryName() + "_" + i, new ResourceLocation("wormhole", "target_cells/" + type.getRegistryName() + "_" + i));
            }
            this.model("item/" + type.getRegistryName()).parent("block/target_cells/" + type.getRegistryName() + "_0");
        }
        this.model("item/coal_generator").parent("block/coal_generator");
        this.itemGenerated("item/target_device", new ResourceLocation("wormhole", "target_device"));
        this.itemGenerated("item/advanced_target_device", new ResourceLocation("wormhole", "advanced_target_device"));
    }
}

