/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.core.EnergyFormat;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.wormhole.StabilizerBlockEntity;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.portal.PortalGroupBlock;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StabilizerBlock
extends PortalGroupBlock {
    public static final BooleanProperty ON_PROPERTY = BooleanProperty.m_61465_((String)"on");

    public StabilizerBlock() {
        super(() -> Wormhole.stabilizer_tile);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ON_PROPERTY, (Comparable)Boolean.valueOf(false)));
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof StabilizerBlockEntity) {
            return ((StabilizerBlockEntity)entity).activate(player) ? BaseBlock.InteractionFeedback.SUCCESS : BaseBlock.InteractionFeedback.PASS;
        }
        return BaseBlock.InteractionFeedback.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ON_PROPERTY});
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)"wormhole.portal_stabilizer.info").color(ChatFormatting.AQUA).get());
        CompoundTag tag = stack.m_41784_().m_128441_("tileData") ? stack.m_41784_().m_128469_("tileData") : null;
        int targets = tag == null || tag.m_128456_() || !tag.m_128441_("targetCount") ? 0 : tag.m_128451_("targetCount");
        int targetCapacity = WormholeConfig.stabilizerTargetCapacity.get();
        if (targetCapacity > 0) {
            info.accept((Component)TextComponents.translation((String)"wormhole.portal_stabilizer.info.targets", (Object[])new Object[]{targets, targetCapacity}).color(ChatFormatting.YELLOW).get());
        }
        int energy = tag == null || tag.m_128456_() || !tag.m_128441_("energy") ? 0 : tag.m_128451_("energy");
        int energyCapacity = WormholeConfig.stabilizerEnergyCapacity.get();
        if (energyCapacity > 0) {
            info.accept((Component)TextComponents.translation((String)EnergyFormat.formatCapacityWithUnit((int)energy, (int)energyCapacity)).color(ChatFormatting.YELLOW).get());
        }
    }
}

